"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TraceExplorerContribution = void 0;
const inversify_1 = require("inversify");
const view_contribution_1 = require("@theia/core/lib/browser/shell/view-contribution");
const trace_explorer_widget_1 = require("./trace-explorer-widget");
const trace_explorer_commands_1 = require("./trace-explorer-commands");
let TraceExplorerContribution = class TraceExplorerContribution extends view_contribution_1.AbstractViewContribution {
    constructor() {
        super({
            widgetId: trace_explorer_widget_1.TraceExplorerWidget.ID,
            widgetName: trace_explorer_widget_1.TraceExplorerWidget.LABEL,
            defaultWidgetOptions: {
                area: 'left'
            },
            toggleCommandId: 'trace-explorer:toggle'
        });
    }
    async initializeLayout(_app) {
        await this.openView({ activate: false });
    }
    registerMenus(menus) {
        super.registerMenus(menus);
        menus.registerMenuAction(trace_explorer_commands_1.TraceExplorerMenus.PREFERENCE_EDITOR_CONTEXT_MENU, {
            commandId: trace_explorer_commands_1.TraceExplorerCommands.OPEN_TRACE.id,
            label: 'Open Trace',
            order: 'a'
        });
        menus.registerMenuAction(trace_explorer_commands_1.TraceExplorerMenus.PREFERENCE_EDITOR_CONTEXT_MENU, {
            commandId: trace_explorer_commands_1.TraceExplorerCommands.CLOSE_TRACE.id,
            label: trace_explorer_commands_1.TraceExplorerCommands.CLOSE_TRACE.label,
            order: 'b'
        });
        menus.registerMenuAction(trace_explorer_commands_1.TraceExplorerMenus.PREFERENCE_EDITOR_CONTEXT_MENU, {
            commandId: trace_explorer_commands_1.TraceExplorerCommands.REMOVE_TRACE.id,
            label: trace_explorer_commands_1.TraceExplorerCommands.REMOVE_TRACE.label,
            order: 'c'
        });
    }
    async registerCommands(registry) {
        super.registerCommands(registry);
        const explorerWidget = await this.widget;
        registry.registerCommand(trace_explorer_commands_1.TraceExplorerCommands.OPEN_TRACE, {
            execute: (traceUUID) => {
                explorerWidget.openExperiment(traceUUID);
            }
        });
        registry.registerCommand(trace_explorer_commands_1.TraceExplorerCommands.CLOSE_TRACE, {
            execute: (traceUUID) => {
                explorerWidget.closeExperiment(traceUUID);
            }
        });
        registry.registerCommand(trace_explorer_commands_1.TraceExplorerCommands.REMOVE_TRACE, {
            execute: (traceUUID) => {
                explorerWidget.deleteExperiment(traceUUID);
            }
        });
    }
};
TraceExplorerContribution = __decorate([
    (0, inversify_1.injectable)(),
    __metadata("design:paramtypes", [])
], TraceExplorerContribution);
exports.TraceExplorerContribution = TraceExplorerContribution;
//# sourceMappingURL=trace-explorer-contribution.js.map