"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TableModel = exports.Line = exports.Cell = exports.ColumnHeaderEntry = void 0;
const serialization_1 = require("../protocol/serialization");
exports.ColumnHeaderEntry = (0, serialization_1.createNormalizer)({
    id: serialization_1.assertNumber,
});
exports.Cell = (0, serialization_1.createNormalizer)({
    tags: serialization_1.assertNumber,
});
exports.Line = (0, serialization_1.createNormalizer)({
    cells: (0, serialization_1.array)(exports.Cell),
    index: serialization_1.assertNumber,
    tags: serialization_1.assertNumber,
});
exports.TableModel = (0, serialization_1.createNormalizer)({
    columnIds: (0, serialization_1.array)(serialization_1.assertNumber),
    lines: (0, serialization_1.array)(exports.Line),
    lowIndex: serialization_1.assertNumber,
    size: serialization_1.assertNumber,
});
//# sourceMappingURL=table.js.map