"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeGraphComponent = void 0;
var PIXI = require("pixi.js-legacy");
var time_graph_render_controller_1 = require("../time-graph-render-controller");
var TimeGraphComponent = /** @class */ (function () {
    function TimeGraphComponent(_id, displayObject, model) {
        this._id = _id;
        this._displayObject = displayObject || new PIXI.Graphics();
        if (model) {
            this._model = model;
        }
    }
    Object.defineProperty(TimeGraphComponent.prototype, "id", {
        get: function () {
            return this._id;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TimeGraphComponent.prototype, "displayObject", {
        get: function () {
            return this._displayObject;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TimeGraphComponent.prototype, "model", {
        get: function () {
            return this._model;
        },
        enumerable: false,
        configurable: true
    });
    TimeGraphComponent.prototype.clear = function () {
        this._displayObject.clear();
    };
    TimeGraphComponent.prototype.destroy = function () {
        this._displayObject.destroy({ children: true });
    };
    TimeGraphComponent.prototype.update = function (opts) {
        if (opts) {
            this._options = opts;
        }
        this.clear();
        this.render();
        this.startPixiRender();
    };
    TimeGraphComponent.prototype.startPixiRender = function () {
        time_graph_render_controller_1.RenderEvents.startRender();
    };
    TimeGraphComponent.prototype.rect = function (opts) {
        var position = opts.position, width = opts.width, height = opts.height, color = opts.color, opacity = opts.opacity, borderColor = opts.borderColor, borderWidth = opts.borderWidth;
        this.displayObject.lineStyle(borderWidth || 0, borderColor || 0x000000);
        this.displayObject.beginFill((color || 0xffffff), this.getPIXIOpacity(opacity));
        this.displayObject.drawRect(position.x, position.y, width, height);
        this.displayObject.endFill();
        this.startPixiRender();
    };
    TimeGraphComponent.prototype.rectTruncated = function (opts) {
        var position = opts.position, width = opts.width, height = opts.height, color = opts.color, opacity = opts.opacity, borderColor = opts.borderColor, borderWidth = opts.borderWidth;
        this.displayObject.lineStyle(borderWidth || 0, borderColor || 0x000000);
        this.displayObject.beginFill((color || 0xffffff), this.getPIXIOpacity(opacity));
        if (width > 20) {
            var xpos = position.x + 0.5;
            var ypos = position.y + 0.5;
            var edge = 2;
            this.displayObject.drawPolygon([xpos + edge, ypos,
                xpos + width, ypos, xpos + width, ypos + height, xpos, ypos + height, xpos, ypos + edge, xpos + edge, ypos]);
        }
        else {
            this.displayObject.drawRect(position.x + 0.5, position.y + 0.5, width, height);
        }
        this.displayObject.endFill();
        this.startPixiRender();
    };
    TimeGraphComponent.prototype.roundedRect = function (opts) {
        var position = opts.position, width = opts.width, height = opts.height, color = opts.color, opacity = opts.opacity, borderColor = opts.borderColor, borderWidth = opts.borderWidth, borderRadius = opts.borderRadius;
        this.displayObject.lineStyle(borderWidth || 0, borderColor || 0x000000);
        this.displayObject.beginFill((color || 0xffffff), this.getPIXIOpacity(opacity));
        this.displayObject.drawRoundedRect(position.x + 0.5, position.y + 0.5, width, height, borderRadius || 0);
        this.displayObject.endFill();
        this.startPixiRender();
    };
    TimeGraphComponent.prototype.hline = function (opts) {
        var position = opts.position, width = opts.width, thickness = opts.thickness, color = opts.color, opacity = opts.opacity;
        this.displayObject.lineStyle(thickness || 1, color || 0x000000, this.getPIXIOpacity(opacity));
        this.displayObject.moveTo(position.x, position.y + 0.5);
        this.displayObject.lineTo(position.x + width, position.y + 0.5);
        this.startPixiRender();
    };
    TimeGraphComponent.prototype.vline = function (opts) {
        var position = opts.position, height = opts.height, thickness = opts.thickness, color = opts.color, opacity = opts.opacity;
        this.displayObject.lineStyle(thickness || 1, color || 0x000000, this.getPIXIOpacity(opacity));
        this.displayObject.moveTo(position.x + 0.5, position.y);
        this.displayObject.lineTo(position.x + 0.5, position.y + height);
        this.startPixiRender();
    };
    /**
     * Get the PIXIjs friendly opacity. This is a workaround to PIXIjs 5 setting opacity to 0 meaning interractions are not recognized.
     *
     * @param opacity a number meaning the desired opacity. If it is undefined, assume it is 100% opacity
     */
    TimeGraphComponent.prototype.getPIXIOpacity = function (opacity) {
        return (opacity !== undefined ? opacity == 0 ? 0.001 : opacity : 1);
    };
    TimeGraphComponent.prototype.addEvent = function (event, handler, displayObject) {
        displayObject.interactive = true;
        displayObject.on(event, (function (e) {
            if (handler) {
                handler(e);
            }
        }).bind(this));
    };
    return TimeGraphComponent;
}());
exports.TimeGraphComponent = TimeGraphComponent;
//# sourceMappingURL=time-graph-component.js.map