"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeGraphRow = void 0;
var time_graph_component_1 = require("./time-graph-component");
var TimeGraphRow = /** @class */ (function (_super) {
    __extends(TimeGraphRow, _super);
    function TimeGraphRow(id, _options, _rowIndex, model, _style) {
        if (_style === void 0) { _style = { lineOpacity: 0.5, lineThickness: 1, backgroundOpacity: 0 }; }
        var _this = _super.call(this, id, undefined, model) || this;
        _this._options = _options;
        _this._rowIndex = _rowIndex;
        _this._style = _style;
        _this._rowStateComponents = new Map();
        _this._rowAnnotationComponents = new Map();
        return _this;
    }
    Object.defineProperty(TimeGraphRow.prototype, "rowIndex", {
        get: function () {
            return this._rowIndex;
        },
        enumerable: false,
        configurable: true
    });
    TimeGraphRow.prototype.render = function () {
        this.rect({
            color: this._style.backgroundColor,
            opacity: this._style.backgroundOpacity,
            height: this._options.height,
            width: this._options.width,
            position: this._options.position
        });
        this.hline({
            color: this._style.lineColor || 0xeeeeee,
            opacity: this._style.lineOpacity || 0.5,
            thickness: this._style.lineThickness || 1,
            width: this._options.width,
            position: {
                x: this._options.position.x,
                y: this._options.position.y + (this._options.height / 2)
            }
        });
    };
    Object.defineProperty(TimeGraphRow.prototype, "position", {
        get: function () {
            return this._options.position;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TimeGraphRow.prototype, "height", {
        get: function () {
            return this._options.height;
        },
        enumerable: false,
        configurable: true
    });
    TimeGraphRow.prototype.addChild = function (child) {
        this._displayObject.addChild(child.displayObject);
        child.update();
    };
    TimeGraphRow.prototype.removeChild = function (child) {
        this._displayObject.removeChild(child.displayObject);
        child.destroy();
    };
    TimeGraphRow.prototype.addState = function (stateComponent) {
        this._rowStateComponents.set(stateComponent.id, stateComponent);
        this.addChild(stateComponent);
    };
    TimeGraphRow.prototype.removeState = function (stateComponent) {
        this._rowStateComponents.delete(stateComponent.id);
        this.removeChild(stateComponent);
    };
    TimeGraphRow.prototype.getStateById = function (id) {
        return this._rowStateComponents.get(id);
    };
    TimeGraphRow.prototype.addAnnotation = function (annotationComponent) {
        this._rowAnnotationComponents.set(annotationComponent.id, annotationComponent);
        this.addChild(annotationComponent);
    };
    TimeGraphRow.prototype.removeAnnotation = function (annotationComponent) {
        this._rowAnnotationComponents.delete(annotationComponent.id);
        this.removeChild(annotationComponent);
    };
    TimeGraphRow.prototype.getAnnotationById = function (id) {
        return this._rowAnnotationComponents.get(id);
    };
    Object.defineProperty(TimeGraphRow.prototype, "style", {
        get: function () {
            return this._style;
        },
        set: function (style) {
            if (style.backgroundColor !== undefined) {
                this._options.color = style.backgroundColor;
                this._style.backgroundColor = style.backgroundColor;
            }
            if (style.backgroundOpacity !== undefined) {
                this._style.backgroundOpacity = style.backgroundOpacity;
            }
            if (style.lineColor) {
                this._style.lineColor = style.lineColor;
            }
            if (style.lineOpacity) {
                this._style.lineOpacity = style.lineOpacity;
            }
            if (style.lineThickness) {
                this._style.lineThickness = style.lineThickness;
            }
            this.update();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TimeGraphRow.prototype, "providedModel", {
        get: function () {
            return this._providedModel;
        },
        set: function (providedModel) {
            this._providedModel = providedModel;
        },
        enumerable: false,
        configurable: true
    });
    return TimeGraphRow;
}(time_graph_component_1.TimeGraphComponent));
exports.TimeGraphRow = TimeGraphRow;
//# sourceMappingURL=time-graph-row.js.map