"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeGraphRangeEventsLayer = void 0;
var time_graph_rectangle_1 = require("../components/time-graph-rectangle");
var time_graph_layer_1 = require("./time-graph-layer");
var TimeGraphRangeEventsLayer = /** @class */ (function (_super) {
    __extends(TimeGraphRangeEventsLayer, _super);
    function TimeGraphRangeEventsLayer(id, providers) {
        var _this = _super.call(this, id) || this;
        _this.providers = providers;
        return _this;
    }
    TimeGraphRangeEventsLayer.prototype.afterAddToContainer = function () {
        var _this = this;
        this._viewRangeUpdateHandler = function () { return _this.update(); };
        this.unitController.onViewRangeChanged(this._viewRangeUpdateHandler);
    };
    TimeGraphRangeEventsLayer.prototype.addRangeEvent = function (rangeEvent) {
        var start = this.getPixel(rangeEvent.range.start - this.unitController.viewRange.start);
        var end = this.getPixel(rangeEvent.range.end - this.unitController.viewRange.start);
        var width = end - start;
        var elementStyle = this.providers.rowAnnotationStyleProvider ? this.providers.rowAnnotationStyleProvider(rangeEvent) : undefined;
        var rangeEventComponent = new time_graph_rectangle_1.TimeGraphRectangle({
            color: (elementStyle ? elementStyle.color : 0x000000),
            opacity: (elementStyle ? elementStyle.opacity : 1.0),
            position: {
                x: start,
                y: 0
            },
            height: this.stateController.canvasDisplayHeight,
            width: width
        });
        this.rangeEvents.set(rangeEvent, rangeEventComponent);
        this.addChild(rangeEventComponent);
    };
    TimeGraphRangeEventsLayer.prototype.addRangeEvents = function (rangeEvents) {
        var _this = this;
        if (!this.stateController) {
            throw ('Add the TimeGraphRangeEventsLayer to a container before adding range events.');
        }
        if (this.rangeEvents) {
            this.removeChildren();
        }
        this.rangeEvents = new Map();
        rangeEvents.forEach(function (range) {
            _this.addRangeEvent(range);
        });
    };
    TimeGraphRangeEventsLayer.prototype.update = function () {
        var e_1, _a;
        if (this.rangeEvents) {
            try {
                for (var _b = __values(this.rangeEvents.keys()), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var range = _c.value;
                    this.updateRangeEvent(range);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }
    };
    TimeGraphRangeEventsLayer.prototype.updateRangeEvent = function (rangeEvent) {
        var rangeEventComponent = this.rangeEvents.get(rangeEvent);
        var start = this.getPixel(rangeEvent.range.start - this.unitController.viewRange.start);
        var end = this.getPixel(rangeEvent.range.end - this.unitController.viewRange.start);
        var width = end - start;
        if (rangeEventComponent) {
            rangeEventComponent.update({
                position: {
                    x: start,
                    y: 0
                },
                height: this.stateController.canvasDisplayHeight,
                width: width
            });
        }
    };
    TimeGraphRangeEventsLayer.prototype.destroy = function () {
        if (this.unitController) {
            this.unitController.removeViewRangeChangedHandler(this._viewRangeUpdateHandler);
        }
        _super.prototype.destroy.call(this);
    };
    return TimeGraphRangeEventsLayer;
}(time_graph_layer_1.TimeGraphLayer));
exports.TimeGraphRangeEventsLayer = TimeGraphRangeEventsLayer;
//# sourceMappingURL=time-graph-range-events-layer.js.map