"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TraceContextComponent = void 0;
const React = __importStar(require("react"));
require("../../style/trace-viewer.css");
require("../../style/trace-context-style.css");
require("../../style/output-components-style.css");
require("../../style/trace-explorer.css");
require("../../style/status-bar.css");
const react_grid_layout_1 = require("react-grid-layout");
const time_graph_unit_controller_1 = require("timeline-chart/lib/time-graph-unit-controller");
const time_range_1 = require("traceviewer-base/lib/utils/time-range");
const table_output_component_1 = require("./table-output-component");
const timegraph_output_component_1 = require("./timegraph-output-component");
const time_axis_component_1 = require("./utils/time-axis-component");
const time_navigator_component_1 = require("./utils/time-navigator-component");
const xy_output_component_1 = require("./xy-output-component");
const null_output_component_1 = require("./null-output-component");
const Messages = __importStar(require("traceviewer-base/lib/message-manager"));
const signal_manager_1 = require("traceviewer-base/lib/signals/signal-manager");
const react_tooltip_1 = __importDefault(require("react-tooltip"));
const tooltip_component_1 = require("./tooltip-component");
const tooltip_xy_component_1 = require("./tooltip-xy-component");
const bigint_utils_1 = require("timeline-chart/lib/bigint-utils");
const datatree_output_component_1 = require("./datatree-output-component");
const lodash_1 = require("lodash");
const unit_controller_history_handler_1 = require("./utils/unit-controller-history-handler");
const trace_overview_component_1 = require("./trace-overview-component");
const ResponsiveGridLayout = (0, react_grid_layout_1.WidthProvider)(react_grid_layout_1.Responsive);
class TraceContextComponent extends React.Component {
    constructor(props) {
        var _a;
        super(props);
        this.INDEXING_RUNNING_STATUS = 'RUNNING';
        this.INDEXING_CLOSED_STATUS = 'CLOSED';
        this.INDEXING_STATUS_BAR_KEY = 'indexing-status';
        this.TIME_SELECTION_STATUS_BAR_KEY = 'time-selection-range';
        this.OVERVIEW_OUTPUT_GRID_LAYOUT_ID = 'Overview';
        this.DEFAULT_COMPONENT_HEIGHT = 10;
        this.DEFAULT_COMPONENT_ROWHEIGHT = 20;
        this.DEFAULT_OVERVIEW_HEIGHT = 7;
        this.DEFAULT_OVERVIEW_ROWHEIGHT = 14;
        this.DEFAULT_COMPONENT_LEFT = 0;
        this.SCROLLBAR_PADDING = 12;
        this.DEFAULT_CHART_OFFSET = 200;
        this.MIN_COMPONENT_HEIGHT = 2;
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        this.chartPersistedState = undefined;
        this._storedTimescaleLayout = [];
        this._storedNonTimescaleLayout = [];
        this._storedPinnedViewLayout = undefined;
        this._storedOverviewLayout = undefined;
        this.widgetResizeHandlers = [];
        this.addWidgetResizeHandler = (h) => {
            this.widgetResizeHandlers.push(h);
        };
        this.removeWidgetResizeHandler = (h) => {
            const index = this.widgetResizeHandlers.indexOf(h, 0);
            if (index > -1) {
                this.widgetResizeHandlers.splice(index, 1);
            }
        };
        this.onBackgroundThemeChange = (theme) => this.doHandleBackgroundThemeChange(theme);
        this.onUpdateZoom = (hasZoomedIn) => this.doHandleUpdateZoomSignal(hasZoomedIn);
        this.onResetZoom = () => this.doHandleResetZoomSignal();
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        this.onPinView = (output, payload) => this.doHandlePinView(output, payload);
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        this.onUnPinView = (output, payload) => this.doHandleUnPinView(output, payload);
        this.undoHistory = () => {
            this.historyHandler.undo();
        };
        this.redoHistory = () => {
            this.historyHandler.redo();
        };
        this.updateHistory = () => {
            this.historyHandler.addCurrentState();
        };
        let traceRange = new time_range_1.TimeRange();
        let viewRange = new time_range_1.TimeRange();
        let timeSelection = undefined;
        let curPinnedView = undefined;
        if (this.props.experiment) {
            const experiment = this.props.experiment;
            traceRange = new time_range_1.TimeRange(experiment.start - this.props.experiment.start, experiment.end - this.props.experiment.start, this.props.experiment.start);
            viewRange = new time_range_1.TimeRange(experiment.start - this.props.experiment.start, experiment.end - this.props.experiment.start, this.props.experiment.start);
            if (this.props.persistedState) {
                const { currentRange: storedRange, currentViewRange: storedViewRange, currentTimeSelection: storedTimeSelection, pinnedView: storedPinnedView, storedTimescaleLayout, storedNonTimescaleLayout, storedPinnedViewLayout, storedOverviewLayout } = this.props.persistedState;
                traceRange = new time_range_1.TimeRange(storedRange);
                viewRange = new time_range_1.TimeRange(storedViewRange);
                if (storedTimeSelection) {
                    timeSelection = new time_range_1.TimeRange(storedTimeSelection);
                }
                this._storedTimescaleLayout = storedTimescaleLayout;
                this._storedNonTimescaleLayout = storedNonTimescaleLayout;
                curPinnedView = storedPinnedView;
                this._storedPinnedViewLayout = storedPinnedViewLayout;
                this._storedOverviewLayout = storedOverviewLayout;
            }
        }
        this.state = {
            timeOffset: this.props.experiment.start,
            currentRange: traceRange,
            currentViewRange: viewRange,
            currentTimeSelection: timeSelection,
            experiment: this.props.experiment,
            pinnedView: curPinnedView,
            traceIndexing: ((this.props.experiment.indexingStatus === this.INDEXING_RUNNING_STATUS) || (this.props.experiment.indexingStatus === this.INDEXING_CLOSED_STATUS)),
            style: {
                width: 0,
                chartOffset: this.DEFAULT_CHART_OFFSET,
                componentLeft: this.DEFAULT_COMPONENT_LEFT,
                height: this.DEFAULT_COMPONENT_HEIGHT,
                rowHeight: this.DEFAULT_COMPONENT_ROWHEIGHT,
                naviBackgroundColor: this.props.backgroundTheme === 'light' ? 0xf4f7fb : 0x3f3f3f,
                chartBackgroundColor: this.props.backgroundTheme === 'light' ? 0xf4f7fb : 0x232323,
                cursorColor: 0x259fd8,
                lineColor: this.props.backgroundTheme === 'light' ? 0x757575 : 0xbbbbbb
            },
            backgroundTheme: this.props.backgroundTheme,
        };
        const absoluteRange = traceRange.getDuration();
        this.unitController = new time_graph_unit_controller_1.TimeGraphUnitController(absoluteRange, { start: BigInt(0), end: absoluteRange });
        this.unitController.numberTranslator = (theNumber) => {
            const originalStart = this.state.currentRange.getStart();
            theNumber += originalStart;
            const zeroPad = (num) => String(num).padStart(3, '0');
            const seconds = theNumber / BigInt(1000000000);
            const millis = zeroPad((theNumber / BigInt(1000000)) % BigInt(1000));
            const micros = zeroPad((theNumber / BigInt(1000)) % BigInt(1000));
            const nanos = zeroPad(theNumber % BigInt(1000));
            return seconds + '.' + millis + ' ' + micros + ' ' + nanos;
        };
        this.historyHandler = new unit_controller_history_handler_1.UnitControllerHistoryHandler(this.unitController);
        if ((_a = this.props.persistedState) === null || _a === void 0 ? void 0 : _a.currentTimeSelection) {
            const { start, end } = this.props.persistedState.currentTimeSelection;
            this.unitController.selectionRange = { start: BigInt(start), end: BigInt(end) };
        }
        this.unitController.onSelectionRangeChange(range => { this.handleTimeSelectionChange(range); });
        this.unitController.onViewRangeChanged(viewRangeParam => { this.handleViewRangeChange(viewRangeParam); });
        this.tooltipComponent = React.createRef();
        this.tooltipXYComponent = React.createRef();
        this.traceContextContainer = React.createRef();
        this.onResize = this.onResize.bind(this);
        this.setChartOffset = this.setChartOffset.bind(this);
        this.onLayoutChange = this.onLayoutChange.bind(this);
        this.props.addResizeHandler(this.onResize);
        this.initialize();
        this.subscribeToEvents();
    }
    doHandleBackgroundThemeChange(theme) {
        this.setState(prevState => ({
            style: Object.assign(Object.assign({}, prevState.style), { naviBackgroundColor: theme === 'light' ? 0xf4f7fb : 0x3f3f3f, chartBackgroundColor: theme === 'light' ? 0xf4f7fb : 0x232323, lineColor: theme === 'light' ? 0x757575 : 0xbbbbbb }),
            backgroundTheme: theme
        }));
    }
    async initialize() {
        await this.updateTrace();
        this.unitController.absoluteRange = this.state.experiment.end - this.state.timeOffset;
        this.unitController.offset = this.state.timeOffset;
        if (this.props.persistedState) {
            const { start, end } = this.props.persistedState.unitControllerViewRange;
            this.unitController.viewRange = { start: BigInt(start), end: BigInt(end) };
        }
        else {
            this.unitController.viewRange = { start: BigInt(0), end: this.state.experiment.end - this.state.timeOffset };
        }
        this.historyHandler.clear();
        this.historyHandler.addCurrentState();
    }
    async updateTrace() {
        if (this.state.traceIndexing) {
            let isIndexing = true;
            while (isIndexing) {
                const tspClientResponse = await this.props.tspClient.fetchExperiment(this.props.experiment.UUID);
                const updatedExperiment = tspClientResponse.getModel();
                if (tspClientResponse.isOk() && updatedExperiment) {
                    isIndexing = updatedExperiment.indexingStatus === this.INDEXING_RUNNING_STATUS;
                    this.setState({
                        timeOffset: updatedExperiment.start,
                        experiment: updatedExperiment,
                        traceIndexing: isIndexing,
                        currentRange: new time_range_1.TimeRange(updatedExperiment.start - updatedExperiment.start, updatedExperiment.end - updatedExperiment.start, updatedExperiment.start)
                    });
                    // Update status bar
                    this.props.messageManager.addStatusMessage(this.INDEXING_STATUS_BAR_KEY, {
                        text: `Indexing ${this.props.experiment.name}: ${this.state.experiment.nbEvents}`,
                        category: Messages.MessageCategory.SERVER_MESSAGE
                    });
                    await this.sleep(500);
                }
                else {
                    break;
                }
            }
        }
        this.props.messageManager.removeStatusMessage(this.INDEXING_STATUS_BAR_KEY);
    }
    async sleep(ms) {
        return new Promise(resolve => setTimeout(resolve, ms));
    }
    componentDidMount() {
        this.onResize();
    }
    componentWillUnmount() {
        this.props.messageManager.removeStatusMessage(this.INDEXING_STATUS_BAR_KEY);
        this.props.messageManager.removeStatusMessage(this.TIME_SELECTION_STATUS_BAR_KEY);
        this.props.removeResizeHandler(this.onResize);
        this.unsubscribeToEvents();
    }
    subscribeToEvents() {
        (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.THEME_CHANGED, this.onBackgroundThemeChange);
        (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.UPDATE_ZOOM, this.onUpdateZoom);
        (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.RESET_ZOOM, this.onResetZoom);
        (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.UNDO, this.undoHistory);
        (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.REDO, this.redoHistory);
        (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.PIN_VIEW, this.onPinView);
        (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.UNPIN_VIEW, this.onUnPinView);
    }
    unsubscribeToEvents() {
        (0, signal_manager_1.signalManager)().off(signal_manager_1.Signals.THEME_CHANGED, this.onBackgroundThemeChange);
        (0, signal_manager_1.signalManager)().off(signal_manager_1.Signals.UPDATE_ZOOM, this.onUpdateZoom);
        (0, signal_manager_1.signalManager)().off(signal_manager_1.Signals.RESET_ZOOM, this.onResetZoom);
        (0, signal_manager_1.signalManager)().off(signal_manager_1.Signals.UNDO, this.undoHistory);
        (0, signal_manager_1.signalManager)().off(signal_manager_1.Signals.REDO, this.redoHistory);
        (0, signal_manager_1.signalManager)().off(signal_manager_1.Signals.PIN_VIEW, this.onPinView);
        (0, signal_manager_1.signalManager)().off(signal_manager_1.Signals.UNPIN_VIEW, this.onUnPinView);
    }
    async componentDidUpdate(prevProps, prevState) {
        // Rebuild enables tooltip on newly added output component
        react_tooltip_1.default.rebuild();
        if (prevProps.outputs.length < this.props.outputs.length) {
            // added a new output - scroll to bottom
            this.scrollToBottom();
        }
        else if (prevProps.outputs.length === this.props.outputs.length &&
            prevState.pinnedView === undefined && this.state.pinnedView !== undefined) {
            // one of the existing outputs is pinned to top - scroll to top
            this.scrollToPinnedView();
        }
        else if (prevProps.outputs.length === this.props.outputs.length &&
            prevState.pinnedView !== undefined && this.state.pinnedView === undefined) {
            // one of the existing outputs is unpinned - scroll to unpinned output
            this.scrollToUnPinnedView(prevState.pinnedView);
        }
    }
    scrollToBottom() {
        var _a;
        if (this.props.outputs.length) {
            const bottomOutputId = this.props.outputs[this.props.outputs.length - 1].id;
            (_a = document.getElementById(this.state.experiment.UUID + bottomOutputId)) === null || _a === void 0 ? void 0 : _a.focus();
        }
    }
    scrollToPinnedView() {
        var _a;
        if (this.state.pinnedView) {
            (_a = document.getElementById(this.state.experiment.UUID + this.state.pinnedView.id)) === null || _a === void 0 ? void 0 : _a.focus();
        }
    }
    scrollToUnPinnedView(view) {
        var _a;
        if (view) {
            (_a = document.getElementById(this.state.experiment.UUID + view.id)) === null || _a === void 0 ? void 0 : _a.focus();
        }
    }
    doHandleUpdateZoomSignal(hasZoomedIn) {
        this.zoomButton(hasZoomedIn);
    }
    doHandleResetZoomSignal() {
        this.unitController.viewRange = { start: BigInt(0), end: this.unitController.absoluteRange };
    }
    zoomButton(zoomIn) {
        let position = (this.unitController.viewRange.end + this.unitController.viewRange.start) / BigInt(2);
        if (this.unitController.selectionRange) {
            const positionMiddleSelection = (this.unitController.selectionRange.end + this.unitController.selectionRange.start) / BigInt(2);
            if (positionMiddleSelection >= this.unitController.viewRange.start && positionMiddleSelection <= this.unitController.viewRange.end) {
                position = positionMiddleSelection;
            }
        }
        const startDistance = position - this.unitController.viewRange.start;
        const zoomFactor = zoomIn ? 0.8 : 1.25;
        const newDuration = bigint_utils_1.BIMath.clamp(Number(this.unitController.viewRangeLength) * zoomFactor, BigInt(2), this.unitController.absoluteRange);
        const newStartRange = bigint_utils_1.BIMath.max(0, position - bigint_utils_1.BIMath.round(Number(startDistance) * zoomFactor));
        const newEndRange = newStartRange + newDuration;
        this.unitController.viewRange = { start: newStartRange, end: newEndRange };
    }
    onResize() {
        const newWidth = this.traceContextContainer.current ? this.traceContextContainer.current.clientWidth - this.SCROLLBAR_PADDING : 0;
        const bounds = this.traceContextContainer.current ? this.traceContextContainer.current.getBoundingClientRect() : { left: this.DEFAULT_COMPONENT_LEFT };
        this.setState(prevState => ({ style: Object.assign(Object.assign({}, prevState.style), { width: newWidth, componentLeft: bounds.left }) }));
        this.widgetResizeHandlers.forEach(h => h());
    }
    setChartOffset(chartOffset) {
        this.setState(prevState => ({ style: Object.assign(Object.assign({}, prevState.style), { chartOffset: chartOffset }) }));
        this.widgetResizeHandlers.forEach(h => h());
    }
    handleTimeSelectionChange(range) {
        if (range) {
            const t1 = range.start + this.state.timeOffset;
            const t2 = range.end + this.state.timeOffset;
            this.props.messageManager.addStatusMessage(this.TIME_SELECTION_STATUS_BAR_KEY, {
                text: `T1: ${t1} T2: ${t2} Delta: ${t2 - t1}`,
                category: Messages.MessageCategory.TRACE_CONTEXT
            });
            this.setState(prevState => ({
                currentTimeSelection: new time_range_1.TimeRange(range.start, range.end, prevState.timeOffset)
            }), () => this.updateHistory());
        }
    }
    handleViewRangeChange(viewRange) {
        this.setState(prevState => ({
            currentViewRange: new time_range_1.TimeRange(viewRange.start, viewRange.end, prevState.timeOffset)
        }), () => this.updateHistory());
    }
    onContextMenu(event) {
        event.preventDefault();
    }
    onLayoutChange(currentLayout) {
        if (currentLayout.length > 0) {
            const curLayoutCopy = (0, lodash_1.cloneDeep)(currentLayout);
            if (this._storedPinnedViewLayout && this._storedPinnedViewLayout.i === currentLayout[0].i) {
                this._storedPinnedViewLayout = curLayoutCopy[0];
            }
            else if (this._storedOverviewLayout && this._storedOverviewLayout.i === currentLayout[0].i) {
                this._storedOverviewLayout = curLayoutCopy[0];
            }
            else if (this._storedTimescaleLayout.find(obj => obj.i === currentLayout[0].i)) {
                this._storedTimescaleLayout = curLayoutCopy;
            }
            else {
                this._storedNonTimescaleLayout = curLayoutCopy;
            }
        }
    }
    render() {
        const shouldRenderOutputs = (this.state.style.width > 0 && (this.props.outputs.length || this.props.overviewDescriptor));
        return React.createElement("div", { className: 'trace-context-container', onContextMenu: event => this.onContextMenu(event), onKeyDown: event => this.onKeyDown(event), onKeyUp: event => this.onKeyUp(event), ref: this.traceContextContainer },
            React.createElement(tooltip_component_1.TooltipComponent, { ref: this.tooltipComponent }),
            React.createElement(tooltip_xy_component_1.TooltipXYComponent, { ref: this.tooltipXYComponent }),
            shouldRenderOutputs ? this.renderOutputs() : this.renderPlaceHolder());
    }
    onKeyDown(event) {
        switch (event.key) {
            case '+':
            case '=': {
                this.zoomButton(true);
                break;
            }
            case '-':
            case '_': {
                this.zoomButton(false);
                break;
            }
            case 'z': {
                this.zoomToSelected();
                break;
            }
        }
    }
    onKeyUp(event) {
        if (event.ctrlKey) {
            switch (event.key) {
                case 'z': {
                    this.undoHistory();
                    break;
                }
                case 'Z': {
                    if (event.shiftKey) {
                        this.redoHistory();
                        break;
                    }
                }
                case 'y': {
                    this.redoHistory();
                    break;
                }
            }
        }
    }
    zoomToSelected() {
        const newZoom = this.unitController.selectionRange;
        if (newZoom) {
            this.unitController.viewRange = newZoom;
        }
    }
    renderOutputs() {
        var _a, _b, _c;
        this.generateGridLayout();
        const chartWidth = Math.max(0, this.state.style.width - this.state.style.chartOffset);
        const timeScaleCharts = [];
        const nonTimeScaleCharts = [];
        for (const output of this.props.outputs) {
            if (((_a = this.state.pinnedView) === null || _a === void 0 ? void 0 : _a.id) === output.id) {
                continue;
            }
            else if (output.type === 'TIME_GRAPH' || output.type === 'TREE_TIME_XY') {
                timeScaleCharts.push(output);
            }
            else {
                nonTimeScaleCharts.push(output);
            }
        }
        const pinnedViewTimeScale = ((_b = this.state.pinnedView) === null || _b === void 0 ? void 0 : _b.type) === 'TIME_GRAPH' || ((_c = this.state.pinnedView) === null || _c === void 0 ? void 0 : _c.type) === 'TREE_TIME_XY';
        const timeScaleChartExists = timeScaleCharts.length > 0 || pinnedViewTimeScale;
        return React.createElement(React.Fragment, null,
            this.props.overviewDescriptor && this._storedOverviewLayout &&
                // Margin required to have the close button clickable, else overlapped by the tooltip container
                React.createElement("div", { style: { marginTop: '30px' } }, this.renderGridLayout([this.props.overviewDescriptor], [this._storedOverviewLayout], true)),
            this.state.pinnedView !== undefined && this._storedPinnedViewLayout !== undefined &&
                !pinnedViewTimeScale &&
                React.createElement("div", { className: 'pinned-views-layout', style: { marginTop: (!this.props.overviewDescriptor) ? '30px' : '0px' } }, this.renderGridLayout([this.state.pinnedView], [this._storedPinnedViewLayout])),
            timeScaleChartExists &&
                React.createElement(React.Fragment, null,
                    React.createElement("div", { style: { marginLeft: this.state.style.chartOffset, marginRight: this.SCROLLBAR_PADDING } },
                        React.createElement(time_axis_component_1.TimeAxisComponent, { unitController: this.unitController, style: Object.assign(Object.assign({}, this.state.style), { width: chartWidth, verticalAlign: 'bottom' }), addWidgetResizeHandler: this.addWidgetResizeHandler, removeWidgetResizeHandler: this.removeWidgetResizeHandler }))),
            this.state.pinnedView !== undefined && this._storedPinnedViewLayout !== undefined &&
                pinnedViewTimeScale &&
                React.createElement("div", { className: 'pinned-views-layout' }, this.renderGridLayout([this.state.pinnedView], [this._storedPinnedViewLayout])),
            React.createElement("div", { className: 'outputs-grid-layout' },
                timeScaleCharts.length > 0 &&
                    React.createElement(React.Fragment, null, this.renderGridLayout(timeScaleCharts, this._storedTimescaleLayout)),
                timeScaleChartExists &&
                    React.createElement(React.Fragment, null,
                        React.createElement("div", { className: 'sticky-div', style: { marginLeft: this.state.style.chartOffset, marginRight: this.SCROLLBAR_PADDING } },
                            React.createElement(time_navigator_component_1.TimeNavigatorComponent, { unitController: this.unitController, style: Object.assign(Object.assign({}, this.state.style), { width: chartWidth }), addWidgetResizeHandler: this.addWidgetResizeHandler, removeWidgetResizeHandler: this.removeWidgetResizeHandler }))),
                nonTimeScaleCharts.length > 0 &&
                    React.createElement("div", { style: { marginTop: (!timeScaleChartExists && this.state.pinnedView === undefined && !this.props.overviewDescriptor) ? '30px' : '0px' } }, this.renderGridLayout(nonTimeScaleCharts, this._storedNonTimescaleLayout))));
    }
    renderGridLayout(outputs, layout, isOverview) {
        const rowHeight = isOverview ? this.DEFAULT_OVERVIEW_ROWHEIGHT : this.DEFAULT_COMPONENT_ROWHEIGHT;
        return React.createElement(ResponsiveGridLayout, { margin: [0, 5], isResizable: true, isDraggable: true, resizeHandles: ['se', 's', 'sw'], onLayoutChange: this.onLayoutChange, layouts: { lg: layout }, cols: { lg: 1 }, breakpoints: { lg: 1200 }, rowHeight: rowHeight, draggableHandle: '.title-bar-label' }, outputs.map(output => {
            var _a, _b, _c, _d, _e;
            let onOutputRemove;
            let responseType;
            if (isOverview) {
                onOutputRemove = this.props.onOverviewRemove;
                responseType = 'OVERVIEW';
            }
            else {
                onOutputRemove = this.props.onOutputRemove;
                responseType = output.type;
            }
            const outputProps = {
                tspClient: this.props.tspClient,
                tooltipComponent: this.tooltipComponent.current,
                tooltipXYComponent: this.tooltipXYComponent.current,
                traceId: this.state.experiment.UUID,
                traceName: this.props.experiment.name,
                outputDescriptor: output,
                markerCategories: this.props.markerCategoriesMap.get(output.id),
                markerSetId: this.props.markerSetId,
                range: this.state.currentRange,
                nbEvents: this.state.experiment.nbEvents,
                viewRange: this.state.currentViewRange,
                selectionRange: this.state.currentTimeSelection,
                style: this.state.style,
                onOutputRemove: onOutputRemove,
                unitController: this.unitController,
                outputWidth: this.state.style.width,
                backgroundTheme: this.state.backgroundTheme,
                setChartOffset: this.setChartOffset,
                pinned: this.state.pinnedView ? (this.state.pinnedView === output) : undefined
            };
            switch (responseType) {
                case 'OVERVIEW':
                    return React.createElement(trace_overview_component_1.TraceOverviewComponent, Object.assign({ key: this.OVERVIEW_OUTPUT_GRID_LAYOUT_ID, experiment: this.props.experiment }, outputProps));
                case 'TIME_GRAPH':
                    if (this.chartPersistedState && this.chartPersistedState.output.id === output.id) {
                        outputProps.persistChartState = this.chartPersistedState.payload;
                        this.chartPersistedState = undefined;
                    }
                    return React.createElement(timegraph_output_component_1.TimegraphOutputComponent, Object.assign({ key: output.id }, outputProps, { addWidgetResizeHandler: this.addWidgetResizeHandler, removeWidgetResizeHandler: this.removeWidgetResizeHandler, className: ((_a = this.state.pinnedView) === null || _a === void 0 ? void 0 : _a.id) === output.id ? 'pinned-view-shadow' : '' }));
                case 'TREE_TIME_XY':
                    if (this.chartPersistedState && this.chartPersistedState.output.id === output.id) {
                        outputProps.persistChartState = this.chartPersistedState.payload;
                        this.chartPersistedState = undefined;
                    }
                    return React.createElement(xy_output_component_1.XYOutputComponent, Object.assign({ key: output.id }, outputProps, { className: ((_b = this.state.pinnedView) === null || _b === void 0 ? void 0 : _b.id) === output.id ? 'pinned-view-shadow' : '' }));
                case 'TABLE':
                    return React.createElement(table_output_component_1.TableOutputComponent, Object.assign({ key: output.id }, outputProps, { className: ((_c = this.state.pinnedView) === null || _c === void 0 ? void 0 : _c.id) === output.id ? 'pinned-view-shadow' : '' }));
                case 'DATA_TREE':
                    return React.createElement(datatree_output_component_1.DataTreeOutputComponent, Object.assign({ key: output.id }, outputProps, { className: ((_d = this.state.pinnedView) === null || _d === void 0 ? void 0 : _d.id) === output.id ? 'pinned-view-shadow' : '' }));
                default:
                    return React.createElement(null_output_component_1.NullOutputComponent, Object.assign({ key: output.id }, outputProps, { className: ((_e = this.state.pinnedView) === null || _e === void 0 ? void 0 : _e.id) === output.id ? 'pinned-view-shadow' : '' }));
            }
        }));
    }
    get persistedState() {
        const { currentRange, currentViewRange, currentTimeSelection, pinnedView } = this.state;
        const { _storedNonTimescaleLayout: storedNonTimescaleLayout, _storedTimescaleLayout: storedTimescaleLayout, _storedPinnedViewLayout: storedPinnedViewLayout, _storedOverviewLayout: storedOverviewLayout } = this;
        const { start: ucStart, end: ucEnd } = this.unitController.viewRange;
        return {
            outputs: this.props.outputs,
            currentRange: currentRange.toString(),
            currentViewRange: currentViewRange.toString(),
            unitControllerViewRange: { start: ucStart.toString(), end: ucEnd.toString() },
            currentTimeSelection: currentTimeSelection === null || currentTimeSelection === void 0 ? void 0 : currentTimeSelection.toString(),
            storedNonTimescaleLayout,
            storedTimescaleLayout,
            pinnedView,
            storedPinnedViewLayout,
            storedOverviewOutput: this.props.overviewDescriptor,
            storedOverviewLayout: storedOverviewLayout
        };
    }
    renderPlaceHolder() {
        if (this.props.outputs.length === 0) {
            this._storedTimescaleLayout = [];
            this._storedNonTimescaleLayout = [];
        }
        return React.createElement("div", { className: 'no-output-placeholder' },
            'Trace loaded successfully.',
            React.createElement("br", null),
            'To see available views, open the Trace Viewer.');
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    doHandleUnPinView(output, payload) {
        this.chartPersistedState = { output: output, payload: payload };
        this.setState({
            pinnedView: undefined
        });
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    doHandlePinView(output, payload) {
        this.chartPersistedState = { output: output, payload: payload };
        this.setState({
            pinnedView: output
        });
    }
    generateGridLayout() {
        var _a, _b, _c, _d;
        let existingTimeScaleLayouts = [];
        let existingNonTimeScaleLayouts = [];
        let existingPinnedLayout = undefined;
        const newTimeScaleLayouts = [];
        const newNonTimeScaleLayouts = [];
        for (const output of this.props.outputs) {
            const curChartTimeLine = this._storedTimescaleLayout.find(layout => layout.i === output.id);
            const curChartNonTimeLine = this._storedNonTimescaleLayout.find(layout => layout.i === output.id);
            if (this.state.pinnedView && output.id === ((_a = this._storedPinnedViewLayout) === null || _a === void 0 ? void 0 : _a.i)) {
                existingPinnedLayout = this._storedPinnedViewLayout;
            }
            else if (((_b = this.state.pinnedView) === null || _b === void 0 ? void 0 : _b.id) === output.id) {
                let prevLayout = undefined;
                if (output.type === 'TIME_GRAPH' || output.type === 'TREE_TIME_XY') {
                    prevLayout = this._storedTimescaleLayout.find(layout => layout.i === output.id);
                }
                else {
                    prevLayout = this._storedNonTimescaleLayout.find(layout => layout.i === output.id);
                }
                existingPinnedLayout = {
                    i: output.id,
                    x: 0,
                    y: 1,
                    w: 1,
                    h: prevLayout ? prevLayout.h : this.DEFAULT_COMPONENT_HEIGHT,
                    minH: this.MIN_COMPONENT_HEIGHT,
                    resizeHandles: ['se', 's', 'sw', 'n', 'ne']
                };
            }
            else if (curChartTimeLine) {
                existingTimeScaleLayouts.push(curChartTimeLine);
            }
            else if (curChartNonTimeLine) {
                existingNonTimeScaleLayouts.push(curChartNonTimeLine);
            }
            else if (output.type === 'TIME_GRAPH' || output.type === 'TREE_TIME_XY') {
                const prevLayout = ((_c = this._storedPinnedViewLayout) === null || _c === void 0 ? void 0 : _c.i) === output.id ? this._storedPinnedViewLayout : undefined;
                newTimeScaleLayouts.push({
                    i: output.id,
                    x: 0,
                    y: 1,
                    w: 1,
                    h: prevLayout ? prevLayout.h : this.DEFAULT_COMPONENT_HEIGHT,
                    minH: this.MIN_COMPONENT_HEIGHT,
                });
            }
            else {
                const prevLayout = ((_d = this._storedPinnedViewLayout) === null || _d === void 0 ? void 0 : _d.i) === output.id ? this._storedPinnedViewLayout : undefined;
                newNonTimeScaleLayouts.push({
                    i: output.id,
                    x: 0,
                    y: 1,
                    w: 1,
                    h: prevLayout ? prevLayout.h : this.DEFAULT_COMPONENT_HEIGHT,
                    minH: this.MIN_COMPONENT_HEIGHT,
                });
            }
        }
        existingTimeScaleLayouts.sort((a, b) => (a.y > b.y) ? 1 : -1);
        existingNonTimeScaleLayouts.sort((a, b) => (a.y > b.y) ? 1 : -1);
        existingTimeScaleLayouts = existingTimeScaleLayouts.concat(newTimeScaleLayouts);
        existingNonTimeScaleLayouts = existingNonTimeScaleLayouts.concat(newNonTimeScaleLayouts);
        this._storedTimescaleLayout = existingTimeScaleLayouts;
        this._storedNonTimescaleLayout = existingNonTimeScaleLayouts;
        this._storedPinnedViewLayout = existingPinnedLayout;
        // At times after layout change RGL changes y values of existing charts from 1,2,3 to 10,20,30
        this._storedTimescaleLayout.forEach((output, index) => {
            output.y = index;
        });
        this._storedNonTimescaleLayout.forEach((output, index) => {
            output.y = index;
        });
        if (!this._storedOverviewLayout) {
            this._storedOverviewLayout = {
                i: this.OVERVIEW_OUTPUT_GRID_LAYOUT_ID,
                x: 0,
                y: 0,
                w: 1,
                minH: this.MIN_COMPONENT_HEIGHT,
                h: this.DEFAULT_OVERVIEW_HEIGHT,
                resizeHandles: ['se', 's', 'sw']
            };
        }
    }
}
exports.TraceContextComponent = TraceContextComponent;
//# sourceMappingURL=trace-context-component.js.map