/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.lifecyclemapping.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.PluginExecutionFilter;

public class LifecycleMappingFilter
implements Serializable,
Cloneable {
    private String symbolicName;
    private String versionRange;
    private Set<PluginExecutionFilter> pluginExecutions;
    private Set<String> packagingTypes;
    private transient VersionRange parsedVersionRange;

    public void addPackagingType(String string) {
        this.getPackagingTypes().add(string);
    }

    public void addPluginExecution(PluginExecutionFilter pluginExecutionFilter) {
        this.getPluginExecutions().add(pluginExecutionFilter);
    }

    public LifecycleMappingFilter clone() {
        try {
            LifecycleMappingFilter copy = (LifecycleMappingFilter)super.clone();
            if (this.pluginExecutions != null) {
                copy.pluginExecutions = new HashSet<PluginExecutionFilter>();
                for (PluginExecutionFilter item : this.pluginExecutions) {
                    copy.pluginExecutions.add(item.clone());
                }
            }
            if (this.packagingTypes != null) {
                copy.packagingTypes = new HashSet<String>();
                copy.packagingTypes.addAll(this.packagingTypes);
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LifecycleMappingFilter)) {
            return false;
        }
        LifecycleMappingFilter that = (LifecycleMappingFilter)other;
        boolean result = true;
        boolean bl = result && (this.getSymbolicName() == null ? that.getSymbolicName() == null : this.getSymbolicName().equals(that.getSymbolicName())) ? true : (result = false);
        boolean bl2 = result && (this.getVersionRange() == null ? that.getVersionRange() == null : this.getVersionRange().equals(that.getVersionRange())) ? true : (result = false);
        boolean bl3 = result && (this.getPluginExecutions() == null ? that.getPluginExecutions() == null : this.getPluginExecutions().equals(that.getPluginExecutions())) ? true : (result = false);
        result = result && (this.getPackagingTypes() == null ? that.getPackagingTypes() == null : this.getPackagingTypes().equals(that.getPackagingTypes()));
        return result;
    }

    public Set<String> getPackagingTypes() {
        if (this.packagingTypes == null) {
            this.packagingTypes = new HashSet<String>();
        }
        return this.packagingTypes;
    }

    public Set<PluginExecutionFilter> getPluginExecutions() {
        if (this.pluginExecutions == null) {
            this.pluginExecutions = new HashSet<PluginExecutionFilter>();
        }
        return this.pluginExecutions;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getVersionRange() {
        return this.versionRange;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.symbolicName != null ? this.symbolicName.hashCode() : 0);
        result = 37 * result + (this.versionRange != null ? this.versionRange.hashCode() : 0);
        result = 37 * result + (this.pluginExecutions != null ? this.pluginExecutions.hashCode() : 0);
        result = 37 * result + (this.packagingTypes != null ? this.packagingTypes.hashCode() : 0);
        return result;
    }

    public void removePackagingType(String string) {
        this.getPackagingTypes().remove(string);
    }

    public void removePluginExecution(PluginExecutionFilter pluginExecutionFilter) {
        this.getPluginExecutions().remove(pluginExecutionFilter);
    }

    public void setPackagingTypes(Set<String> packagingTypes) {
        this.packagingTypes = packagingTypes;
    }

    public void setPluginExecutions(Set<PluginExecutionFilter> pluginExecutions) {
        this.pluginExecutions = pluginExecutions;
    }

    public void setSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("symbolicName = '");
        buf.append(this.getSymbolicName());
        buf.append("'");
        buf.append("\n");
        buf.append("versionRange = '");
        buf.append(this.getVersionRange());
        buf.append("'");
        buf.append("\n");
        buf.append("pluginExecutions = '");
        buf.append(this.getPluginExecutions());
        buf.append("'");
        buf.append("\n");
        buf.append("packagingTypes = '");
        buf.append(this.getPackagingTypes());
        buf.append("'");
        return buf.toString();
    }

    public void setVersionRange(String versionRange) {
        this.versionRange = versionRange;
        try {
            this.parsedVersionRange = VersionRange.createFromVersionSpec((String)versionRange);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalArgumentException("Cannot parse version range: " + versionRange, e);
        }
    }

    public boolean matches(String version) {
        if (this.parsedVersionRange == null) {
            try {
                this.parsedVersionRange = VersionRange.createFromVersionSpec((String)this.versionRange);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new IllegalArgumentException("Cannot parse version range: " + this.versionRange, e);
            }
        }
        DefaultArtifactVersion artifactVersion = new DefaultArtifactVersion(version);
        return this.parsedVersionRange.containsVersion((ArtifactVersion)artifactVersion);
    }
}

