/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.gradle.plugin;

import com.microsoft.java.bs.gradle.model.GradleModuleDependency;
import com.microsoft.java.bs.gradle.model.ScalaExtension;
import com.microsoft.java.bs.gradle.model.SupportedLanguage;
import com.microsoft.java.bs.gradle.model.SupportedLanguages;
import com.microsoft.java.bs.gradle.model.impl.DefaultScalaExtension;
import com.microsoft.java.bs.gradle.plugin.LanguageModelBuilder;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.tasks.ScalaSourceDirectorySet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.scala.ScalaCompile;
import org.gradle.api.tasks.scala.ScalaCompileOptions;
import org.gradle.util.GradleVersion;

public class ScalaLanguageModelBuilder
extends LanguageModelBuilder {
    @Override
    public boolean appliesFor(Project project, SourceSet sourceSet) {
        return this.getScalaCompileTask(project, sourceSet) != null;
    }

    public SupportedLanguage<ScalaExtension> getLanguage() {
        return SupportedLanguages.SCALA;
    }

    @Override
    public Collection<File> getSourceFoldersFor(Project project, SourceSet sourceSet) {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"7.1")) >= 0) {
            SourceDirectorySet sourceDirectorySet = (SourceDirectorySet)sourceSet.getExtensions().findByType(ScalaSourceDirectorySet.class);
            return sourceDirectorySet == null ? Collections.emptySet() : sourceDirectorySet.getSrcDirs();
        }
        Set allSource = sourceSet.getAllSource().getSrcDirs();
        Set allResource = sourceSet.getResources().getSrcDirs();
        return allSource.stream().filter(dir -> !allResource.contains(dir)).collect(Collectors.toSet());
    }

    @Override
    public Collection<File> getGeneratedSourceFoldersFor(Project project, SourceSet sourceSet) {
        return Collections.emptySet();
    }

    private ScalaCompile getScalaCompileTask(Project project, SourceSet sourceSet) {
        return (ScalaCompile)this.getLanguageCompileTask(project, sourceSet);
    }

    @Override
    public DefaultScalaExtension getExtensionsFor(Project project, SourceSet sourceSet, Set<GradleModuleDependency> moduleDependencies) {
        GradleModuleDependency scalaLibraryDependency = this.getScalaLibraryDependency(moduleDependencies);
        if (scalaLibraryDependency != null) {
            ScalaCompile scalaCompile = this.getScalaCompileTask(project, sourceSet);
            DefaultScalaExtension extension = new DefaultScalaExtension();
            extension.setScalaOrganization(this.getScalaOrganization(scalaLibraryDependency));
            extension.setScalaVersion(this.getScalaVersion(scalaLibraryDependency));
            extension.setScalaBinaryVersion(this.getScalaBinaryVersion(scalaLibraryDependency));
            extension.setScalaCompilerArgs(this.getScalaCompilerArgs(scalaCompile));
            extension.setScalaJars(this.getScalaJars(scalaCompile));
            return extension;
        }
        return null;
    }

    private GradleModuleDependency findModule(String name, Set<GradleModuleDependency> moduleDependencies) {
        Optional<GradleModuleDependency> module = moduleDependencies.stream().filter(f -> f.getModule().equals(name)).findAny();
        return module.orElse(null);
    }

    private GradleModuleDependency getScalaLibraryDependency(Set<GradleModuleDependency> moduleDependencies) {
        GradleModuleDependency scala3Library = this.findModule("scala3-library_3", moduleDependencies);
        if (scala3Library != null) {
            return scala3Library;
        }
        return this.findModule("scala-library", moduleDependencies);
    }

    private String getScalaOrganization(GradleModuleDependency scalaLibraryDependency) {
        return scalaLibraryDependency.getGroup();
    }

    private String getScalaVersion(GradleModuleDependency scalaLibraryDependency) {
        return scalaLibraryDependency.getVersion();
    }

    private String getScalaBinaryVersion(GradleModuleDependency scalaLibraryDependency) {
        String version = scalaLibraryDependency.getVersion();
        int idx1 = version.indexOf(46);
        int idx2 = version.indexOf(46, idx1 + 1);
        return version.substring(0, idx2);
    }

    private List<File> getScalaJars(ScalaCompile scalaCompile) {
        return new LinkedList<File>(scalaCompile.getScalaClasspath().getFiles());
    }

    private List<String> getScalaCompilerArgs(ScalaCompile scalaCompile) {
        ScalaCompileOptions options = scalaCompile.getScalaCompileOptions();
        LinkedList<String> args = new LinkedList<String>();
        if (options.isDeprecation()) {
            args.add("-deprecation");
        }
        if (options.isUnchecked()) {
            args.add("-unchecked");
        }
        if (options.getDebugLevel() != null && !options.getDebugLevel().isEmpty()) {
            args.add("-g:" + options.getDebugLevel());
        }
        if (options.isOptimize()) {
            args.add("-optimise");
        }
        if (options.getEncoding() != null && !options.getEncoding().isEmpty()) {
            args.add("-encoding");
            args.add(options.getEncoding());
        }
        if (options.getLoggingLevel() != null) {
            if ("verbose".equalsIgnoreCase(options.getLoggingLevel())) {
                args.add("-verbose");
            } else if ("debug".equalsIgnoreCase(options.getLoggingLevel())) {
                args.add("-Ydebug");
            }
        }
        if (options.getLoggingPhases() != null && !options.getLoggingPhases().isEmpty()) {
            for (String phase : options.getLoggingPhases()) {
                args.add("-Ylog:" + phase);
            }
        }
        if (options.getAdditionalParameters() != null) {
            args.addAll(options.getAdditionalParameters());
        }
        try {
            Method getScalaCompilerPlugins = ScalaCompile.class.getDeclaredMethod("getScalaCompilerPlugins", new Class[0]);
            FileCollection fileCollection = (FileCollection)getScalaCompilerPlugins.invoke((Object)scalaCompile, new Object[0]);
            for (File file : fileCollection) {
                args.add("-Xplugin:" + file.getPath());
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException exception) {
            // empty catch block
        }
        return args;
    }
}

