/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.core.util;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.groovy.core.Activator;

public class ScriptFolderSelector
implements IEclipsePreferences.IPreferenceChangeListener {
    private boolean enabled;
    private boolean[] doCopy;
    private char[][] scriptPatterns;
    private IEclipsePreferences preferences;

    public static boolean isEnabled(IProject project) {
        IEclipsePreferences preferences = ScriptFolderSelector.getGroovyPreferences(project);
        if (preferences != null) {
            return preferences.getBoolean("groovy.script.filters.enabled", true);
        }
        return false;
    }

    private static IEclipsePreferences getGroovyPreferences(IProject project) {
        IEclipsePreferences preferences = Activator.getProjectPreferences(project);
        if (preferences == null || !preferences.getBoolean("org.codehaus.groovy.eclipse.preferences.compiler.project", false)) {
            preferences = Activator.getInstancePreferences();
        }
        return preferences;
    }

    public ScriptFolderSelector(IProject project) {
        this.preferences = ScriptFolderSelector.getGroovyPreferences(project);
        if (this.preferences == null) {
            this.enabled = false;
        } else {
            this.preferenceChange(null);
        }
    }

    protected ScriptFolderSelector(List<String> preferences, boolean enabled) {
        this.enabled = enabled;
        this.initFilters(preferences);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.preferences != null) {
            try {
                this.preferences.removePreferenceChangeListener(this);
            }
            finally {
                this.preferences = null;
                this.enabled = false;
            }
        }
    }

    @Override
    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        this.doCopy = null;
        this.scriptPatterns = null;
        this.enabled = this.preferences.getBoolean("groovy.script.filters.enabled", true);
        if (this.enabled) {
            String filters = this.preferences.get("groovy.script.filters", "**/*.dsld,y,**/*.gradle,n");
            this.initFilters(Arrays.asList(filters.split(",")));
        }
    }

    private void initFilters(List<String> filterTokens) {
        if (filterTokens == null || filterTokens.isEmpty()) {
            this.scriptPatterns = CharOperation.NO_CHAR_CHAR;
            this.doCopy = new boolean[0];
            return;
        }
        TreeMap<String, Boolean> spec = new TreeMap<String, Boolean>();
        int i = 0;
        int n = filterTokens.size();
        while (i < n) {
            String pattern = filterTokens.get(i++).trim();
            boolean isCopy = i < n ? filterTokens.get(i).trim().startsWith("y") : true;
            spec.put(pattern, isCopy);
            ++i;
        }
        spec.remove("");
        this.doCopy = new boolean[spec.size()];
        this.scriptPatterns = new char[spec.size()][];
        int index = 0;
        for (Map.Entry entry : spec.entrySet()) {
            this.scriptPatterns[index] = ((String)entry.getKey()).toCharArray();
            this.doCopy[index++] = (Boolean)entry.getValue();
        }
    }

    public FileKind getFileKind(char[] filepath) {
        if (this.enabled && filepath != null && filepath.length > 0) {
            int i = 0;
            int n = this.scriptPatterns.length;
            while (i < n) {
                char[] pattern = this.scriptPatterns[i];
                if (CharOperation.pathMatch(pattern, filepath, true, '/')) {
                    return this.doCopy[i] ? FileKind.SCRIPT : FileKind.SCRIPT_NO_COPY;
                }
                ++i;
            }
        }
        return FileKind.SOURCE;
    }

    public FileKind getFileKind(IResource file) {
        if (file == null || !this.enabled) {
            return FileKind.SOURCE;
        }
        return this.getFileKind(file.getProjectRelativePath().toPortableString().toCharArray());
    }

    public boolean isScript(char[] filepath) {
        if (filepath == null || !this.enabled) {
            return false;
        }
        FileKind kind = this.getFileKind(filepath);
        return kind == FileKind.SCRIPT || kind == FileKind.SCRIPT_NO_COPY;
    }

    public boolean isScript(IResource file) {
        if (file == null || !this.enabled) {
            return false;
        }
        return this.isScript(file.getProjectRelativePath().toPortableString().toCharArray());
    }

    public static enum FileKind {
        SOURCE,
        SCRIPT,
        SCRIPT_NO_COPY;

    }
}

