/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac.dom;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import java.util.Objects;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.JavacBindingResolver;
import org.eclipse.jdt.internal.javac.dom.JavacMethodBinding;

public abstract class JavacMemberValuePairBinding
implements IMemberValuePairBinding {
    public final JavacMethodBinding method;
    public final Object value;
    private final JavacBindingResolver resolver;

    public JavacMemberValuePairBinding(Symbol.MethodSymbol key, Attribute value, JavacBindingResolver resolver) {
        this.method = resolver.bindings.getMethodBinding(key.type.asMethodType(), key, null, true);
        this.value = value;
        this.resolver = resolver;
    }

    public JavacMemberValuePairBinding(IMethodBinding defaultAnnotationMethod, JavacBindingResolver resolver) {
        this.method = (JavacMethodBinding)defaultAnnotationMethod;
        this.value = defaultAnnotationMethod.getDefaultValue();
        this.resolver = resolver;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof JavacMemberValuePairBinding)) return false;
        JavacMemberValuePairBinding other = (JavacMemberValuePairBinding)obj;
        if (!Objects.equals((Object)this.resolver, (Object)other.resolver)) return false;
        if (!Objects.equals(this.method, other.method)) return false;
        if (!Objects.equals(this.value, other.value)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resolver, this.method, this.value});
    }

    public IAnnotationBinding[] getAnnotations() {
        return new IAnnotationBinding[0];
    }

    public int getKind() {
        return 6;
    }

    public int getModifiers() {
        return this.method.getModifiers();
    }

    public boolean isDeprecated() {
        return this.method.isDeprecated();
    }

    public boolean isRecovered() {
        return this.value instanceof Attribute.Error;
    }

    public boolean isSynthetic() {
        return this.method.isSynthetic();
    }

    public IJavaElement getJavaElement() {
        return this.method.getJavaElement();
    }

    public String getKey() {
        return Integer.toString(System.identityHashCode(this.method));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEqualTo(IBinding binding) {
        if (!(binding instanceof IMemberValuePairBinding)) return false;
        IMemberValuePairBinding other = (IMemberValuePairBinding)binding;
        if (!Objects.equals(this.getKey(), other.getKey())) return false;
        return true;
    }

    public String getName() {
        return this.method.getName();
    }

    public IMethodBinding getMethodBinding() {
        return this.method;
    }

    public Object getValue() {
        Object object;
        Object object2 = this.value;
        if (object2 instanceof Attribute) {
            Attribute attr = (Attribute)object2;
            object = this.resolver.getValueFromAttribute(attr);
        } else {
            object = this.value;
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDefault() {
        Object object = this.value;
        if (!(object instanceof Attribute)) return true;
        Attribute attr = (Attribute)object;
        if (this.value != this.method.methodSymbol.defaultValue) return false;
        return true;
    }

    public String toString() {
        return this.getName() + " = " + this.getValue().toString();
    }
}

