/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug;

import com.microsoft.java.debug.BindingUtils;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.internal.debug.core.breakpoints.ValidBreakpointLocationLocator;

public class BreakpointLocationLocator
extends ValidBreakpointLocationLocator {
    private IMethodBinding methodBinding;

    public BreakpointLocationLocator(CompilationUnit compilationUnit, int lineNumber, boolean bindingsResolved, boolean bestMatch, int offset, int end) {
        super(compilationUnit, lineNumber, bindingsResolved, bestMatch, offset, end);
    }

    public boolean visit(MethodDeclaration node) {
        boolean result = super.visit(node);
        if (this.methodBinding == null && this.getLocationType() == 2) {
            this.methodBinding = node.resolveBinding();
        }
        return result;
    }

    public String getMethodSignature() {
        if (this.methodBinding == null) {
            return null;
        }
        return BindingUtils.toSignature(this.methodBinding);
    }

    public String getMethodName() {
        if (this.methodBinding == null) {
            return null;
        }
        return this.methodBinding.getName();
    }

    public String getFullyQualifiedTypeName() {
        if (this.methodBinding != null) {
            return this.methodBinding.getDeclaringClass().getQualifiedName();
        }
        return super.getFullyQualifiedTypeName();
    }
}

