/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.embedder;

import java.util.List;
import java.util.concurrent.CancellationException;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.LifecycleTaskSegmentCalculator;
import org.eclipse.core.runtime.IProgressMonitor;

public class MonitorExecutionListener
implements ExecutionListener {
    private IProgressMonitor monitor;

    public MonitorExecutionListener(IProgressMonitor monitor) {
        this.monitor = IProgressMonitor.nullSafe((IProgressMonitor)monitor);
    }

    public void mojoStarted(ExecutionEvent event) {
        String id = event.getMojoExecution().getPlugin().getId();
        this.monitor.subTask("Executing " + id + "...");
    }

    void mojoFinished(ExecutionEvent event) {
        if (this.monitor.isCanceled()) {
            throw new CancellationException();
        }
        this.monitor.worked(1);
        this.monitor.subTask("");
    }

    public void mojoFailed(ExecutionEvent event) {
        this.mojoFinished(event);
    }

    public void mojoSkipped(ExecutionEvent event) {
        this.mojoFinished(event);
    }

    public void mojoSucceeded(ExecutionEvent event) {
        this.mojoFinished(event);
    }

    public void projectStarted(ExecutionEvent event) {
        this.monitor.setTaskName("Building " + event.getProject().getName() + "...");
    }

    void projectFinished(ExecutionEvent event) {
        this.monitor.setTaskName("Building...");
    }

    public void projectFailed(ExecutionEvent event) {
        this.projectFinished(event);
    }

    public void projectSkipped(ExecutionEvent event) {
        this.projectFinished(event);
    }

    public void projectSucceeded(ExecutionEvent event) {
        this.projectFinished(event);
    }

    public void sessionEnded(ExecutionEvent event) {
        this.monitor.done();
    }

    public void sessionStarted(ExecutionEvent event) {
        int totalWork;
        try {
            MavenSession session = event.getSession();
            LifecycleTaskSegmentCalculator calculator = (LifecycleTaskSegmentCalculator)session.lookup(LifecycleTaskSegmentCalculator.class.getName());
            List segments = calculator.calculateTaskSegments(session);
            totalWork = (int)(segments.stream().flatMap(seg -> seg.getTasks().stream()).count() * (long)session.getProjects().size());
        }
        catch (Exception ex) {
            totalWork = -1;
        }
        this.monitor.beginTask("Building ...", totalWork);
    }

    public void projectDiscoveryStarted(ExecutionEvent event) {
    }

    public void forkFailed(ExecutionEvent event) {
    }

    public void forkStarted(ExecutionEvent event) {
    }

    public void forkSucceeded(ExecutionEvent event) {
    }

    public void forkedProjectFailed(ExecutionEvent event) {
    }

    public void forkedProjectStarted(ExecutionEvent event) {
    }

    public void forkedProjectSucceeded(ExecutionEvent event) {
    }
}

