/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.core.internal.services;

import ch.epfl.scala.bsp4j.BuildClient;
import ch.epfl.scala.bsp4j.BuildTarget;
import ch.epfl.scala.bsp4j.BuildTargetEvent;
import ch.epfl.scala.bsp4j.BuildTargetIdentifier;
import ch.epfl.scala.bsp4j.CleanCacheParams;
import ch.epfl.scala.bsp4j.CleanCacheResult;
import ch.epfl.scala.bsp4j.CompileParams;
import ch.epfl.scala.bsp4j.CompileResult;
import ch.epfl.scala.bsp4j.DependencyModule;
import ch.epfl.scala.bsp4j.DependencyModulesItem;
import ch.epfl.scala.bsp4j.DependencyModulesParams;
import ch.epfl.scala.bsp4j.DependencyModulesResult;
import ch.epfl.scala.bsp4j.DependencySourcesItem;
import ch.epfl.scala.bsp4j.DependencySourcesParams;
import ch.epfl.scala.bsp4j.DependencySourcesResult;
import ch.epfl.scala.bsp4j.DidChangeBuildTarget;
import ch.epfl.scala.bsp4j.JavacOptionsItem;
import ch.epfl.scala.bsp4j.JavacOptionsParams;
import ch.epfl.scala.bsp4j.JavacOptionsResult;
import ch.epfl.scala.bsp4j.MavenDependencyModule;
import ch.epfl.scala.bsp4j.MavenDependencyModuleArtifact;
import ch.epfl.scala.bsp4j.OutputPathItem;
import ch.epfl.scala.bsp4j.OutputPathItemKind;
import ch.epfl.scala.bsp4j.OutputPathsItem;
import ch.epfl.scala.bsp4j.OutputPathsParams;
import ch.epfl.scala.bsp4j.OutputPathsResult;
import ch.epfl.scala.bsp4j.ResourcesItem;
import ch.epfl.scala.bsp4j.ResourcesParams;
import ch.epfl.scala.bsp4j.ResourcesResult;
import ch.epfl.scala.bsp4j.ScalaTestClassesItem;
import ch.epfl.scala.bsp4j.ScalaTestParams;
import ch.epfl.scala.bsp4j.ScalaTestSuiteSelection;
import ch.epfl.scala.bsp4j.ScalaTestSuites;
import ch.epfl.scala.bsp4j.ScalacOptionsItem;
import ch.epfl.scala.bsp4j.ScalacOptionsParams;
import ch.epfl.scala.bsp4j.ScalacOptionsResult;
import ch.epfl.scala.bsp4j.SourceItem;
import ch.epfl.scala.bsp4j.SourceItemKind;
import ch.epfl.scala.bsp4j.SourcesItem;
import ch.epfl.scala.bsp4j.SourcesParams;
import ch.epfl.scala.bsp4j.SourcesResult;
import ch.epfl.scala.bsp4j.StatusCode;
import ch.epfl.scala.bsp4j.TestParams;
import ch.epfl.scala.bsp4j.TestResult;
import ch.epfl.scala.bsp4j.WorkspaceBuildTargetsResult;
import com.microsoft.java.bs.core.Launcher;
import com.microsoft.java.bs.core.internal.gradle.GradleApiConnector;
import com.microsoft.java.bs.core.internal.managers.BuildTargetManager;
import com.microsoft.java.bs.core.internal.managers.PreferenceManager;
import com.microsoft.java.bs.core.internal.model.GradleBuildTarget;
import com.microsoft.java.bs.core.internal.reporter.CompileProgressReporter;
import com.microsoft.java.bs.core.internal.reporter.DefaultProgressReporter;
import com.microsoft.java.bs.core.internal.reporter.ProgressReporter;
import com.microsoft.java.bs.core.internal.utils.JsonUtils;
import com.microsoft.java.bs.core.internal.utils.TelemetryUtils;
import com.microsoft.java.bs.core.internal.utils.UriUtils;
import com.microsoft.java.bs.gradle.model.GradleModuleDependency;
import com.microsoft.java.bs.gradle.model.GradleSourceSet;
import com.microsoft.java.bs.gradle.model.GradleSourceSets;
import com.microsoft.java.bs.gradle.model.JavaExtension;
import com.microsoft.java.bs.gradle.model.ScalaExtension;
import com.microsoft.java.bs.gradle.model.SupportedLanguages;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class BuildTargetService {
    private static final String MAVEN_DATA_KIND = "maven";
    private final BuildTargetManager buildTargetManager;
    private final GradleApiConnector connector;
    private final PreferenceManager preferenceManager;
    private BuildClient client;
    private boolean firstTime;

    public BuildTargetService(BuildTargetManager buildTargetManager, GradleApiConnector connector, PreferenceManager preferenceManager) {
        this.buildTargetManager = buildTargetManager;
        this.connector = connector;
        this.preferenceManager = preferenceManager;
        this.firstTime = true;
    }

    private List<BuildTargetIdentifier> updateBuildTargets() {
        GradleSourceSets sourceSets = this.connector.getGradleSourceSets(this.preferenceManager.getRootUri(), this.client);
        return this.buildTargetManager.store(sourceSets);
    }

    private BuildTargetManager getBuildTargetManager() {
        if (this.firstTime) {
            this.updateBuildTargets();
            this.firstTime = false;
            int buildTargetCount = this.buildTargetManager.getAllGradleBuildTargets().size();
            Map<String, String> map = TelemetryUtils.getMetadataMap("buildTargetCount", String.valueOf(buildTargetCount));
            Launcher.LOGGER.log(Level.INFO, "Found " + buildTargetCount + " build targets during initialization.", map);
        }
        return this.buildTargetManager;
    }

    public void reloadWorkspace() {
        List<BuildTargetIdentifier> changedTargets = this.updateBuildTargets();
        if (!changedTargets.isEmpty()) {
            this.notifyBuildTargetsChanged(changedTargets);
        }
    }

    private void notifyBuildTargetsChanged(List<BuildTargetIdentifier> changedTargets) {
        List events = changedTargets.stream().map(BuildTargetEvent::new).collect(Collectors.toList());
        DidChangeBuildTarget param = new DidChangeBuildTarget(events);
        this.client.onBuildTargetDidChange(param);
    }

    private GradleBuildTarget getGradleBuildTarget(BuildTargetIdentifier btId) {
        return this.getBuildTargetManager().getGradleBuildTarget(btId);
    }

    public void setClient(BuildClient client) {
        this.client = client;
    }

    public WorkspaceBuildTargetsResult getWorkspaceBuildTargets() {
        List<GradleBuildTarget> allTargets = this.getBuildTargetManager().getAllGradleBuildTargets();
        List targets = allTargets.stream().map(GradleBuildTarget::getBuildTarget).collect(Collectors.toList());
        return new WorkspaceBuildTargetsResult(targets);
    }

    public SourcesResult getBuildTargetSources(SourcesParams params) {
        ArrayList<SourcesItem> sourceItems = new ArrayList<SourcesItem>();
        for (BuildTargetIdentifier btId : params.getTargets()) {
            GradleBuildTarget target = this.getGradleBuildTarget(btId);
            if (target == null) {
                Launcher.LOGGER.warning("Skip sources collection for the build target: " + btId.getUri() + ". Because it cannot be found in the cache.");
                continue;
            }
            GradleSourceSet sourceSet = target.getSourceSet();
            ArrayList<SourceItem> sources = new ArrayList<SourceItem>();
            for (File sourceDir : sourceSet.getSourceDirs()) {
                sources.add(new SourceItem(sourceDir.toURI().toString(), SourceItemKind.DIRECTORY, Boolean.valueOf(false)));
            }
            for (File sourceDir : sourceSet.getGeneratedSourceDirs()) {
                sources.add(new SourceItem(sourceDir.toURI().toString(), SourceItemKind.DIRECTORY, Boolean.valueOf(true)));
            }
            SourcesItem item = new SourcesItem(btId, sources);
            sourceItems.add(item);
        }
        return new SourcesResult(sourceItems);
    }

    public ResourcesResult getBuildTargetResources(ResourcesParams params) {
        ArrayList<ResourcesItem> items = new ArrayList<ResourcesItem>();
        for (BuildTargetIdentifier btId : params.getTargets()) {
            GradleBuildTarget target = this.getGradleBuildTarget(btId);
            if (target == null) {
                Launcher.LOGGER.warning("Skip resources collection for the build target: " + btId.getUri() + ". Because it cannot be found in the cache.");
                continue;
            }
            GradleSourceSet sourceSet = target.getSourceSet();
            ArrayList<String> resources = new ArrayList<String>();
            for (File resourceDir : sourceSet.getResourceDirs()) {
                resources.add(resourceDir.toURI().toString());
            }
            ResourcesItem item = new ResourcesItem(btId, resources);
            items.add(item);
        }
        return new ResourcesResult(items);
    }

    public OutputPathsResult getBuildTargetOutputPaths(OutputPathsParams params) {
        ArrayList<OutputPathsItem> items = new ArrayList<OutputPathsItem>();
        for (BuildTargetIdentifier btId : params.getTargets()) {
            Set resourceOutputDirs;
            GradleBuildTarget target = this.getGradleBuildTarget(btId);
            if (target == null) {
                Launcher.LOGGER.warning("Skip output collection for the build target: " + btId.getUri() + ". Because it cannot be found in the cache.");
                continue;
            }
            GradleSourceSet sourceSet = target.getSourceSet();
            ArrayList<OutputPathItem> outputPaths = new ArrayList<OutputPathItem>();
            Set sourceOutputDirs = sourceSet.getSourceOutputDirs();
            if (sourceOutputDirs != null) {
                for (Object sourceOutputDir : sourceOutputDirs) {
                    outputPaths.add(new OutputPathItem(String.valueOf(((File)sourceOutputDir).toURI()) + "?kind=source", OutputPathItemKind.DIRECTORY));
                }
            }
            if ((resourceOutputDirs = sourceSet.getResourceOutputDirs()) != null) {
                Object sourceOutputDir;
                sourceOutputDir = resourceOutputDirs.iterator();
                while (sourceOutputDir.hasNext()) {
                    File resourceOutputDir = (File)sourceOutputDir.next();
                    outputPaths.add(new OutputPathItem(String.valueOf(resourceOutputDir.toURI()) + "?kind=resource", OutputPathItemKind.DIRECTORY));
                }
            }
            OutputPathsItem item = new OutputPathsItem(btId, outputPaths);
            items.add(item);
        }
        return new OutputPathsResult(items);
    }

    public DependencySourcesResult getBuildTargetDependencySources(DependencySourcesParams params) {
        ArrayList<DependencySourcesItem> items = new ArrayList<DependencySourcesItem>();
        for (BuildTargetIdentifier btId : params.getTargets()) {
            GradleBuildTarget target = this.getGradleBuildTarget(btId);
            if (target == null) {
                Launcher.LOGGER.warning("Skip output collection for the build target: " + btId.getUri() + ". Because it cannot be found in the cache.");
                continue;
            }
            GradleSourceSet sourceSet = target.getSourceSet();
            ArrayList<String> sources = new ArrayList<String>();
            for (GradleModuleDependency dep : sourceSet.getModuleDependencies()) {
                List<String> artifacts = dep.getArtifacts().stream().filter(a -> "sources".equals(a.getClassifier())).map(a -> a.getUri().toString()).toList();
                sources.addAll(artifacts);
            }
            items.add(new DependencySourcesItem(btId, sources));
        }
        return new DependencySourcesResult(items);
    }

    public DependencyModulesResult getBuildTargetDependencyModules(DependencyModulesParams params) {
        ArrayList<DependencyModulesItem> items = new ArrayList<DependencyModulesItem>();
        for (BuildTargetIdentifier btId : params.getTargets()) {
            GradleBuildTarget target = this.getGradleBuildTarget(btId);
            if (target == null) {
                Launcher.LOGGER.warning("Skip output collection for the build target: " + btId.getUri() + ". Because it cannot be found in the cache.");
                continue;
            }
            GradleSourceSet sourceSet = target.getSourceSet();
            ArrayList<DependencyModule> modules = new ArrayList<DependencyModule>();
            for (GradleModuleDependency dep : sourceSet.getModuleDependencies()) {
                DependencyModule module = new DependencyModule(dep.getModule(), dep.getVersion());
                module.setDataKind(MAVEN_DATA_KIND);
                List artifacts = dep.getArtifacts().stream().map(a -> {
                    MavenDependencyModuleArtifact artifact = new MavenDependencyModuleArtifact(a.getUri().toString());
                    artifact.setClassifier(a.getClassifier());
                    return artifact;
                }).collect(Collectors.toList());
                MavenDependencyModule mavenModule = new MavenDependencyModule(dep.getGroup(), dep.getModule(), dep.getVersion(), artifacts);
                module.setData((Object)mavenModule);
                modules.add(module);
            }
            DependencyModulesItem item = new DependencyModulesItem(btId, modules);
            items.add(item);
        }
        return new DependencyModulesResult(items);
    }

    public CompileResult compile(CompileParams params) {
        if (params.getTargets().isEmpty()) {
            return new CompileResult(StatusCode.OK);
        }
        CompileProgressReporter reporter = new CompileProgressReporter(this.client, params.getOriginId(), this.getFullTaskPathMap());
        StatusCode code = this.runTasks(params.getTargets(), this::getBuildTaskName, reporter);
        CompileResult result = new CompileResult(code);
        result.setOriginId(params.getOriginId());
        if (!Boolean.getBoolean("bsp.plugin.reloadworkspace.disabled")) {
            CompletableFuture.runAsync(this::reloadWorkspace);
        }
        return result;
    }

    public CleanCacheResult cleanCache(CleanCacheParams params) {
        DefaultProgressReporter reporter = new DefaultProgressReporter(this.client);
        StatusCode code = this.runTasks(params.getTargets(), this::getCleanTaskName, reporter);
        return new CleanCacheResult(null, Boolean.valueOf(code == StatusCode.OK));
    }

    private Map<String, Set<BuildTargetIdentifier>> getFullTaskPathMap() {
        HashMap<String, Set<BuildTargetIdentifier>> fullTaskPathMap = new HashMap<String, Set<BuildTargetIdentifier>>();
        for (GradleBuildTarget buildTarget : this.buildTargetManager.getAllGradleBuildTargets()) {
            Set tasks = buildTarget.getSourceSet().getTaskNames();
            BuildTargetIdentifier btId = buildTarget.getBuildTarget().getId();
            for (String taskName : tasks) {
                fullTaskPathMap.computeIfAbsent(taskName, k -> new HashSet()).add(btId);
            }
        }
        return fullTaskPathMap;
    }

    private StatusCode runTasks(List<BuildTargetIdentifier> targets, Function<BuildTargetIdentifier, String> taskNameCreator, ProgressReporter reporter) {
        Map<URI, Set<BuildTargetIdentifier>> groupedTargets = this.groupBuildTargetsByRootDir(targets);
        StatusCode code = StatusCode.OK;
        for (Map.Entry<URI, Set<BuildTargetIdentifier>> entry : groupedTargets.entrySet()) {
            String[] tasks = (String[])entry.getValue().stream().map(taskNameCreator).distinct().toArray(String[]::new);
            code = this.connector.runTasks(entry.getKey(), reporter, tasks);
            if (code != StatusCode.ERROR) continue;
            break;
        }
        return code;
    }

    public JavacOptionsResult getBuildTargetJavacOptions(JavacOptionsParams params) {
        ArrayList<JavacOptionsItem> items = new ArrayList<JavacOptionsItem>();
        for (BuildTargetIdentifier btId : params.getTargets()) {
            GradleBuildTarget target = this.getGradleBuildTarget(btId);
            if (target == null) {
                Launcher.LOGGER.warning("Skip javac options collection for the build target: " + btId.getUri() + ". Because it cannot be found in the cache.");
                continue;
            }
            GradleSourceSet sourceSet = target.getSourceSet();
            JavaExtension javaExtension = (JavaExtension)SupportedLanguages.JAVA.getExtension(sourceSet);
            if (javaExtension == null) {
                Launcher.LOGGER.warning("Skip javac options collection for the build target: " + btId.getUri() + ". Because the java extension cannot be found from source set.");
                continue;
            }
            List classpath = sourceSet.getCompileClasspath().stream().map(file -> file.toURI().toString()).collect(Collectors.toList());
            String classesDir = javaExtension.getClassesDir() != null ? javaExtension.getClassesDir().toURI().toString() : "";
            items.add(new JavacOptionsItem(btId, javaExtension.getCompilerArgs(), classpath, classesDir));
        }
        return new JavacOptionsResult(items);
    }

    public ScalacOptionsResult getBuildTargetScalacOptions(ScalacOptionsParams params) {
        ArrayList<ScalacOptionsItem> items = new ArrayList<ScalacOptionsItem>();
        for (BuildTargetIdentifier btId : params.getTargets()) {
            GradleBuildTarget target = this.getGradleBuildTarget(btId);
            if (target == null) {
                Launcher.LOGGER.warning("Skip scalac options collection for the build target: " + btId.getUri() + ". Because it cannot be found in the cache.");
                continue;
            }
            GradleSourceSet sourceSet = target.getSourceSet();
            ScalaExtension scalaExtension = (ScalaExtension)SupportedLanguages.SCALA.getExtension(sourceSet);
            if (scalaExtension == null) {
                Launcher.LOGGER.warning("Skip scalac options collection for the build target: " + btId.getUri() + ". Because the scalac extension cannot be found from source set.");
                continue;
            }
            List classpath = sourceSet.getCompileClasspath().stream().map(file -> file.toURI().toString()).collect(Collectors.toList());
            String classesDir = scalaExtension.getClassesDir() != null ? scalaExtension.getClassesDir().toURI().toString() : "";
            items.add(new ScalacOptionsItem(btId, scalaExtension.getScalaCompilerArgs(), classpath, classesDir));
        }
        return new ScalacOptionsResult(items);
    }

    public TestResult buildTargetTest(TestParams params) {
        TestResult testResult = new TestResult(StatusCode.OK);
        testResult.setOriginId(params.getOriginId());
        CompileProgressReporter compileProgressReporter = new CompileProgressReporter(this.client, params.getOriginId(), this.getFullTaskPathMap());
        Map<URI, Set<BuildTargetIdentifier>> groupedTargets = this.groupBuildTargetsByRootDir(params.getTargets());
        for (Map.Entry<URI, Set<BuildTargetIdentifier>> entry : groupedTargets.entrySet()) {
            StatusCode statusCode;
            if ("scala-test".equals(params.getDataKind())) {
                statusCode = this.runScalaTests(entry, params, compileProgressReporter);
            } else if ("scala-test-suites-selection".equals(params.getDataKind())) {
                statusCode = this.runScalaTestSuitesSelection(entry, params, compileProgressReporter);
            } else {
                Launcher.LOGGER.warning("Test Data Kind " + params.getDataKind() + " not supported");
                statusCode = StatusCode.ERROR;
            }
            if (statusCode == StatusCode.OK) continue;
            testResult.setStatusCode(statusCode);
        }
        return testResult;
    }

    private StatusCode runScalaTests(Map.Entry<URI, Set<BuildTargetIdentifier>> entry, TestParams params, CompileProgressReporter compileProgressReporter) {
        ScalaTestParams testParams = JsonUtils.toModel(params.getData(), ScalaTestParams.class);
        HashMap<BuildTargetIdentifier, Map<String, Set<String>>> testClasses = new HashMap<BuildTargetIdentifier, Map<String, Set<String>>>();
        for (ScalaTestClassesItem testClassesItem : testParams.getTestClasses()) {
            HashMap<String, Object> classesMethods = new HashMap<String, Object>();
            for (String classNames : testClassesItem.getClasses()) {
                classesMethods.put(classNames, null);
            }
            testClasses.put(testClassesItem.getTarget(), classesMethods);
        }
        return this.connector.runTests(entry.getKey(), testClasses, testParams.getJvmOptions(), params.getArguments(), null, this.client, params.getOriginId(), compileProgressReporter);
    }

    private StatusCode runScalaTestSuitesSelection(Map.Entry<URI, Set<BuildTargetIdentifier>> entry, TestParams params, CompileProgressReporter compileProgressReporter) {
        List<String[]> splitArgs;
        if (params.getTargets().size() != 1) {
            Launcher.LOGGER.warning("Test params with Test Data Kind " + params.getDataKind() + " must contain only 1 build target");
            return StatusCode.ERROR;
        }
        ScalaTestSuites testSuites = JsonUtils.toModel(params.getData(), ScalaTestSuites.class);
        Map<String, String> envVars = null;
        boolean argsValid = true;
        if (testSuites.getEnvironmentVariables() != null && (argsValid = (splitArgs = testSuites.getEnvironmentVariables().stream().map(arg -> arg.split("=")).toList()).stream().allMatch(arg -> ((String[])arg).length == 2))) {
            envVars = splitArgs.stream().collect(Collectors.toMap(arg -> arg[0], arg -> arg[1]));
        }
        if (!argsValid) {
            Launcher.LOGGER.warning("Test params arguments must each be in the form KEY=VALUE. " + String.valueOf(testSuites.getEnvironmentVariables()));
            return StatusCode.ERROR;
        }
        HashMap<String, Set> classesMethods = new HashMap<String, Set>();
        for (ScalaTestSuiteSelection testSuiteSelection : testSuites.getSuites()) {
            Set methods = classesMethods.computeIfAbsent(testSuiteSelection.getClassName(), k -> new HashSet());
            methods.addAll(testSuiteSelection.getTests());
        }
        HashMap<BuildTargetIdentifier, Map<String, Set<String>>> testClasses = new HashMap<BuildTargetIdentifier, Map<String, Set<String>>>();
        testClasses.put((BuildTargetIdentifier)params.getTargets().get(0), classesMethods);
        return this.connector.runTests(entry.getKey(), testClasses, testSuites.getJvmOptions(), params.getArguments(), envVars, this.client, params.getOriginId(), compileProgressReporter);
    }

    private Map<URI, Set<BuildTargetIdentifier>> groupBuildTargetsByRootDir(List<BuildTargetIdentifier> targets) {
        HashMap<URI, Set<BuildTargetIdentifier>> groupedTargets = new HashMap<URI, Set<BuildTargetIdentifier>>();
        for (BuildTargetIdentifier btId : targets) {
            URI projectUri = this.getRootProjectUri(btId);
            if (projectUri == null) continue;
            groupedTargets.computeIfAbsent(projectUri, k -> new HashSet()).add(btId);
        }
        return groupedTargets;
    }

    private URI getRootProjectUri(BuildTargetIdentifier btId) {
        GradleBuildTarget gradleBuildTarget = this.getGradleBuildTarget(btId);
        if (gradleBuildTarget == null) {
            throw new IllegalArgumentException("The build target does not exist: " + btId.getUri());
        }
        BuildTarget buildTarget = gradleBuildTarget.getBuildTarget();
        if (buildTarget.getBaseDirectory() != null) {
            return UriUtils.getUriFromString(buildTarget.getBaseDirectory());
        }
        return UriUtils.getUriWithoutQuery(btId.getUri());
    }

    private String getProjectTaskName(BuildTargetIdentifier btId, String title, Function<GradleSourceSet, String> creator) {
        GradleBuildTarget gradleBuildTarget = this.getGradleBuildTarget(btId);
        if (gradleBuildTarget == null) {
            throw new IllegalArgumentException("The build target does not exist: " + btId.getUri());
        }
        String taskName = creator.apply(gradleBuildTarget.getSourceSet());
        if (StringUtils.isBlank((CharSequence)taskName)) {
            throw new IllegalArgumentException("The build target does not have a " + title + " task: " + btId.getUri());
        }
        return taskName;
    }

    private String getBuildTaskName(BuildTargetIdentifier btId) {
        return this.getProjectTaskName(btId, "classes", GradleSourceSet::getClassesTaskName);
    }

    private String getCleanTaskName(BuildTargetIdentifier btId) {
        return this.getProjectTaskName(btId, "clean", GradleSourceSet::getCleanTaskName);
    }
}

