/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.search.LocatorResponse;
import org.eclipse.jdt.internal.core.search.matching.DOMPatternLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.NodeSetWrapper;
import org.eclipse.jdt.internal.core.search.matching.PackageReferenceLocator;

public class DOMPackageReferenceLocator
extends DOMPatternLocator {
    private PackageReferenceLocator locator;

    public DOMPackageReferenceLocator(PackageReferenceLocator locator) {
        super((SearchPattern)locator.pattern);
        this.locator = locator;
    }

    @Override
    public LocatorResponse match(Name node, NodeSetWrapper nodeSet, MatchLocator locator) {
        ASTNode aSTNode;
        Name n = node;
        while ((aSTNode = n.getParent()) instanceof Name) {
            Name parent;
            n = parent = (Name)aSTNode;
        }
        if (n.getParent() instanceof PackageDeclaration) {
            return DOMPackageReferenceLocator.toResponse(0);
        }
        return DOMPackageReferenceLocator.toResponse(this.matchesName(this.locator.pattern.pkgName, node.getFullyQualifiedName().toCharArray()) ? 2 : 0);
    }

    @Override
    public LocatorResponse resolveLevel(ASTNode node, IBinding binding, MatchLocator locator) {
        IPackageBinding ipb;
        String n;
        if (binding instanceof IPackageBinding && this.matchesName(this.locator.pattern.pkgName, (n = (ipb = (IPackageBinding)binding).getName()).toCharArray())) {
            if (this.locator.pattern.focus == null) {
                return DOMPackageReferenceLocator.toResponse(3);
            }
            ASTNode working = node;
            Name fullName = null;
            while (working instanceof Name) {
                Name fn;
                fullName = fn = (Name)working;
                working = working.getParent();
            }
            if (fullName != null) {
                IJavaElement je = fullName.resolveBinding().getJavaElement();
                if ((je = je.getAncestor(4)) != null) {
                    IJavaProject otherProject = (IJavaProject)je.getAncestor(2);
                    if (otherProject == null || !otherProject.equals((Object)this.locator.pattern.focus.getAncestor(2))) {
                        return DOMPackageReferenceLocator.toResponse(0);
                    }
                    if (!this.locator.pattern.focus.getElementName().equals(je.getElementName())) {
                        return DOMPackageReferenceLocator.toResponse(0);
                    }
                }
                return DOMPackageReferenceLocator.toResponse(3);
            }
        }
        if (binding == null) {
            return DOMPackageReferenceLocator.toResponse(3);
        }
        return DOMPackageReferenceLocator.toResponse(0);
    }
}

