/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.binary;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;

public abstract class AbstractCodeCreationOperation
implements IWorkspaceRunnable {
    protected final URI fOutputURI;
    protected final List<IPackageFragment> fPackages;

    protected AbstractCodeCreationOperation(URI uri, List<IPackageFragment> packages) {
        Assert.isNotNull((Object)uri);
        Assert.isNotNull(packages);
        this.fOutputURI = uri;
        this.fPackages = packages;
    }

    protected void createCompilationUnit(IFileStore store, String name, String content, IProgressMonitor monitor) throws CoreException {
        OutputStream stream = null;
        try {
            stream = new BufferedOutputStream(store.getChild(name).openOutputStream(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
            try {
                stream.write(content.getBytes());
            }
            catch (IOException exception) {
                throw new CoreException((IStatus)new Status(4, JavaManipulationPlugin.getPluginId(), 0, exception.getLocalizedMessage(), (Throwable)exception));
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void createPackageFragment(IFileStore store, String name, IProgressMonitor monitor) throws CoreException {
        store.mkdir(0, monitor);
    }

    protected abstract String getOperationLabel();

    protected abstract void run(IClassFile var1, IFileStore var2, IProgressMonitor var3) throws CoreException;

    public void run(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(this.getOperationLabel(), 100 * this.fPackages.size());
        try {
            StringBuilder builder = new StringBuilder(128);
            for (IPackageFragment fragment : this.fPackages) {
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 100);
                IClassFile[] files = fragment.getClassFiles();
                int size = files.length;
                subMonitor.beginTask(this.getOperationLabel(), size * 50);
                String name = fragment.getElementName();
                IFileStore store = EFS.getStore((URI)this.fOutputURI);
                if (!"".equals(name)) {
                    String pack = name;
                    builder.setLength(0);
                    builder.append(name);
                    int length = builder.length();
                    int index = 0;
                    while (index < length) {
                        if (builder.charAt(index) == '.') {
                            builder.setCharAt(index, '/');
                        }
                        ++index;
                    }
                    store = store.getFileStore((IPath)new Path(builder.toString()));
                    if (!pack.startsWith(".")) {
                        this.createPackageFragment(store, pack, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 10));
                    }
                } else {
                    this.createPackageFragment(store, "", (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 10));
                }
                SubProgressMonitor subsubMonitor = new SubProgressMonitor((IProgressMonitor)subMonitor, 30);
                try {
                    subsubMonitor.beginTask(this.getOperationLabel(), size * 100);
                    IClassFile[] iClassFileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IClassFile file = iClassFileArray[n2];
                        if (subMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        this.run(file, store, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subsubMonitor, 100));
                        ++n2;
                    }
                }
                finally {
                    subsubMonitor.done();
                }
            }
        }
        finally {
            monitor.done();
        }
    }
}

