/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.manipulation.CodeGeneration;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.IntroduceIndirectionDescriptor;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.BodyDeclarationRewrite;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTesterCore;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.RippleMethodFinder2;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.MemberVisibilityAdjustor;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;

public class IntroduceIndirectionRefactoring
extends Refactoring {
    private ICompilationUnit fSelectionCompilationUnit;
    private IClassFile fSelectionClassFile;
    private int fSelectionStart;
    private int fSelectionLength;
    private MethodInvocation fSelectionMethodInvocation;
    private IType fIntermediaryType;
    private ITypeBinding fIntermediaryTypeBinding;
    private String fIntermediaryMethodName;
    private ITypeBinding fIntermediaryFirstParameterType;
    private IMethod fTargetMethod;
    private IMethodBinding fTargetMethodBinding;
    private boolean fUpdateReferences;
    private Map<ICompilationUnit, CompilationUnitRewrite> fRewrites;
    private TextChangeManager fTextChangeManager;
    private MemberVisibilityAdjustor fAdjustor;
    private Map<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment> fIntermediaryAdjustments;

    public IntroduceIndirectionRefactoring(ICompilationUnit unit, int offset, int length) {
        this.fSelectionCompilationUnit = unit;
        this.initialize(offset, length);
    }

    public IntroduceIndirectionRefactoring(IClassFile file, int offset, int length) {
        this.fSelectionClassFile = file;
        this.initialize(offset, length);
    }

    public IntroduceIndirectionRefactoring(IMethod method) {
        this.fTargetMethod = method;
        this.initialize(0, 0);
    }

    public IntroduceIndirectionRefactoring(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this((ICompilationUnit)null, 0, 0);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    private void initialize(int offset, int length) {
        this.fSelectionStart = offset;
        this.fSelectionLength = length;
        this.fUpdateReferences = true;
    }

    public String getName() {
        return RefactoringCoreMessages.IntroduceIndirectionRefactoring_introduce_indirection_name;
    }

    public IJavaProject getProject() {
        if (this.fSelectionCompilationUnit != null) {
            return this.fSelectionCompilationUnit.getJavaProject();
        }
        if (this.fSelectionClassFile != null) {
            return this.fSelectionClassFile.getJavaProject();
        }
        if (this.fTargetMethod != null) {
            return this.fTargetMethod.getJavaProject();
        }
        return null;
    }

    public IPackageFragment getInvocationPackage() {
        return this.fSelectionCompilationUnit != null ? (IPackageFragment)this.fSelectionCompilationUnit.getAncestor(4) : null;
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public void setEnableUpdateReferences(boolean updateReferences) {
        this.fUpdateReferences = updateReferences;
    }

    public RefactoringStatus setIntermediaryMethodName(String newMethodName) {
        Assert.isNotNull((Object)newMethodName);
        this.fIntermediaryMethodName = newMethodName;
        IType context = this.fIntermediaryType != null ? this.fIntermediaryType : this.fTargetMethod;
        RefactoringStatus stat = Checks.checkMethodName(newMethodName, (IJavaElement)context);
        stat.merge(this.checkOverloading());
        return stat;
    }

    private RefactoringStatus checkOverloading() {
        try {
            if (this.fIntermediaryType != null) {
                IMethod[] toCheck;
                IMethod[] iMethodArray = toCheck = this.fIntermediaryType.getMethods();
                int n = toCheck.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod method = iMethodArray[n2];
                    if (method.getElementName().equals(this.fIntermediaryMethodName)) {
                        return RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_duplicate_method_name_in_declaring_type_error, BasicElementLabels.getJavaElementName(this.fIntermediaryMethodName)));
                    }
                    ++n2;
                }
            }
        }
        catch (JavaModelException e) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_could_not_parse_declaring_type_error);
        }
        return new RefactoringStatus();
    }

    public String getIntermediaryMethodName() {
        return this.fIntermediaryMethodName;
    }

    public RefactoringStatus setIntermediaryTypeName(String fullyQualifiedTypeName) {
        IType target = null;
        try {
            if (fullyQualifiedTypeName.length() == 0) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_type_not_selected_error);
            }
            target = this.getProject().findType(fullyQualifiedTypeName, (IProgressMonitor)new NullProgressMonitor());
            if (target == null || !target.exists()) {
                return RefactoringStatus.createErrorStatus((String)Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_type_does_not_exist_error, BasicElementLabels.getJavaElementName(fullyQualifiedTypeName)));
            }
            if (target.isAnnotation()) {
                return RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_cannot_create_in_annotation);
            }
            if (!(!target.isInterface() || JavaModelUtil.is1d8OrHigher(target.getJavaProject()) && JavaModelUtil.is1d8OrHigher(this.getProject()))) {
                return RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_cannot_create_on_interface);
            }
        }
        catch (JavaModelException e) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_unable_determine_declaring_type);
        }
        if (target.isReadOnly()) {
            return RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_cannot_create_in_readonly);
        }
        if (target.isBinary()) {
            return RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_cannot_create_in_binary);
        }
        this.fIntermediaryType = target;
        return new RefactoringStatus();
    }

    public String getIntermediaryTypeName() {
        return this.fIntermediaryType != null ? this.fIntermediaryType.getFullyQualifiedName('.') : "";
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        try {
            pm.beginTask(RefactoringCoreMessages.IntroduceIndirectionRefactoring_checking_activation, 1);
            this.fRewrites = new HashMap<ICompilationUnit, CompilationUnitRewrite>();
            if (this.fTargetMethod == null) {
                ASTNode selectionNode;
                if (this.fSelectionStart == 0) {
                    RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_not_available_on_this_selection);
                    return refactoringStatus;
                }
                if (this.fSelectionCompilationUnit != null) {
                    CompilationUnit selectionCURoot = this.getCachedCURewrite(this.fSelectionCompilationUnit).getRoot();
                    selectionNode = IntroduceIndirectionRefactoring.getSelectedNode(this.fSelectionCompilationUnit, selectionCURoot, this.fSelectionStart, this.fSelectionLength);
                } else {
                    ASTParser parser = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
                    parser.setResolveBindings(true);
                    parser.setSource(this.fSelectionClassFile);
                    CompilationUnit selectionCURoot = (CompilationUnit)parser.createAST(null);
                    selectionNode = IntroduceIndirectionRefactoring.getSelectedNode(null, selectionCURoot, this.fSelectionStart, this.fSelectionLength);
                }
                if (selectionNode == null) {
                    RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_not_available_on_this_selection);
                    return refactoringStatus;
                }
                IMethodBinding targetMethodBinding = null;
                if (selectionNode.getNodeType() == 32) {
                    targetMethodBinding = ((MethodInvocation)selectionNode).resolveMethodBinding();
                } else if (selectionNode.getNodeType() == 31) {
                    targetMethodBinding = ((MethodDeclaration)selectionNode).resolveBinding();
                } else if (selectionNode.getNodeType() == 48) {
                    targetMethodBinding = ((SuperMethodInvocation)selectionNode).resolveMethodBinding();
                }
                if (targetMethodBinding != null) {
                    this.fTargetMethodBinding = targetMethodBinding.getMethodDeclaration();
                    if (this.fTargetMethodBinding != null) {
                        this.fTargetMethod = (IMethod)this.fTargetMethodBinding.getJavaElement();
                        if (selectionNode instanceof MethodInvocation && this.fSelectionCompilationUnit != null) {
                            this.fSelectionMethodInvocation = (MethodInvocation)selectionNode;
                        }
                    }
                }
                if (targetMethodBinding == null || this.fTargetMethodBinding == null) {
                    RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_not_available_on_this_selection);
                    return refactoringStatus;
                }
            } else {
                if (this.fTargetMethod.getDeclaringType().isAnnotation()) {
                    RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_not_available_on_annotation);
                    return refactoringStatus;
                }
                if (this.fTargetMethod.getCompilationUnit() != null) {
                    CompilationUnit selectionCURoot = this.getCachedCURewrite(this.fTargetMethod.getCompilationUnit()).getRoot();
                    MethodDeclaration declaration = ASTNodeSearchUtil.getMethodDeclarationNode(this.fTargetMethod, selectionCURoot);
                    this.fTargetMethodBinding = declaration.resolveBinding().getMethodDeclaration();
                } else {
                    ASTParser parser = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
                    parser.setProject(this.fTargetMethod.getJavaProject());
                    IBinding[] bindings = parser.createBindings(new IJavaElement[]{this.fTargetMethod}, null);
                    this.fTargetMethodBinding = ((IMethodBinding)bindings[0]).getMethodDeclaration();
                }
            }
            if (this.fTargetMethod == null || this.fTargetMethodBinding == null || !RefactoringAvailabilityTesterCore.isIntroduceIndirectionAvailable(this.fTargetMethod)) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_not_available_on_this_selection);
                return refactoringStatus;
            }
            if (this.fTargetMethod.getDeclaringType().isLocal() || this.fTargetMethod.getDeclaringType().isAnonymous()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_not_available_for_local_or_anonymous_types);
                return refactoringStatus;
            }
            if (this.fTargetMethod.isConstructor()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_not_available_for_constructors);
                return refactoringStatus;
            }
            if (this.fIntermediaryMethodName == null) {
                this.fIntermediaryMethodName = this.fTargetMethod.getElementName();
            }
            if (this.fIntermediaryType == null) {
                if (this.fSelectionCompilationUnit != null && !this.fSelectionCompilationUnit.isReadOnly()) {
                    this.fIntermediaryType = this.getEnclosingInitialSelectionMember().getDeclaringType();
                } else if (!this.fTargetMethod.isBinary() && !this.fTargetMethod.isReadOnly()) {
                    this.fIntermediaryType = this.fTargetMethod.getDeclaringType();
                }
            }
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        this.fTextChangeManager = new TextChangeManager();
        this.fIntermediaryFirstParameterType = null;
        this.fIntermediaryTypeBinding = null;
        for (CompilationUnitRewrite compilationUnitRewrite : this.fRewrites.values()) {
            compilationUnitRewrite.clearASTAndImportRewrites();
        }
        int startupTicks = 5;
        int hierarchyTicks = 5;
        int visibilityTicks = 5;
        int referenceTicks = this.fUpdateReferences ? 30 : 5;
        int creationTicks = 5;
        pm.beginTask("", startupTicks + hierarchyTicks + visibilityTicks + referenceTicks + creationTicks);
        pm.setTaskName(RefactoringCoreMessages.IntroduceIndirectionRefactoring_checking_conditions);
        result.merge(Checks.checkMethodName(this.fIntermediaryMethodName, (IJavaElement)this.fIntermediaryType));
        if (result.hasFatalError()) {
            return result;
        }
        if (this.fIntermediaryType == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_cannot_run_without_intermediary_type);
        }
        CompilationUnitRewrite imRewrite = this.getCachedCURewrite(this.fIntermediaryType.getCompilationUnit());
        this.fIntermediaryTypeBinding = this.typeToBinding(this.fIntermediaryType, imRewrite.getRoot());
        this.fAdjustor = new MemberVisibilityAdjustor((IJavaElement)this.fIntermediaryType, (IMember)this.fIntermediaryType);
        this.fIntermediaryAdjustments = new HashMap<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment>();
        if (this.fIntermediaryTypeBinding.isNested() && !Modifier.isStatic(this.fIntermediaryTypeBinding.getModifiers())) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_cannot_create_in_nested_nonstatic, (RefactoringStatusContext)JavaStatusContext.create((IMember)this.fIntermediaryType));
        }
        pm.worked(startupTicks);
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (this.fUpdateReferences) {
            pm.setTaskName(RefactoringCoreMessages.IntroduceIndirectionRefactoring_checking_conditions + " " + RefactoringCoreMessages.IntroduceIndirectionRefactoring_looking_for_references);
            result.merge(this.updateReferences((IProgressMonitor)new NoOverrideProgressMonitor(pm, referenceTicks)));
            pm.setTaskName(RefactoringCoreMessages.IntroduceIndirectionRefactoring_checking_conditions);
        } else {
            if (this.fSelectionMethodInvocation != null) {
                this.fIntermediaryFirstParameterType = this.getExpressionType(this.fSelectionMethodInvocation);
                IMember enclosing = this.getEnclosingInitialSelectionMember();
                result.merge(this.updateMethodInvocation(this.fSelectionMethodInvocation, enclosing, this.getCachedCURewrite(this.fSelectionCompilationUnit)));
                if (!this.isRewriteKept(this.fSelectionCompilationUnit)) {
                    this.createChangeAndDiscardRewrite(this.fSelectionCompilationUnit);
                }
                result.merge(this.adjustVisibility((IMember)this.fIntermediaryType, (IMember)enclosing.getDeclaringType(), (IProgressMonitor)new NoOverrideProgressMonitor(pm, 0)));
            }
            pm.worked(referenceTicks);
        }
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (this.fIntermediaryFirstParameterType == null) {
            this.fIntermediaryFirstParameterType = this.fTargetMethodBinding.getDeclaringClass();
        }
        IType actualTargetType = (IType)this.fIntermediaryFirstParameterType.getJavaElement();
        if (!this.fTargetMethod.getDeclaringType().equals(actualTargetType)) {
            IMethod actualTargetMethod;
            this.fTargetMethod = actualTargetMethod = new MethodOverrideTester(actualTargetType, actualTargetType.newSupertypeHierarchy(null)).findOverriddenMethodInHierarchy(actualTargetType, this.fTargetMethod);
            this.fTargetMethodBinding = this.findMethodBindingInHierarchy(this.fIntermediaryFirstParameterType, actualTargetMethod);
            Assert.isNotNull((Object)this.fTargetMethodBinding);
        }
        result.merge(this.checkCanCreateIntermediaryMethod());
        this.createIntermediaryMethod();
        pm.worked(creationTicks);
        pm.setTaskName(RefactoringCoreMessages.IntroduceIndirectionRefactoring_checking_conditions + " " + RefactoringCoreMessages.IntroduceIndirectionRefactoring_adjusting_visibility);
        result.merge(this.updateTargetVisibility((IProgressMonitor)new NoOverrideProgressMonitor(pm, 0)));
        result.merge(this.updateIntermediaryVisibility(new NoOverrideProgressMonitor(pm, 0)));
        pm.worked(visibilityTicks);
        pm.setTaskName(RefactoringCoreMessages.IntroduceIndirectionRefactoring_checking_conditions);
        this.createChangeAndDiscardRewrite(this.fIntermediaryType.getCompilationUnit());
        result.merge(Checks.validateModifiesFiles(this.getAllFilesToModify(), this.getValidationContext(), pm));
        pm.done();
        return result;
    }

    private RefactoringStatus updateTargetVisibility(IProgressMonitor monitor) throws JavaModelException, CoreException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(this.adjustVisibility((IMember)((IType)this.fIntermediaryFirstParameterType.getJavaElement()), (IMember)this.fIntermediaryType, monitor));
        if (result.hasError()) {
            return result;
        }
        Modifier.ModifierKeyword neededVisibility = this.getNeededVisibility((IMember)this.fTargetMethod, (IMember)this.fIntermediaryType);
        result.merge(this.adjustVisibility((IMember)this.fTargetMethod, neededVisibility, monitor));
        if (result.hasError()) {
            return result;
        }
        ITypeHierarchy hierarchy = this.fTargetMethod.getDeclaringType().newTypeHierarchy(null);
        MethodOverrideTester tester = new MethodOverrideTester(this.fTargetMethod.getDeclaringType(), hierarchy);
        IType[] iTypeArray = hierarchy.getAllSubtypes(this.fTargetMethod.getDeclaringType());
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType subtype = iTypeArray[n2];
            IMethod method = tester.findOverridingMethodInType(subtype, this.fTargetMethod);
            if (method != null && method.exists()) {
                result.merge(this.adjustVisibility((IMember)method, neededVisibility, monitor));
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (result.hasError()) {
                    return result;
                }
            }
            ++n2;
        }
        return result;
    }

    private RefactoringStatus updateIntermediaryVisibility(NoOverrideProgressMonitor monitor) throws JavaModelException {
        return this.rewriteVisibility(this.fIntermediaryAdjustments, this.fRewrites, (IProgressMonitor)monitor);
    }

    private RefactoringStatus updateReferences(IProgressMonitor monitor) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        monitor.beginTask("", 90);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        IMethod[] ripple = RippleMethodFinder2.getRelatedMethods(this.fTargetMethod, false, (IProgressMonitor)new NoOverrideProgressMonitor(monitor, 10), null);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        SearchResultGroup[] references = Checks.excludeCompilationUnits(this.getReferences(ripple, (IProgressMonitor)new NoOverrideProgressMonitor(monitor, 10), result), result);
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(Checks.checkCompileErrorsInAffectedFiles(references));
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        int ticksPerCU = references.length == 0 ? 0 : 70 / references.length;
        SearchResultGroup[] searchResultGroupArray = references;
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            SearchResultGroup group = searchResultGroupArray[n2];
            SearchMatch[] searchResults = group.getSearchResults();
            CompilationUnitRewrite currentCURewrite = this.getCachedCURewrite(group.getCompilationUnit());
            SearchMatch[] searchMatchArray = searchResults;
            int n3 = searchResults.length;
            int n4 = 0;
            while (n4 < n3) {
                SearchMatch match = searchMatchArray[n4];
                if (!match.isInsideDocComment()) {
                    IMember enclosingMember = (IMember)match.getElement();
                    ASTNode target = IntroduceIndirectionRefactoring.getSelectedNode(group.getCompilationUnit(), currentCURewrite.getRoot(), match.getOffset(), match.getLength());
                    if (target instanceof SuperMethodInvocation) {
                        result.merge(this.createWarningAboutCall(enclosingMember, target, RefactoringCoreMessages.IntroduceIndirectionRefactoring_call_warning_super_keyword));
                    } else {
                        Assert.isTrue((boolean)(target instanceof MethodInvocation), (String)"Element of call should be a MethodInvocation.");
                        MethodInvocation invocation = (MethodInvocation)target;
                        ITypeBinding typeBinding = this.getExpressionType(invocation);
                        if (this.fIntermediaryFirstParameterType == null) {
                            this.fIntermediaryFirstParameterType = typeBinding.getTypeDeclaration();
                        } else {
                            result.merge(this.findCommonParent(typeBinding.getTypeDeclaration()));
                        }
                        if (result.hasFatalError()) {
                            return result;
                        }
                        result.merge(this.updateMethodInvocation(invocation, enclosingMember, currentCURewrite));
                        result.merge(this.adjustVisibility((IMember)this.fIntermediaryType, (IMember)enclosingMember.getDeclaringType(), (IProgressMonitor)new NoOverrideProgressMonitor(monitor, 0)));
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                    }
                }
                ++n4;
            }
            if (!this.isRewriteKept(group.getCompilationUnit())) {
                this.createChangeAndDiscardRewrite(group.getCompilationUnit());
            }
            monitor.worked(ticksPerCU);
            ++n2;
        }
        monitor.done();
        return result;
    }

    private RefactoringStatus findCommonParent(ITypeBinding typeBinding) {
        RefactoringStatus status = new RefactoringStatus();
        ITypeBinding current = typeBinding;
        ITypeBinding highest = this.fIntermediaryFirstParameterType;
        if (current.equals((Object)highest) || Bindings.isSuperType(highest, current)) {
            return status;
        }
        ITypeBinding[] currentAndSupers = this.getTypeAndAllSuperTypes(current);
        ITypeBinding[] highestAndSupers = this.getTypeAndAllSuperTypes(highest);
        ITypeBinding foundBinding = null;
        ITypeBinding[] iTypeBindingArray = currentAndSupers;
        int n = currentAndSupers.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding currentAndSuper = iTypeBindingArray[n2];
            ITypeBinding[] iTypeBindingArray2 = highestAndSupers;
            int n3 = highestAndSupers.length;
            int n4 = 0;
            while (n4 < n3) {
                ITypeBinding highestAndSuper = iTypeBindingArray2[n4];
                if (highestAndSuper.isEqualTo((IBinding)currentAndSuper) && Bindings.findMethodInHierarchy(highestAndSuper, this.fTargetMethodBinding.getName(), this.fTargetMethodBinding.getParameterTypes()) != null) {
                    foundBinding = highestAndSuper;
                    break;
                }
                ++n4;
            }
            if (foundBinding != null) break;
            ++n2;
        }
        if (foundBinding != null) {
            this.fIntermediaryFirstParameterType = foundBinding;
        } else {
            String type1 = BasicElementLabels.getJavaElementName(this.fIntermediaryFirstParameterType.getQualifiedName());
            String type2 = BasicElementLabels.getJavaElementName(current.getQualifiedName());
            status.addFatalError(Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_open_hierarchy_error, new String[]{type1, type2}));
        }
        return status;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        HashMap<String, String> arguments = new HashMap<String, String>();
        String project = null;
        IJavaProject javaProject = this.fTargetMethod.getJavaProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        int flags = 589830;
        IType declaring = this.fTargetMethod.getDeclaringType();
        try {
            if (declaring.isLocal() || declaring.isAnonymous()) {
                flags |= 0x40000;
            }
        }
        catch (JavaModelException exception) {
            JavaManipulationPlugin.log(exception);
        }
        String description = Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_descriptor_description_short, BasicElementLabels.getJavaElementName(this.fTargetMethod.getElementName()));
        String header = Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_descriptor_description, new String[]{JavaElementLabelsCore.getTextLabel(this.fTargetMethod, 2235681801344L), JavaElementLabelsCore.getTextLabel(declaring, 2235681801344L)});
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, (Object)this, header);
        comment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_original_pattern, JavaElementLabelsCore.getTextLabel(this.fTargetMethod, 2235681801344L)));
        comment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_method_pattern, BasicElementLabels.getJavaElementName(this.fIntermediaryMethodName)));
        comment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_declaring_pattern, JavaElementLabelsCore.getTextLabel(this.fIntermediaryType, 2235681801344L)));
        if (this.fUpdateReferences) {
            comment.addSetting(RefactoringCoreMessages.JavaRefactoringDescriptor_update_references);
        }
        IntroduceIndirectionDescriptor descriptor = RefactoringSignatureDescriptorFactory.createIntroduceIndirectionDescriptor(project, description, comment.asString(), arguments, flags);
        arguments.put("input", JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fTargetMethod));
        arguments.put("name", this.fIntermediaryMethodName);
        arguments.put("element1", JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fIntermediaryType));
        arguments.put("references", Boolean.toString(this.fUpdateReferences));
        return new DynamicValidationRefactoringChange(descriptor, RefactoringCoreMessages.IntroduceIndirectionRefactoring_introduce_indirection, (Change[])this.fTextChangeManager.getAllChanges());
    }

    private RefactoringStatus checkCanCreateIntermediaryMethod() throws JavaModelException {
        ArrayList<ITypeBinding> parameterBindings = new ArrayList<ITypeBinding>();
        if (!this.isStaticTarget()) {
            parameterBindings.add(this.fIntermediaryFirstParameterType);
        }
        parameterBindings.addAll(Arrays.asList(this.fTargetMethodBinding.getParameterTypes()));
        return Checks.checkMethodInType(this.fIntermediaryTypeBinding, this.fIntermediaryMethodName, parameterBindings.toArray(new ITypeBinding[parameterBindings.size()]));
    }

    private void createIntermediaryMethod() throws CoreException {
        String comment;
        CompilationUnitRewrite imRewrite = this.getCachedCURewrite(this.fIntermediaryType.getCompilationUnit());
        AST ast = imRewrite.getAST();
        MethodDeclaration intermediary = ast.newMethodDeclaration();
        AbstractTypeDeclaration type = (AbstractTypeDeclaration)this.typeToDeclaration(this.fIntermediaryType, imRewrite.getRoot());
        intermediary.setName(ast.newSimpleName(this.fIntermediaryMethodName));
        List modifiers = intermediary.modifiers();
        if (!this.fIntermediaryType.isInterface()) {
            modifiers.add(imRewrite.getAST().newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        }
        modifiers.add(imRewrite.getAST().newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
        String targetParameterName = StubUtility.suggestArgumentName(this.getProject(), this.fIntermediaryFirstParameterType.getName(), this.fTargetMethod.getParameterNames());
        ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)type, imRewrite.getImportRewrite());
        if (!this.isStaticTarget()) {
            SingleVariableDeclaration parameter = imRewrite.getAST().newSingleVariableDeclaration();
            Type t = imRewrite.getImportRewrite().addImport(this.fIntermediaryFirstParameterType, imRewrite.getAST(), (ImportRewrite.ImportRewriteContext)context, ImportRewrite.TypeLocation.PARAMETER);
            if (this.fIntermediaryFirstParameterType.isGenericType()) {
                ParameterizedType parameterized = imRewrite.getAST().newParameterizedType(t);
                ITypeBinding[] iTypeBindingArray = this.fIntermediaryFirstParameterType.getTypeParameters();
                int n = iTypeBindingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeBinding typeParameter = iTypeBindingArray[n2];
                    parameterized.typeArguments().add(imRewrite.getImportRewrite().addImport(typeParameter, imRewrite.getAST()));
                    ++n2;
                }
                t = parameterized;
            }
            parameter.setType(t);
            parameter.setName(imRewrite.getAST().newSimpleName(targetParameterName));
            intermediary.parameters().add(parameter);
        }
        this.copyArguments(intermediary, imRewrite, context);
        if (!this.isStaticTarget() && this.fIntermediaryFirstParameterType.isGenericType()) {
            this.addTypeParameters(imRewrite, intermediary.typeParameters(), this.fIntermediaryFirstParameterType, context);
        }
        this.copyTypeParameters(intermediary, imRewrite, context);
        intermediary.setReturnType2(imRewrite.getImportRewrite().addImport(this.fTargetMethodBinding.getReturnType(), ast, (ImportRewrite.ImportRewriteContext)context, ImportRewrite.TypeLocation.RETURN_TYPE));
        this.copyExceptions(intermediary, imRewrite, context);
        MethodInvocation invocation = imRewrite.getAST().newMethodInvocation();
        invocation.setName(imRewrite.getAST().newSimpleName(this.fTargetMethod.getElementName()));
        if (this.isStaticTarget()) {
            Type importedType = imRewrite.getImportRewrite().addImport(this.fTargetMethodBinding.getDeclaringClass(), ast, (ImportRewrite.ImportRewriteContext)context, ImportRewrite.TypeLocation.OTHER);
            invocation.setExpression((Expression)ASTNodeFactory.newName(ast, ASTNodes.asString((ASTNode)importedType)));
        } else {
            invocation.setExpression((Expression)imRewrite.getAST().newSimpleName(targetParameterName));
        }
        this.copyInvocationParameters(invocation, ast);
        Statement call = this.encapsulateInvocation(intermediary, invocation);
        Block body = imRewrite.getAST().newBlock();
        body.statements().add(call);
        intermediary.setBody(body);
        ICompilationUnit targetCU = imRewrite.getCu();
        if (StubUtility.doAddComments(targetCU.getJavaProject()) && (comment = CodeGeneration.getMethodComment(targetCU, this.getIntermediaryTypeName(), intermediary, null, StubUtility.getLineDelimiterUsed((IJavaElement)targetCU))) != null) {
            Javadoc javadoc = (Javadoc)imRewrite.getASTRewrite().createStringPlaceholder(comment, 29);
            intermediary.setJavadoc(javadoc);
        }
        ChildListPropertyDescriptor typeBodyDeclarationsProperty = this.typeToBodyDeclarationProperty(this.fIntermediaryType, imRewrite.getRoot());
        ListRewrite bodyDeclarationsListRewrite = imRewrite.getASTRewrite().getListRewrite((ASTNode)type, typeBodyDeclarationsProperty);
        bodyDeclarationsListRewrite.insertAt((ASTNode)intermediary, BodyDeclarationRewrite.getInsertionIndex((BodyDeclaration)intermediary, type.bodyDeclarations()), imRewrite.createGroupDescription(RefactoringCoreMessages.IntroduceIndirectionRefactoring_group_description_create_new_method));
    }

    private void addTypeParameters(CompilationUnitRewrite imRewrite, List<TypeParameter> list, ITypeBinding parent, ImportRewrite.ImportRewriteContext context) {
        ITypeBinding enclosing = parent.getDeclaringClass();
        if (enclosing != null) {
            this.addTypeParameters(imRewrite, list, enclosing, context);
        }
        ITypeBinding[] iTypeBindingArray = parent.getTypeParameters();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding typeParameter = iTypeBindingArray[n2];
            TypeParameter ntp = imRewrite.getAST().newTypeParameter();
            ntp.setName(imRewrite.getAST().newSimpleName(typeParameter.getName()));
            ITypeBinding[] iTypeBindingArray2 = typeParameter.getTypeBounds();
            int n3 = iTypeBindingArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                ITypeBinding bound = iTypeBindingArray2[n4];
                if (!"java.lang.Object".equals(bound.getQualifiedName())) {
                    ntp.typeBounds().add(imRewrite.getImportRewrite().addImport(bound, imRewrite.getAST(), context, ImportRewrite.TypeLocation.TYPE_BOUND));
                }
                ++n4;
            }
            list.add(ntp);
            ++n2;
        }
    }

    private Statement encapsulateInvocation(MethodDeclaration declaration, MethodInvocation invocation) {
        Type type = declaration.getReturnType2();
        if (type == null || type instanceof PrimitiveType && PrimitiveType.VOID.equals(((PrimitiveType)type).getPrimitiveTypeCode())) {
            return invocation.getAST().newExpressionStatement((Expression)invocation);
        }
        ReturnStatement statement = invocation.getAST().newReturnStatement();
        statement.setExpression((Expression)invocation);
        return statement;
    }

    private void copyInvocationParameters(MethodInvocation invocation, AST ast) throws JavaModelException {
        String[] stringArray = this.fTargetMethod.getParameterNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            invocation.arguments().add(ast.newSimpleName(name));
            ++n2;
        }
    }

    private void copyArguments(MethodDeclaration intermediary, CompilationUnitRewrite rew, ImportRewrite.ImportRewriteContext context) throws JavaModelException {
        String[] names = this.fTargetMethod.getParameterNames();
        ITypeBinding[] types = this.fTargetMethodBinding.getParameterTypes();
        int i = 0;
        while (i < names.length) {
            ITypeBinding typeBinding = types[i];
            SingleVariableDeclaration newElement = rew.getAST().newSingleVariableDeclaration();
            newElement.setName(rew.getAST().newSimpleName(names[i]));
            if (i == names.length - 1 && this.fTargetMethodBinding.isVarargs()) {
                newElement.setVarargs(true);
                if (typeBinding.isArray()) {
                    typeBinding = typeBinding.getComponentType();
                }
            }
            newElement.setType(rew.getImportRewrite().addImport(typeBinding, rew.getAST(), context, ImportRewrite.TypeLocation.PARAMETER));
            intermediary.parameters().add(newElement);
            ++i;
        }
    }

    private void copyTypeParameters(MethodDeclaration intermediary, CompilationUnitRewrite rew, ImportRewrite.ImportRewriteContext context) {
        ITypeBinding[] iTypeBindingArray = this.fTargetMethodBinding.getTypeParameters();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding current = iTypeBindingArray[n2];
            TypeParameter parameter = rew.getAST().newTypeParameter();
            parameter.setName(rew.getAST().newSimpleName(current.getName()));
            ITypeBinding[] iTypeBindingArray2 = current.getTypeBounds();
            int n3 = iTypeBindingArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                ITypeBinding bound = iTypeBindingArray2[n4];
                if (!"java.lang.Object".equals(bound.getQualifiedName())) {
                    parameter.typeBounds().add(rew.getImportRewrite().addImport(bound, rew.getAST(), context, ImportRewrite.TypeLocation.TYPE_BOUND));
                }
                ++n4;
            }
            intermediary.typeParameters().add(parameter);
            ++n2;
        }
    }

    private void copyExceptions(MethodDeclaration intermediary, CompilationUnitRewrite imRewrite, ImportRewrite.ImportRewriteContext context) {
        ITypeBinding[] iTypeBindingArray = this.fTargetMethodBinding.getExceptionTypes();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding typebinding = iTypeBindingArray[n2];
            Type exceptionType = imRewrite.getImportRewrite().addImport(typebinding, imRewrite.getAST(), context, ImportRewrite.TypeLocation.EXCEPTION);
            intermediary.thrownExceptionTypes().add(exceptionType);
            ++n2;
        }
    }

    private RefactoringStatus updateMethodInvocation(MethodInvocation originalInvocation, IMember enclosing, CompilationUnitRewrite unitRewriter) throws JavaModelException {
        RefactoringStatus status = new RefactoringStatus();
        if (originalInvocation.typeArguments().size() > 0) {
            return this.createWarningAboutCall(enclosing, (ASTNode)originalInvocation, RefactoringCoreMessages.IntroduceIndirectionRefactoring_call_warning_type_arguments);
        }
        MethodInvocation newInvocation = unitRewriter.getAST().newMethodInvocation();
        List newInvocationArgs = newInvocation.arguments();
        List originalInvocationArgs = originalInvocation.arguments();
        ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)originalInvocation, unitRewriter.getImportRewrite());
        String qualifier = unitRewriter.getImportRewrite().addImport(this.fIntermediaryTypeBinding, (ImportRewrite.ImportRewriteContext)context);
        newInvocation.setExpression((Expression)ASTNodeFactory.newName(unitRewriter.getAST(), qualifier));
        newInvocation.setName(unitRewriter.getAST().newSimpleName(this.getIntermediaryMethodName()));
        Expression expression = originalInvocation.getExpression();
        if (!this.isStaticTarget()) {
            if (expression == null) {
                ThisExpression expr = unitRewriter.getAST().newThisExpression();
                RefactoringStatus qualifierStatus = this.qualifyThisExpression(expr, originalInvocation, enclosing, unitRewriter);
                status.merge(qualifierStatus);
                if (qualifierStatus.hasEntries()) {
                    return status;
                }
                newInvocationArgs.add(expr);
            } else {
                Expression expressionAsParam = (Expression)unitRewriter.getASTRewrite().createMoveTarget((ASTNode)expression);
                newInvocationArgs.add(expressionAsParam);
            }
        } else if (!(expression == null || expression instanceof Name && ASTNodes.getTypeBinding((Name)expression) != null)) {
            return this.createWarningAboutCall(enclosing, (ASTNode)originalInvocation, RefactoringCoreMessages.IntroduceIndirectionRefactoring_call_warning_static_expression_access);
        }
        int i = 0;
        while (i < originalInvocationArgs.size()) {
            Expression originalInvocationArg = (Expression)originalInvocationArgs.get(i);
            Expression movedArg = (Expression)unitRewriter.getASTRewrite().createMoveTarget((ASTNode)originalInvocationArg);
            newInvocationArgs.add(movedArg);
            ++i;
        }
        unitRewriter.getASTRewrite().replace((ASTNode)originalInvocation, (ASTNode)newInvocation, unitRewriter.createGroupDescription(RefactoringCoreMessages.IntroduceIndirectionRefactoring_group_description_replace_call));
        return status;
    }

    private RefactoringStatus qualifyThisExpression(ThisExpression expr, MethodInvocation originalInvocation, IMember enclosing, CompilationUnitRewrite unitRewriter) {
        RefactoringStatus status = new RefactoringStatus();
        IMethodBinding methodBinding = originalInvocation.resolveMethodBinding();
        MethodDeclaration methodDeclaration = (MethodDeclaration)ASTNodes.findDeclaration((IBinding)methodBinding, originalInvocation.getRoot());
        ITypeBinding currentTypeBinding = null;
        if (methodDeclaration != null) {
            currentTypeBinding = ASTNodes.isParent((ASTNode)originalInvocation, methodDeclaration.getParent()) ? methodBinding.getDeclaringClass() : ASTNodes.getEnclosingType((ASTNode)originalInvocation);
        } else {
            ASTNode currentTypeDeclaration = this.getEnclosingTypeDeclaration((ASTNode)originalInvocation);
            currentTypeBinding = ASTNodes.getEnclosingType(currentTypeDeclaration);
            while (currentTypeDeclaration != null && Bindings.findMethodInHierarchy(currentTypeBinding, methodBinding.getName(), methodBinding.getParameterTypes()) == null) {
                currentTypeDeclaration = this.getEnclosingTypeDeclaration(currentTypeDeclaration.getParent());
                currentTypeBinding = ASTNodes.getEnclosingType(currentTypeDeclaration);
            }
        }
        if (currentTypeBinding == null) {
            status.merge(this.createWarningAboutCall(enclosing, (ASTNode)originalInvocation, RefactoringCoreMessages.IntroduceIndirectionRefactoring_call_warning_declaring_type_not_found));
            return status;
        }
        currentTypeBinding = currentTypeBinding.getTypeDeclaration();
        ITypeBinding typeOfCall = ASTNodes.getEnclosingType((ASTNode)originalInvocation);
        if (!typeOfCall.equals((Object)currentTypeBinding)) {
            if (currentTypeBinding.isAnonymous()) {
                status.merge(this.createWarningAboutCall(enclosing, (ASTNode)originalInvocation, RefactoringCoreMessages.IntroduceIndirectionRefactoring_call_warning_anonymous_cannot_qualify));
            } else {
                expr.setQualifier((Name)unitRewriter.getAST().newSimpleName(currentTypeBinding.getName()));
            }
        }
        return status;
    }

    private IMethodBinding findMethodBindingInHierarchy(ITypeBinding currentTypeBinding, IMethod methodDeclaration) {
        IMethodBinding b;
        IMethodBinding[] iMethodBindingArray = currentTypeBinding.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding binding = iMethodBindingArray[n2];
            if (methodDeclaration.equals(binding.getJavaElement())) {
                return binding;
            }
            ++n2;
        }
        ITypeBinding superClass = currentTypeBinding.getSuperclass();
        if (superClass != null && (b = this.findMethodBindingInHierarchy(superClass, methodDeclaration)) != null) {
            return b;
        }
        ITypeBinding[] iTypeBindingArray = currentTypeBinding.getInterfaces();
        int n3 = iTypeBindingArray.length;
        n = 0;
        while (n < n3) {
            ITypeBinding intf = iTypeBindingArray[n];
            IMethodBinding b2 = this.findMethodBindingInHierarchy(intf, methodDeclaration);
            if (b2 != null) {
                return b2;
            }
            ++n;
        }
        return null;
    }

    private ITypeBinding[] getTypeAndAllSuperTypes(ITypeBinding type) {
        ArrayList<ITypeBinding> result = new ArrayList<ITypeBinding>();
        this.collectSuperTypes(type, result);
        return result.toArray(new ITypeBinding[result.size()]);
    }

    private void collectSuperTypes(ITypeBinding curr, List<ITypeBinding> list) {
        if (list.add(curr.getTypeDeclaration())) {
            ITypeBinding[] iTypeBindingArray = curr.getInterfaces();
            int n = iTypeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding intf = iTypeBindingArray[n2];
                this.collectSuperTypes(intf, list);
                ++n2;
            }
            ITypeBinding superClass = curr.getSuperclass();
            if (superClass != null) {
                this.collectSuperTypes(superClass, list);
            }
        }
    }

    private CompilationUnitRewrite getCachedCURewrite(ICompilationUnit unit) {
        CompilationUnit cuNode;
        CompilationUnitRewrite rewrite = this.fRewrites.get(unit);
        if (rewrite == null && this.fSelectionMethodInvocation != null && (cuNode = ASTResolving.findParentCompilationUnit((ASTNode)this.fSelectionMethodInvocation)) != null && cuNode.getJavaElement().equals(unit)) {
            rewrite = new CompilationUnitRewrite(unit, cuNode);
            this.fRewrites.put(unit, rewrite);
        }
        if (rewrite == null) {
            rewrite = new CompilationUnitRewrite(unit);
            this.fRewrites.put(unit, rewrite);
        }
        return rewrite;
    }

    private boolean isRewriteKept(ICompilationUnit compilationUnit) {
        return this.fIntermediaryType.getCompilationUnit().equals(compilationUnit);
    }

    private void createChangeAndDiscardRewrite(ICompilationUnit compilationUnit) throws CoreException {
        CompilationUnitRewrite rewrite = this.fRewrites.get(compilationUnit);
        if (rewrite != null) {
            this.fTextChangeManager.manage(compilationUnit, (TextChange)rewrite.createChange(true));
            this.fRewrites.remove(compilationUnit);
        }
    }

    private SearchResultGroup[] getReferences(IMethod[] methods, IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        SearchPattern pattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])methods, 2);
        IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)this.fIntermediaryType, false);
        return RefactoringSearchEngine.search(pattern, scope, pm, status);
    }

    private ITypeBinding typeToBinding(IType type, CompilationUnit root) throws JavaModelException {
        ASTNode typeNode = this.typeToDeclaration(type, root);
        if (type.isAnonymous()) {
            return ((AnonymousClassDeclaration)typeNode).resolveBinding();
        }
        return ((AbstractTypeDeclaration)typeNode).resolveBinding();
    }

    private ASTNode typeToDeclaration(IType type, CompilationUnit root) throws JavaModelException {
        Name intermediateName = (Name)NodeFinder.perform((ASTNode)root, (ISourceRange)type.getNameRange());
        if (type.isAnonymous()) {
            return ASTNodes.getParent((ASTNode)intermediateName, AnonymousClassDeclaration.class);
        }
        return ASTNodes.getParent((ASTNode)intermediateName, AbstractTypeDeclaration.class);
    }

    private ASTNode getEnclosingTypeDeclaration(ASTNode node) {
        while (node != null) {
            if (node instanceof AbstractTypeDeclaration || node instanceof AnonymousClassDeclaration) {
                return node;
            }
            node = node.getParent();
        }
        return null;
    }

    private ChildListPropertyDescriptor typeToBodyDeclarationProperty(IType type, CompilationUnit root) throws JavaModelException {
        ASTNode typeDeclaration = this.typeToDeclaration(type, root);
        if (typeDeclaration instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)typeDeclaration).getBodyDeclarationsProperty();
        }
        if (typeDeclaration instanceof AnonymousClassDeclaration) {
            return AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY;
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private RefactoringStatus createWarningAboutCall(IMember enclosing, ASTNode concreteNode, String message) {
        String name = JavaElementLabelsCore.getElementLabel((IJavaElement)enclosing, 0x200009L);
        String container = JavaElementLabelsCore.getElementLabel((IJavaElement)enclosing.getDeclaringType(), 2235681801344L);
        return RefactoringStatus.createWarningStatus((String)Messages.format(message, new String[]{name, container}), (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)enclosing.getCompilationUnit(), concreteNode));
    }

    private ITypeBinding getExpressionType(MethodInvocation invocation) {
        Expression expression = invocation.getExpression();
        ITypeBinding typeBinding = null;
        typeBinding = expression == null ? invocation.resolveMethodBinding().getDeclaringClass() : expression.resolveTypeBinding();
        if (typeBinding != null && typeBinding.isTypeVariable()) {
            ITypeBinding[] typeBounds = typeBinding.getTypeBounds();
            if (typeBounds.length > 0) {
                ITypeBinding[] iTypeBindingArray = typeBounds;
                int n = typeBounds.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeBinding typeBound = iTypeBindingArray[n2];
                    ITypeBinding expressionType = this.getExpressionType(invocation, typeBound);
                    if (expressionType != null) {
                        return expressionType;
                    }
                    ++n2;
                }
                typeBinding = typeBounds[0].getTypeDeclaration();
            } else {
                typeBinding = invocation.getAST().resolveWellKnownType("java.lang.Object");
            }
        }
        Assert.isNotNull((Object)typeBinding, (String)"Type binding of target expression may not be null");
        return typeBinding;
    }

    private ITypeBinding getExpressionType(MethodInvocation invocation, ITypeBinding typeBinding) {
        if (typeBinding == null) {
            return null;
        }
        IMethodBinding[] iMethodBindingArray = typeBinding.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding iMethodBinding = iMethodBindingArray[n2];
            if (invocation.resolveMethodBinding() == iMethodBinding) {
                return typeBinding.getTypeDeclaration();
            }
            ++n2;
        }
        ITypeBinding expressionType = this.getExpressionType(invocation, typeBinding.getSuperclass());
        if (expressionType != null) {
            return expressionType;
        }
        ITypeBinding[] iTypeBindingArray = typeBinding.getInterfaces();
        int n3 = iTypeBindingArray.length;
        n = 0;
        while (n < n3) {
            ITypeBinding interfaceBinding = iTypeBindingArray[n];
            expressionType = this.getExpressionType(invocation, interfaceBinding);
            if (expressionType != null) {
                return expressionType;
            }
            ++n;
        }
        return null;
    }

    private IFile[] getAllFilesToModify() {
        return ResourceUtil.getFiles((ICompilationUnit[])this.fTextChangeManager.getAllCompilationUnits().clone());
    }

    private boolean isStaticTarget() throws JavaModelException {
        return Flags.isStatic((int)this.fTargetMethod.getFlags());
    }

    private IMember getEnclosingInitialSelectionMember() throws JavaModelException {
        return (IMember)this.fSelectionCompilationUnit.getElementAt(this.fSelectionStart);
    }

    private static ASTNode getSelectedNode(ICompilationUnit unit, CompilationUnit root, int offset, int length) {
        ASTNode node = null;
        try {
            node = unit != null ? IntroduceIndirectionRefactoring.checkNode(NodeFinder.perform((ASTNode)root, (int)offset, (int)length, (ITypeRoot)unit)) : IntroduceIndirectionRefactoring.checkNode(NodeFinder.perform((ASTNode)root, (int)offset, (int)length));
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        if (node != null) {
            return node;
        }
        return IntroduceIndirectionRefactoring.checkNode(NodeFinder.perform((ASTNode)root, (int)offset, (int)length));
    }

    private static ASTNode checkNode(ASTNode node) {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 42) {
            node = node.getParent();
        } else if (node.getNodeType() == 21) {
            node = ((ExpressionStatement)node).getExpression();
        }
        switch (node.getNodeType()) {
            case 31: 
            case 32: 
            case 48: {
                return node;
            }
        }
        return null;
    }

    private Modifier.ModifierKeyword getNeededVisibility(IMember whoToAdjust, IMember fromWhereToLook) throws JavaModelException {
        return this.fAdjustor.getVisibilityThreshold((IJavaElement)fromWhereToLook, whoToAdjust, (IProgressMonitor)new NullProgressMonitor());
    }

    private RefactoringStatus adjustVisibility(IMember whoToAdjust, IMember fromWhereToLook, IProgressMonitor monitor) throws CoreException {
        return this.adjustVisibility(whoToAdjust, this.getNeededVisibility(whoToAdjust, fromWhereToLook), true, monitor);
    }

    private RefactoringStatus adjustVisibility(IMember whoToAdjust, Modifier.ModifierKeyword neededVisibility, IProgressMonitor monitor) throws CoreException {
        return this.adjustVisibility(whoToAdjust, neededVisibility, false, monitor);
    }

    private RefactoringStatus adjustVisibility(IMember whoToAdjust, Modifier.ModifierKeyword neededVisibility, boolean alsoIncreaseEnclosing, IProgressMonitor monitor) throws CoreException {
        boolean hasNewAdjustments;
        Map<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment> adjustments = this.isRewriteKept(whoToAdjust.getCompilationUnit()) ? this.fIntermediaryAdjustments : new HashMap<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment>();
        int existingAdjustments = adjustments.size();
        this.addAdjustment(whoToAdjust, neededVisibility, adjustments);
        if (alsoIncreaseEnclosing) {
            while (whoToAdjust.getDeclaringType() != null) {
                whoToAdjust = whoToAdjust.getDeclaringType();
                this.addAdjustment(whoToAdjust, neededVisibility, adjustments);
            }
        }
        boolean bl = hasNewAdjustments = adjustments.size() - existingAdjustments > 0;
        if (hasNewAdjustments && (whoToAdjust.isReadOnly() || whoToAdjust.isBinary())) {
            return RefactoringStatus.createErrorStatus((String)Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_cannot_update_binary_target_visibility, new String[]{JavaElementLabelsCore.getElementLabel((IJavaElement)whoToAdjust, 0x200009L)}), (RefactoringStatusContext)JavaStatusContext.create(whoToAdjust));
        }
        RefactoringStatus status = new RefactoringStatus();
        if (!hasNewAdjustments) {
            return status;
        }
        try {
            monitor.beginTask(RefactoringCoreMessages.MemberVisibilityAdjustor_adjusting, 2);
            if (!this.isRewriteKept(whoToAdjust.getCompilationUnit())) {
                CompilationUnitRewrite rewrite = new CompilationUnitRewrite(whoToAdjust.getCompilationUnit());
                rewrite.setResolveBindings(false);
                HashMap<ICompilationUnit, CompilationUnitRewrite> rewrites = new HashMap<ICompilationUnit, CompilationUnitRewrite>();
                rewrites.put(whoToAdjust.getCompilationUnit(), rewrite);
                status.merge(this.rewriteVisibility(adjustments, rewrites, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)));
                rewrite.attachChange((CompilationUnitChange)this.fTextChangeManager.get(whoToAdjust.getCompilationUnit()), true, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }

    private RefactoringStatus rewriteVisibility(Map<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment> adjustments, Map<ICompilationUnit, CompilationUnitRewrite> rewrites, IProgressMonitor monitor) throws JavaModelException {
        RefactoringStatus status = new RefactoringStatus();
        this.fAdjustor.setRewrites(rewrites);
        this.fAdjustor.setAdjustments(adjustments);
        this.fAdjustor.setStatus(status);
        this.fAdjustor.rewriteVisibility(monitor);
        return status;
    }

    private void addAdjustment(IMember whoToAdjust, Modifier.ModifierKeyword neededVisibility, Map<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment> adjustments) throws JavaModelException {
        Modifier.ModifierKeyword currentVisibility = Modifier.ModifierKeyword.fromFlagValue((int)JdtFlags.getVisibilityCode(whoToAdjust));
        if (MemberVisibilityAdjustor.hasLowerVisibility(currentVisibility, neededVisibility) && MemberVisibilityAdjustor.needsVisibilityAdjustments(whoToAdjust, neededVisibility, adjustments)) {
            adjustments.put(whoToAdjust, new MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment(whoToAdjust, neededVisibility, RefactoringStatus.createWarningStatus((String)Messages.format(MemberVisibilityAdjustor.getMessage(whoToAdjust), new String[]{MemberVisibilityAdjustor.getLabel((IJavaElement)whoToAdjust), MemberVisibilityAdjustor.getLabel(neededVisibility)}), (RefactoringStatusContext)JavaStatusContext.create(whoToAdjust))));
        }
    }

    private RefactoringStatus initialize(JavaRefactoringArguments arguments) {
        IJavaElement element;
        String handle = arguments.getAttribute("input");
        if (handle != null) {
            element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
            if (element == null || !element.exists() || element.getElementType() != 9) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getName(), "org.eclipse.jdt.ui.introduce.indirection");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        this.fTargetMethod = (IMethod)element;
        handle = arguments.getAttribute("element1");
        if (handle != null) {
            element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
            if (element == null || !element.exists() || element.getElementType() != 7) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getName(), "org.eclipse.jdt.ui.introduce.indirection");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "element1"));
        }
        this.fIntermediaryType = (IType)element;
        String references = arguments.getAttribute("references");
        if (references == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "references"));
        }
        this.fUpdateReferences = Boolean.parseBoolean(references);
        String name = arguments.getAttribute("name");
        if (name != null && !"".equals(name)) {
            return this.setIntermediaryMethodName(name);
        }
        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
    }

    private static class NoOverrideProgressMonitor
    extends SubProgressMonitor {
        public NoOverrideProgressMonitor(IProgressMonitor monitor, int ticks) {
            super(monitor, ticks, 2);
        }

        public void setTaskName(String name) {
        }
    }
}

