/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.manipulation.CUCorrectionProposalCore;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class CorrectPackageDeclarationProposalCore
extends CUCorrectionProposalCore {
    private IProblemLocationCore fLocation;

    public CorrectPackageDeclarationProposalCore(ICompilationUnit cu, IProblemLocationCore location, int relevance) {
        super(CorrectionMessages.CorrectPackageDeclarationProposal_name, cu, relevance);
        this.fLocation = location;
    }

    @Override
    public void addEdits(IDocument doc, TextEdit root) throws CoreException {
        super.addEdits(doc, root);
        ICompilationUnit cu = this.getCompilationUnit();
        IPackageFragment parentPack = (IPackageFragment)cu.getParent();
        IPackageDeclaration[] decls = cu.getPackageDeclarations();
        if (parentPack.isDefaultPackage() && decls.length > 0) {
            IPackageDeclaration[] iPackageDeclarationArray = decls;
            int n = decls.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageDeclaration decl = iPackageDeclarationArray[n2];
                ISourceRange range = decl.getSourceRange();
                root.addChild((TextEdit)new DeleteEdit(range.getOffset(), range.getLength()));
                ++n2;
            }
            return;
        }
        if (!parentPack.isDefaultPackage() && decls.length == 0) {
            String lineDelim = StubUtility.getLineDelimiterUsed((IJavaElement)cu);
            String str = "package " + parentPack.getElementName() + ";" + lineDelim + lineDelim;
            root.addChild((TextEdit)new InsertEdit(0, str));
            return;
        }
        root.addChild((TextEdit)new ReplaceEdit(this.fLocation.getOffset(), this.fLocation.getLength(), parentPack.getElementName()));
    }

    @Override
    public String getName() {
        ICompilationUnit cu = this.getCompilationUnit();
        IPackageFragment parentPack = (IPackageFragment)cu.getParent();
        try {
            IPackageDeclaration[] decls = cu.getPackageDeclarations();
            if (parentPack.isDefaultPackage() && decls.length > 0) {
                return Messages.format(CorrectionMessages.CorrectPackageDeclarationProposal_remove_description, BasicElementLabels.getJavaElementName(decls[0].getElementName()));
            }
            if (!parentPack.isDefaultPackage() && decls.length == 0) {
                return Messages.format(CorrectionMessages.CorrectPackageDeclarationProposal_add_description, JavaElementLabelsCore.getElementLabel((IJavaElement)parentPack, 0x200009L));
            }
        }
        catch (JavaModelException e) {
            JavaManipulationPlugin.log(e);
        }
        return Messages.format(CorrectionMessages.CorrectPackageDeclarationProposal_change_description, JavaElementLabelsCore.getElementLabel((IJavaElement)parentPack, 0x200009L));
    }

    public static boolean isValidProposal(ICompilationUnit cu) {
        boolean isValid;
        block5: {
            isValid = true;
            IPackageFragment parentPack = (IPackageFragment)cu.getParent();
            try {
                IJavaProject jProject;
                IPackageDeclaration[] decls = cu.getPackageDeclarations();
                if (!parentPack.isDefaultPackage() || decls.length <= 0 || (jProject = parentPack.getJavaProject()) == null || !JavaModelUtil.is9OrHigher(jProject)) break block5;
                try {
                    IModuleDescription desc = jProject.getModuleDescription();
                    if (desc != null && desc.exists()) {
                        isValid = false;
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
            catch (JavaModelException e) {
                JavaManipulationPlugin.log(e);
            }
        }
        return isValid;
    }
}

