/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.YieldStatement;

public class MethodInvocationLocator
extends ASTVisitor {
    private int line;
    private CompilationUnit unit;
    private Map<ASTNode, IMethodBinding> targets;

    public MethodInvocationLocator(int line, CompilationUnit unit) {
        super(false);
        this.line = line;
        this.unit = unit;
        this.targets = new HashMap<ASTNode, IMethodBinding>();
    }

    public boolean visit(FieldDeclaration node) {
        return this.shouldVisitNode((ASTNode)node);
    }

    public boolean visit(MethodDeclaration node) {
        return this.shouldVisitNode((ASTNode)node);
    }

    public boolean visit(TypeDeclaration node) {
        return this.shouldVisitNode((ASTNode)node);
    }

    public boolean visit(AnonymousClassDeclaration node) {
        return this.shouldVisitNode((ASTNode)node);
    }

    public boolean visit(EnumDeclaration node) {
        return this.shouldVisitNode((ASTNode)node);
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        return this.shouldVisitNode((ASTNode)node);
    }

    public boolean visit(VariableDeclarationStatement node) {
        return this.shouldVisitNode((ASTNode)node);
    }

    public boolean visit(ExpressionStatement node) {
        return this.shouldVisitNode((ASTNode)node);
    }

    public boolean visit(AssertStatement node) {
        return this.shouldVisitNode((ASTNode)node);
    }

    public boolean visit(BreakStatement node) {
        return this.shouldVisitNode((ASTNode)node);
    }

    public boolean visit(ContinueStatement node) {
        return this.shouldVisitNode((ASTNode)node);
    }

    public boolean visit(DoStatement node) {
        return this.shouldVisitNode((ASTNode)node);
    }

    public boolean visit(EmptyStatement node) {
        return this.shouldVisitNode((ASTNode)node);
    }

    public boolean visit(EnhancedForStatement node) {
        return this.shouldVisitNode((ASTNode)node);
    }

    public boolean visit(ForStatement node) {
        return this.shouldVisitNode((ASTNode)node);
    }

    public boolean visit(IfStatement node) {
        return this.shouldVisitNode((ASTNode)node);
    }

    public boolean visit(LabeledStatement node) {
        return this.shouldVisitNode((ASTNode)node);
    }

    public boolean visit(ReturnStatement node) {
        return this.shouldVisitNode((ASTNode)node);
    }

    public boolean visit(SwitchStatement node) {
        return this.shouldVisitNode((ASTNode)node);
    }

    public boolean visit(SynchronizedStatement node) {
        return this.shouldVisitNode((ASTNode)node);
    }

    public boolean visit(ThrowStatement node) {
        return this.shouldVisitNode((ASTNode)node);
    }

    public boolean visit(TryStatement node) {
        return this.shouldVisitNode((ASTNode)node);
    }

    public boolean visit(TypeDeclarationStatement node) {
        return this.shouldVisitNode((ASTNode)node);
    }

    public boolean visit(WhileStatement node) {
        return this.shouldVisitNode((ASTNode)node);
    }

    public boolean visit(YieldStatement node) {
        return this.shouldVisitNode((ASTNode)node);
    }

    public boolean visit(ConstructorInvocation node) {
        if (this.shouldVisitNode((ASTNode)node)) {
            this.targets.put((ASTNode)node, node.resolveConstructorBinding());
            return true;
        }
        return false;
    }

    public boolean visit(SuperConstructorInvocation node) {
        if (this.shouldVisitNode((ASTNode)node)) {
            this.targets.put((ASTNode)node, node.resolveConstructorBinding());
            return true;
        }
        return false;
    }

    public boolean visit(MethodInvocation node) {
        this.targets.put((ASTNode)node, node.resolveMethodBinding());
        return true;
    }

    public boolean visit(ClassInstanceCreation node) {
        this.targets.put((ASTNode)node, node.resolveConstructorBinding());
        return true;
    }

    private boolean shouldVisitNode(ASTNode node) {
        int start = this.unit.getLineNumber(node.getStartPosition());
        int end = this.unit.getLineNumber(node.getStartPosition() + node.getLength());
        return this.line >= start && this.line <= end;
    }

    public Map<ASTNode, IMethodBinding> getTargets() {
        return this.targets;
    }
}

