/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.AbortSearchException;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineMethodRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextEditUtil;
import org.eclipse.jdt.internal.ui.text.correction.QuickAssistProcessorUtil;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class InlineMethodFixCore
implements IProposableFix {
    private final String fName;
    private final ICompilationUnit fCompilationUnit;
    private final List<InlineMethodRefactoring> fRefactoringList;
    private final List<MethodInvocation> fMethodInvocations;

    private InlineMethodFixCore(String name, CompilationUnit compilationUnit, InlineMethodRefactoring refactoring, MethodInvocation methodInvocation) {
        this.fName = name;
        this.fCompilationUnit = (ICompilationUnit)compilationUnit.getJavaElement();
        this.fRefactoringList = List.of(refactoring);
        this.fMethodInvocations = List.of(methodInvocation);
    }

    private InlineMethodFixCore(String name, CompilationUnit compilationUnit, List<InlineMethodRefactoring> refactorings, List<MethodInvocation> methodInvocations) {
        this.fName = name;
        this.fCompilationUnit = (ICompilationUnit)compilationUnit.getJavaElement();
        this.fRefactoringList = refactorings;
        this.fMethodInvocations = methodInvocations;
    }

    public static InlineMethodFixCore create(String name, CompilationUnit compilationUnit, MethodInvocation methodInvocation) {
        ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
        InlineMethodRefactoring refactoring = InlineMethodRefactoring.create((ITypeRoot)cu, compilationUnit, methodInvocation.getStartPosition(), methodInvocation.getLength());
        try {
            RefactoringStatus status = refactoring.checkAllConditions((IProgressMonitor)new NullProgressMonitor());
            if (!status.isOK()) {
                return null;
            }
        }
        catch (CoreException | OperationCanceledException e) {
            return null;
        }
        InlineMethodFixCore fix = new InlineMethodFixCore(name, compilationUnit, refactoring, methodInvocation);
        return fix;
    }

    public static InlineMethodFixCore create(String name, CompilationUnit compilationUnit, List<MethodInvocation> methodInvocations) {
        ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
        ArrayList<InlineMethodRefactoring> refactorings = new ArrayList<InlineMethodRefactoring>();
        for (MethodInvocation methodInvocation : methodInvocations) {
            InlineMethodRefactoring refactoring = InlineMethodRefactoring.create((ITypeRoot)cu, compilationUnit, methodInvocation.getStartPosition(), methodInvocation.getLength());
            try {
                RefactoringStatus status = refactoring.checkAllConditions((IProgressMonitor)new NullProgressMonitor());
                if (!status.isOK()) {
                    return null;
                }
            }
            catch (CoreException | OperationCanceledException e) {
                return null;
            }
            refactorings.add(refactoring);
        }
        return new InlineMethodFixCore(name, compilationUnit, refactorings, methodInvocations);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompilationUnitChange createChange(IProgressMonitor progressMonitor) throws CoreException {
        Change change;
        TextChange node;
        List methodInvocations;
        LinkedHashMap callMap = new LinkedHashMap();
        HashSet<MethodInvocation> needsParentheses = new HashSet<MethodInvocation>();
        for (MethodInvocation methodInvocation : this.fMethodInvocations) {
            MethodDeclaration methodDeclaration = ASTNodes.getFirstAncestorOrNull((ASTNode)methodInvocation, MethodDeclaration.class);
            if (!callMap.containsKey(methodDeclaration)) {
                callMap.put(methodDeclaration, new ArrayList());
            }
            List methodInvocationList = (List)callMap.get(methodDeclaration);
            methodInvocationList.add(methodInvocation);
        }
        for (MethodDeclaration methodDeclaration : callMap.keySet()) {
            methodInvocations = (List)callMap.get(methodDeclaration);
            if (methodInvocations.size() > 1) {
                ArrayList methodInvocationsCopy = new ArrayList(methodInvocations);
                for (MethodInvocation methodInvocation : methodInvocationsCopy) {
                    try {
                        if (this.usesLocals(methodInvocation)) continue;
                        methodInvocations.remove(methodInvocation);
                    }
                    catch (CoreException e) {
                        return null;
                    }
                }
                continue;
            }
            methodInvocations.clear();
        }
        for (MethodDeclaration methodDeclaration : callMap.keySet()) {
            methodInvocations = (List)callMap.get(methodDeclaration);
            LinkedHashMap<Block, MethodInvocation> blockMap = new LinkedHashMap<Block, MethodInvocation>();
            if (methodInvocations.size() <= 1) continue;
            int i = 0;
            while (i < methodInvocations.size()) {
                Block block = ASTNodes.getFirstAncestorOrNull((ASTNode)methodInvocations.get(i), Block.class);
                if (block == null) {
                    return null;
                }
                if (blockMap.containsKey(block)) {
                    needsParentheses.add((MethodInvocation)blockMap.get(block));
                }
                blockMap.put(block, (MethodInvocation)methodInvocations.get(i));
                ++i;
            }
            Block[] blockArray = blockMap.keySet().toArray(new Block[0]);
            int i2 = blockArray.length - 1;
            while (i2 >= 0) {
                node = blockArray[i2];
                block8: while (node instanceof Block) {
                    if (!blockMap.containsKey(node = ASTNodes.getFirstAncestorOrNull((ASTNode)node, Block.class, BodyDeclaration.class, LambdaExpression.class))) continue;
                    int j = 0;
                    while (j < i2) {
                        if (blockArray[j] == node) {
                            needsParentheses.add((MethodInvocation)blockMap.get(node));
                            continue block8;
                        }
                        ++j;
                    }
                }
                --i2;
            }
        }
        CompositeChange change2 = (CompositeChange)this.fRefactoringList.get(0).createChange(progressMonitor);
        CompilationUnitChange compilationUnitChange = new CompilationUnitChange(this.fName, this.fCompilationUnit);
        Change[] changes = change2.getChildren();
        int index = 1;
        MethodDeclaration lastMethodDeclaration = null;
        TextEdit parentEdit = null;
        if (changes.length == 1 && (change = changes[0]) instanceof TextChange) {
            void textChange;
            node = (TextChange)change;
            TextChange cfr_ignored_0 = (TextChange)change;
            parentEdit = textChange.getEdit();
            if (needsParentheses.contains(this.fMethodInvocations.get(0))) {
                MethodInvocation methodInvocation = this.fMethodInvocations.get(0);
                MethodDeclaration methodDeclaration = ASTNodes.getFirstAncestorOrNull((ASTNode)methodInvocation, MethodDeclaration.class);
                parentEdit = this.modifyEdit(index, parentEdit, methodInvocation);
                lastMethodDeclaration = methodDeclaration;
                if (parentEdit == null) {
                    return null;
                }
            }
        } else {
            return null;
        }
        int i = 1;
        while (i < this.fRefactoringList.size()) {
            Change change3;
            ++index;
            change2 = (CompositeChange)this.fRefactoringList.get(i).createChange(progressMonitor);
            changes = change2.getChildren();
            if (changes.length == 1 && (change3 = changes[0]) instanceof TextChange) {
                void textChange2;
                TextChange cfr_ignored_1 = (TextChange)change3;
                TextChange cfr_ignored_2 = (TextChange)change3;
                TextEdit textEdit = textChange2.getEdit();
                if (needsParentheses.contains(this.fMethodInvocations.get(i))) {
                    MethodInvocation methodInvocation = this.fMethodInvocations.get(i);
                    MethodDeclaration methodDeclaration = ASTNodes.getFirstAncestorOrNull((ASTNode)methodInvocation, MethodDeclaration.class);
                    if (methodDeclaration != lastMethodDeclaration) {
                        index = 1;
                    }
                    textEdit = this.modifyEdit(index, textEdit, methodInvocation);
                    lastMethodDeclaration = methodDeclaration;
                    if (textEdit == null) {
                        return null;
                    }
                }
                if (TextEditUtil.overlaps(parentEdit, textEdit)) {
                    if ((parentEdit = this.fixAndMerge(parentEdit, textEdit)) == null) {
                        return null;
                    }
                } else {
                    parentEdit = TextEditUtil.merge(parentEdit, textEdit);
                }
            } else {
                return null;
            }
            ++i;
        }
        compilationUnitChange.setEdit(parentEdit);
        return compilationUnitChange;
    }

    /*
     * WARNING - void declaration
     */
    private TextEdit modifyEdit(int index, TextEdit textEdit, MethodInvocation methodInvocation) {
        CompilationUnit root = (CompilationUnit)methodInvocation.getRoot();
        MethodDeclaration toInline = this.getMethodDeclaration(methodInvocation);
        Collection<String> usedVariableNames = new ScopeAnalyzer(root).getUsedVariableNames(methodInvocation.getStartPosition(), methodInvocation.getLength());
        Set<Object> localNames = new HashSet();
        try {
            localNames = this.getLocalVarNames(toInline);
        }
        catch (AbortSearchException e) {
            return null;
        }
        HashMap<Object, Object> localVarMap = new HashMap<Object, Object>();
        for (String string : localNames) {
            Object newName = string;
            int i = 1;
            while (usedVariableNames.contains(newName)) {
                newName = string + i++;
            }
            Object modifiedName = newName;
            while (usedVariableNames.contains(newName = Character.isDigit(((String)newName).charAt(((String)newName).length() - 1)) ? (String)newName + "_" + index : (String)newName + index)) {
            }
            localVarMap.put(modifiedName, newName);
        }
        TextEdit textEdit2 = textEdit;
        if (textEdit2 instanceof ReplaceEdit) {
            ReplaceEdit replaceEdit = (ReplaceEdit)textEdit2;
            ReplaceEdit cfr_ignored_0 = (ReplaceEdit)textEdit2;
            text = replaceEdit.getText();
            for (String name : localVarMap.keySet()) {
                if (!((String)text).contains(name)) continue;
                text = ((String)text).replaceAll("([\\W]+)" + name + "([\\W]+)", "$1" + (String)localVarMap.get(name) + "$2");
            }
            textEdit = new ReplaceEdit(replaceEdit.getOffset(), replaceEdit.getLength(), (String)text);
        } else {
            TextEdit textEdit3 = textEdit;
            if (textEdit3 instanceof MultiTextEdit) {
                text = (MultiTextEdit)textEdit3;
                MultiTextEdit cfr_ignored_1 = (MultiTextEdit)textEdit3;
                MultiTextEdit newEdit = new MultiTextEdit();
                TextEdit[] childEdits = textEdit.getChildren();
                textEdit = newEdit;
                MultiTextEdit parentEdit = newEdit;
                TextEdit[] textEditArray = childEdits;
                int n = childEdits.length;
                int n2 = 0;
                while (n2 < n) {
                    TextEdit childEdit = textEditArray[n2];
                    TextEdit textEdit4 = childEdit;
                    if (textEdit4 instanceof InsertEdit) {
                        void insertEdit;
                        InsertEdit cfr_ignored_2 = (InsertEdit)textEdit4;
                        InsertEdit cfr_ignored_3 = (InsertEdit)textEdit4;
                        Object text = insertEdit.getText();
                        for (String name : localVarMap.keySet()) {
                            if (!((String)text).contains(name)) continue;
                            text = ((String)text).replaceAll("([\\W]+)" + name + "([\\W]+)", "$1" + (String)localVarMap.get(name) + "$2");
                        }
                        InsertEdit newChildEdit = new InsertEdit(insertEdit.getOffset(), (String)text);
                        parentEdit.addChild((TextEdit)newChildEdit);
                    } else {
                        TextEdit textEdit5 = childEdit;
                        if (textEdit5 instanceof MultiTextEdit) {
                            MultiTextEdit cfr_ignored_4 = (MultiTextEdit)textEdit5;
                            MultiTextEdit cfr_ignored_5 = (MultiTextEdit)textEdit5;
                            TextEdit newChildEdit = this.modifyEdit(index, childEdit, methodInvocation);
                            parentEdit.addChild(newChildEdit);
                        } else {
                            parentEdit.addChild(childEdit.copy());
                        }
                    }
                    ++n2;
                }
            }
        }
        return textEdit;
    }

    /*
     * WARNING - void declaration
     */
    private TextEdit fixAndMerge(TextEdit textEdit1, TextEdit textEdit2) {
        MultiTextEdit newEdit1;
        MultiTextEdit edit1 = (MultiTextEdit)textEdit1;
        MultiTextEdit edit2 = (MultiTextEdit)textEdit2;
        MultiTextEdit parentEdit1 = newEdit1 = new MultiTextEdit();
        MultiTextEdit parentEdit2 = edit2;
        TextEdit[] children1 = edit1.getChildren();
        TextEdit[] children2 = edit2.copy().getChildren();
        int removeCount = 0;
        int i = 0;
        while (i < children1.length) {
            TextEdit childEdit1 = children1[i];
            boolean foundOverLap = false;
            int j = 0;
            while (j < children2.length) {
                block9: {
                    block11: {
                        TextEdit childEdit2;
                        block12: {
                            block10: {
                                void insertEdit2;
                                void insertEdit1;
                                childEdit2 = children2[j];
                                if (!TextEditUtil.overlaps(childEdit1, childEdit2)) break block9;
                                foundOverLap = true;
                                TextEdit textEdit = childEdit1;
                                if (!(textEdit instanceof InsertEdit)) break block10;
                                InsertEdit cfr_ignored_0 = (InsertEdit)textEdit;
                                InsertEdit cfr_ignored_1 = (InsertEdit)textEdit;
                                TextEdit textEdit3 = childEdit2;
                                if (!(textEdit3 instanceof InsertEdit)) break block10;
                                InsertEdit cfr_ignored_2 = (InsertEdit)textEdit3;
                                InsertEdit cfr_ignored_3 = (InsertEdit)textEdit3;
                                Object text1 = insertEdit1.getText();
                                String text2 = insertEdit2.getText();
                                if (text2.contains("import") && !((String)text1).contains(text2)) {
                                    text1 = (String)text1 + "\n" + text2;
                                }
                                childEdit1 = new InsertEdit(insertEdit1.getOffset(), (String)text1);
                                parentEdit2.removeChild(i - removeCount++);
                                break block11;
                            }
                            if (!(childEdit1 instanceof DeleteEdit) || !(childEdit2 instanceof DeleteEdit)) break block12;
                            parentEdit2.removeChild(i - removeCount++);
                            childEdit1 = childEdit1.copy();
                            break block11;
                        }
                        if (!(childEdit1 instanceof MultiTextEdit) || !(childEdit2 instanceof MultiTextEdit)) break block9;
                        childEdit1 = this.fixAndMerge(childEdit1, parentEdit2.getChildren()[i - removeCount]);
                    }
                    parentEdit1.addChild(childEdit1);
                    break;
                }
                ++j;
            }
            if (!foundOverLap) {
                parentEdit1.addChild(childEdit1.copy());
            }
            ++i;
        }
        if (edit2.hasChildren()) {
            if (TextEditUtil.overlaps((TextEdit)newEdit1, (TextEdit)edit2)) {
                return null;
            }
            return TextEditUtil.merge((TextEdit)newEdit1, (TextEdit)edit2);
        }
        return newEdit1;
    }

    private boolean usesLocals(MethodInvocation methodInvocation) throws CoreException {
        IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
        if (methodBinding == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IMethod method = (IMethod)methodBinding.getJavaElement();
        if (method == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        CompilationUnit sourceCu = (CompilationUnit)methodInvocation.getRoot();
        CompilationUnit cu = QuickAssistProcessorUtil.findCUForMethod(sourceCu, (ICompilationUnit)sourceCu.getJavaElement(), methodBinding);
        if (cu == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        MethodDeclaration targetMethodDeclaration = null;
        try {
            targetMethodDeclaration = ASTNodeSearchUtil.getMethodDeclarationNode(method, cu);
        }
        catch (JavaModelException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (targetMethodDeclaration != null) {
            class FindLocalVarUse
            extends ASTVisitor {
                boolean usesLocals = false;

                FindLocalVarUse() {
                }

                public boolean usesLocals() {
                    return this.usesLocals;
                }

                public boolean visit(SimpleName node) {
                    IBinding binding = node.resolveBinding();
                    IBinding iBinding = binding;
                    if (iBinding instanceof IVariableBinding) {
                        IVariableBinding iVariableBinding = (IVariableBinding)iBinding;
                        IVariableBinding cfr_ignored_0 = (IVariableBinding)iBinding;
                        this.usesLocals = true;
                        throw new AbortSearchException();
                    }
                    return false;
                }
            }
            FindLocalVarUse findLocalVarUse = new FindLocalVarUse();
            try {
                targetMethodDeclaration.accept((ASTVisitor)findLocalVarUse);
            }
            catch (AbortSearchException abortSearchException) {
                // empty catch block
            }
            return findLocalVarUse.usesLocals();
        }
        throw new CoreException(Status.CANCEL_STATUS);
    }

    private MethodDeclaration getMethodDeclaration(MethodInvocation methodInvocation) {
        IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
        if (methodBinding == null) {
            return null;
        }
        IMethod method = (IMethod)methodBinding.getJavaElement();
        if (method == null) {
            return null;
        }
        CompilationUnit sourceCu = (CompilationUnit)methodInvocation.getRoot();
        CompilationUnit cu = QuickAssistProcessorUtil.findCUForMethod(sourceCu, (ICompilationUnit)sourceCu.getJavaElement(), methodBinding);
        if (cu == null) {
            return null;
        }
        try {
            MethodDeclaration methodDeclaration = ASTNodeSearchUtil.getMethodDeclarationNode(method, cu);
            return methodDeclaration;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    private Set<String> getLocalVarNames(MethodDeclaration methodDeclaration) throws AbortSearchException {
        final HashSet<String> localVarNames = new HashSet<String>();
        ASTVisitor getLocalNames = new ASTVisitor(){

            /*
             * WARNING - void declaration
             */
            public boolean visit(SimpleName node) {
                IBinding binding = node.resolveBinding();
                if (binding == null) {
                    throw new AbortSearchException();
                }
                IBinding iBinding = binding;
                if (iBinding instanceof IVariableBinding) {
                    void varBinding;
                    IVariableBinding iVariableBinding = (IVariableBinding)iBinding;
                    IVariableBinding cfr_ignored_0 = (IVariableBinding)iBinding;
                    if (!(varBinding.isField() || varBinding.isParameter() || varBinding.isRecordComponent() || varBinding.isEnumConstant())) {
                        localVarNames.add(node.getFullyQualifiedName());
                    }
                }
                return true;
            }
        };
        methodDeclaration.accept(getLocalNames);
        return localVarNames;
    }

    @Override
    public String getDisplayString() {
        return this.fName;
    }

    @Override
    public String getAdditionalProposalInfo() {
        return null;
    }

    @Override
    public IStatus getStatus() {
        return null;
    }
}

