/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.refactoring.rename;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameCompilationUnitProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameEnumConstProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameFieldProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameLocalVariableProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameNonVirtualMethodProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenamePackageProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameTypeParameterProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameTypeProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameVirtualMethodProcessor;
import org.eclipse.jdt.internal.corext.refactoring.tagging.INameUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;

public class RenameSupport {
    private RenameRefactoring fRefactoring;
    private RefactoringStatus fPreCheckStatus;
    public static final int NONE = 0;
    public static final int UPDATE_REFERENCES = 1;
    @Deprecated
    public static final int UPDATE_JAVADOC_COMMENTS = 2;
    @Deprecated
    public static final int UPDATE_REGULAR_COMMENTS = 4;
    @Deprecated
    public static final int UPDATE_STRING_LITERALS = 8;
    public static final int UPDATE_TEXTUAL_MATCHES = 64;
    public static final int UPDATE_GETTER_METHOD = 16;
    public static final int UPDATE_SETTER_METHOD = 32;

    public IStatus preCheck() throws CoreException {
        if (this.fPreCheckStatus.hasFatalError()) {
            return this.fPreCheckStatus.getEntryMatchingSeverity(4).toStatus();
        }
        return Status.OK_STATUS;
    }

    private RenameSupport(RenameJavaElementDescriptor descriptor) throws CoreException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        this.fRefactoring = (RenameRefactoring)descriptor.createRefactoring(refactoringStatus);
        if (refactoringStatus.hasFatalError()) {
            this.fPreCheckStatus = refactoringStatus;
        } else {
            this.preCheck();
            refactoringStatus.merge(this.fPreCheckStatus);
            this.fPreCheckStatus = refactoringStatus;
        }
    }

    public static RenameSupport create(RenameJavaElementDescriptor descriptor) throws CoreException {
        return new RenameSupport(descriptor);
    }

    public static RenameSupport create(IJavaElement element, String newName, int flags) throws CoreException {
        switch (element.getElementType()) {
            case 2: {
                return null;
            }
            case 3: {
                return null;
            }
            case 4: {
                return RenameSupport.create((IPackageFragment)element, newName, flags);
            }
            case 5: {
                return RenameSupport.create((ICompilationUnit)element, newName, flags);
            }
            case 7: {
                return RenameSupport.create((IType)element, newName, flags);
            }
            case 9: {
                IMethod method = (IMethod)element;
                if (method.isConstructor()) {
                    return RenameSupport.create(method.getDeclaringType(), newName, flags);
                }
                return RenameSupport.create((IMethod)element, newName, flags);
            }
            case 8: {
                return RenameSupport.create((IField)element, newName, flags);
            }
            case 15: {
                return RenameSupport.create((ITypeParameter)element, newName, flags);
            }
            case 14: {
                return RenameSupport.create((ILocalVariable)element, newName, flags);
            }
        }
        return null;
    }

    private RenameSupport(JavaRenameProcessor processor, String newName, int flags) {
        this.fRefactoring = new RenameRefactoring((RenameProcessor)processor);
        RenameSupport.initialize(processor, newName, flags);
    }

    public JavaRenameProcessor getJavaRenameProcessor() {
        return (JavaRenameProcessor)this.fRefactoring.getProcessor();
    }

    public RenameRefactoring getRenameRefactoring() {
        return this.fRefactoring;
    }

    public static RenameSupport create(IPackageFragment fragment, String newName, int flags) throws CoreException {
        RenamePackageProcessor processor = new RenamePackageProcessor(fragment);
        return new RenameSupport((JavaRenameProcessor)processor, newName, flags);
    }

    public static RenameSupport create(ICompilationUnit unit, String newName, int flags) throws CoreException {
        RenameCompilationUnitProcessor processor = new RenameCompilationUnitProcessor(unit);
        return new RenameSupport((JavaRenameProcessor)processor, newName, flags);
    }

    public static RenameSupport create(IType type, String newName, int flags) throws CoreException {
        RenameTypeProcessor processor = new RenameTypeProcessor(type){

            protected void createChangeForRenamedCUStandardResource(IType type, TextChangeManager changeManager, IResource resource, DynamicValidationRefactoringChange result) throws CoreException {
                this.addTypeDeclarationUpdate(changeManager);
                this.addConstructorRenames(changeManager);
                result.addAll((Change[])changeManager.getAllChanges());
                String renamedCUName = JavaModelUtil.getRenamedCUName((ICompilationUnit)type.getCompilationUnit(), (String)this.getNewElementName());
                result.add((Change)new RenameCompilationUnitChange(type.getCompilationUnit(), renamedCUName));
            }
        };
        return new RenameSupport((JavaRenameProcessor)processor, newName, flags);
    }

    public static RenameSupport create(IMethod method, String newName, int flags) throws CoreException {
        Object processor = MethodChecks.isVirtual((IMethod)method) ? new RenameVirtualMethodProcessor(method){

            protected void initializeWithTopMostImplementation(IMethod topmost) {
                String newName = this.getNewElementName();
                this.initialize(topmost);
                this.setNewElementName(newName);
            }
        } : new RenameNonVirtualMethodProcessor(method);
        return new RenameSupport((JavaRenameProcessor)processor, newName, flags);
    }

    public static RenameSupport create(IField field, String newName, int flags) throws CoreException {
        if (JdtFlags.isEnum((IMember)field)) {
            return new RenameSupport((JavaRenameProcessor)new RenameEnumConstProcessor(field), newName, flags);
        }
        RenameFieldProcessor processor = new RenameFieldProcessor(field);
        processor.setRenameGetter(RenameSupport.updateGetterMethod(flags));
        processor.setRenameSetter(RenameSupport.updateSetterMethod(flags));
        return new RenameSupport((JavaRenameProcessor)processor, newName, flags);
    }

    public static RenameSupport create(ITypeParameter parameter, String newName, int flags) throws CoreException {
        RenameTypeParameterProcessor processor = new RenameTypeParameterProcessor(parameter);
        processor.setUpdateReferences(RenameSupport.updateReferences(flags));
        return new RenameSupport((JavaRenameProcessor)processor, newName, flags);
    }

    public static RenameSupport create(ILocalVariable variable, String newName, int flags) throws CoreException {
        RenameLocalVariableProcessor processor = new RenameLocalVariableProcessor(variable);
        processor.setUpdateReferences(RenameSupport.updateReferences(flags));
        return new RenameSupport((JavaRenameProcessor)processor, newName, flags);
    }

    private static void initialize(JavaRenameProcessor processor, String newName, int flags) {
        RenameSupport.setNewName((INameUpdating)processor, newName);
        if (processor instanceof IReferenceUpdating) {
            IReferenceUpdating reference = (IReferenceUpdating)processor;
            reference.setUpdateReferences(RenameSupport.updateReferences(flags));
        }
        if (processor instanceof ITextUpdating) {
            ITextUpdating text = (ITextUpdating)processor;
            text.setUpdateTextualMatches(RenameSupport.updateTextualMatches(flags));
        }
    }

    private static void setNewName(INameUpdating refactoring, String newName) {
        if (newName != null) {
            refactoring.setNewElementName(newName);
        }
    }

    private static boolean updateReferences(int flags) {
        return (flags & 1) != 0;
    }

    private static boolean updateTextualMatches(int flags) {
        int TEXT_UPDATES = 76;
        return (flags & TEXT_UPDATES) != 0;
    }

    private static boolean updateGetterMethod(int flags) {
        return (flags & 0x10) != 0;
    }

    private static boolean updateSetterMethod(int flags) {
        return (flags & 0x20) != 0;
    }
}

