/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.BufferValidationState;
import org.eclipse.ltk.internal.core.refactoring.Changes;
import org.eclipse.ltk.internal.core.refactoring.ContentStamps;
import org.eclipse.ltk.internal.core.refactoring.Lock;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.UndoEdit;

public class UndoTextFileChange
extends Change {
    private String fName;
    private UndoEdit fUndo;
    private IFile fFile;
    private ContentStamp fContentStampToRestore;
    private int fSaveMode;
    private boolean fDirty;
    private BufferValidationState fValidationState;

    protected UndoTextFileChange(String name, IFile file, UndoEdit undo, ContentStamp stamp, int saveMode) {
        Assert.isNotNull((Object)name);
        Assert.isNotNull((Object)file);
        Assert.isNotNull((Object)undo);
        this.fName = name;
        this.fFile = file;
        this.fUndo = undo;
        this.fContentStampToRestore = stamp;
        this.fSaveMode = saveMode;
    }

    public int getSaveMode() {
        return this.fSaveMode;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    protected Change createUndoChange(UndoEdit edit, ContentStamp stampToRestore) throws CoreException {
        return new UndoTextFileChange(this.getName(), this.fFile, edit, stampToRestore, this.fSaveMode);
    }

    @Override
    public Object getModifiedElement() {
        return this.fFile;
    }

    @Override
    public Object[] getAffectedObjects() {
        Object modifiedElement = this.getModifiedElement();
        if (modifiedElement == null) {
            return null;
        }
        return new Object[]{modifiedElement};
    }

    @Override
    public void initializeValidationData(IProgressMonitor pm) {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        pm.beginTask("", 1);
        try {
            this.fValidationState = BufferValidationState.create(this.fFile);
        }
        finally {
            pm.done();
        }
    }

    @Override
    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        pm.beginTask("", 1);
        try {
            if (this.fValidationState == null) {
                throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), "UndoTextFileChange has not been initialialized"));
            }
            ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(this.fFile.getFullPath(), LocationKind.IFILE);
            this.fDirty = buffer != null && buffer.isDirty();
            RefactoringStatus refactoringStatus = this.fValidationState.isValid(this.needsSaving(), true);
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    @Override
    public Change perform(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        pm.beginTask("", 2);
        ITextFileBuffer buffer = null;
        try {
            manager.connect(this.fFile.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            buffer = manager.getTextFileBuffer(this.fFile.getFullPath(), LocationKind.IFILE);
            IDocument document = buffer.getDocument();
            ContentStamp currentStamp = ContentStamps.get(this.fFile, document);
            boolean[] setContentStampSuccess = new boolean[1];
            UndoEdit redo = this.performEdits(buffer, document, setContentStampSuccess);
            if (this.needsSaving()) {
                buffer.commit(pm, false);
                if (!setContentStampSuccess[0]) {
                    ContentStamps.set(this.fFile, this.fContentStampToRestore);
                }
            }
            Change change = this.createUndoChange(redo, currentStamp);
            return change;
        }
        catch (BadLocationException e) {
            if (this.fValidationState == null || !this.fValidationState.wasDerived()) {
                throw Changes.asCoreException(e);
            }
            NullChange nullChange = new NullChange();
            return nullChange;
        }
        catch (MalformedTreeException e) {
            if (this.fValidationState == null || !this.fValidationState.wasDerived()) {
                throw Changes.asCoreException(e);
            }
            NullChange nullChange = new NullChange();
            return nullChange;
        }
        catch (CoreException e) {
            if (this.fValidationState == null || !this.fValidationState.wasDerived()) {
                throw e;
            }
            NullChange nullChange = new NullChange();
            return nullChange;
        }
        finally {
            if (buffer != null) {
                manager.disconnect(this.fFile.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UndoEdit performEdits(ITextFileBuffer buffer, IDocument document, boolean[] setContentStampSuccess) throws MalformedTreeException, BadLocationException, CoreException {
        if (!buffer.isSynchronizationContextRequested()) {
            return this.doPerformEdits(document, setContentStampSuccess);
        }
        ITextFileBufferManager fileBufferManager = FileBuffers.getTextFileBufferManager();
        Lock completionLock = new Lock();
        UndoEdit[] result = new UndoEdit[1];
        BadLocationException[] badLocationException = new BadLocationException[1];
        MalformedTreeException[] malformedTreeException = new MalformedTreeException[1];
        CoreException[] coreException = new CoreException[1];
        Runnable runnable = () -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 7[CATCHBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        };
        Lock lock = completionLock;
        synchronized (lock) {
            fileBufferManager.execute(runnable);
            while (!completionLock.fDone) {
                try {
                    completionLock.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (badLocationException[0] != null) {
            throw badLocationException[0];
        }
        if (malformedTreeException[0] != null) {
            throw malformedTreeException[0];
        }
        if (coreException[0] != null) {
            throw coreException[0];
        }
        return result[0];
    }

    private UndoEdit doPerformEdits(IDocument document, boolean[] setContentStampSuccess) throws MalformedTreeException, BadLocationException, CoreException {
        LinkedModeModel.closeAllModels((IDocument)document);
        UndoEdit redo = this.fUndo.apply(document, 1);
        setContentStampSuccess[0] = ContentStamps.set(document, this.fContentStampToRestore);
        return redo;
    }

    @Override
    public void dispose() {
        if (this.fValidationState != null) {
            this.fValidationState.dispose();
        }
    }

    private boolean needsSaving() {
        return (this.fSaveMode & 2) != 0 || !this.fDirty && (this.fSaveMode & 1) != 0;
    }
}

