/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IModuleBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.search.LocatorResponse;
import org.eclipse.jdt.internal.core.search.matching.DOMPatternLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.NodeSetWrapper;
import org.eclipse.jdt.internal.core.search.matching.QualifiedTypeDeclarationPattern;
import org.eclipse.jdt.internal.core.search.matching.TypeDeclarationLocator;
import org.eclipse.jdt.internal.core.search.matching.TypeDeclarationPattern;

public class DOMTypeDeclarationLocator
extends DOMPatternLocator {
    private TypeDeclarationLocator locator;

    public DOMTypeDeclarationLocator(TypeDeclarationLocator locator) {
        super((SearchPattern)locator.pattern);
        this.locator = locator;
    }

    @Override
    public LocatorResponse match(AbstractTypeDeclaration node, NodeSetWrapper nodeSet, MatchLocator locator) {
        if (!DOMTypeDeclarationLocator.matchSearchForTypeSuffix(node, this.locator.pattern.typeSuffix)) {
            return this.toResponse(0);
        }
        if (this.locator.pattern.simpleName == null || this.locator.matchesName(this.locator.pattern.simpleName, node.getName().getIdentifier().toCharArray())) {
            int level = nodeSet.addMatch((ASTNode)node, this.locator.pattern.mustResolve ? 2 : 3);
            return this.toResponse(level, true);
        }
        return this.toResponse(0);
    }

    static boolean matchSearchForTypeSuffix(AbstractTypeDeclaration type, char typeSuffix) {
        return switch (typeSuffix) {
            case 'C' -> {
                TypeDeclaration decl;
                if (type instanceof TypeDeclaration && !(decl = (TypeDeclaration)type).isInterface()) {
                    yield true;
                }
                yield false;
            }
            case '\n' -> type instanceof TypeDeclaration;
            case '\t' -> {
                TypeDeclaration decl;
                if (type instanceof TypeDeclaration && !(decl = (TypeDeclaration)type).isInterface() || type instanceof EnumDeclaration) {
                    yield true;
                }
                yield false;
            }
            case 'I' -> {
                TypeDeclaration decl;
                if (type instanceof TypeDeclaration && (decl = (TypeDeclaration)type).isInterface()) {
                    yield true;
                }
                yield false;
            }
            case '\u000b' -> {
                TypeDeclaration decl;
                if (type instanceof TypeDeclaration && !(decl = (TypeDeclaration)type).isInterface() || type instanceof AnnotationTypeDeclaration) {
                    yield true;
                }
                yield false;
            }
            case 'E' -> type instanceof EnumDeclaration;
            case 'A' -> type instanceof AnnotationTypeDeclaration;
            case '\u0000' -> true;
            default -> false;
        };
    }

    static boolean matchSearchForTypeSuffix(ITypeBinding type, char typeSuffix) {
        return switch (typeSuffix) {
            case 'C' -> type.isClass();
            case '\n' -> {
                if (type.isClass() || type.isInterface() && !type.isAnnotation()) {
                    yield true;
                }
                yield false;
            }
            case '\t' -> {
                if (type.isClass() || type.isEnum()) {
                    yield true;
                }
                yield false;
            }
            case 'I' -> {
                if (type.isInterface() && !type.isAnnotation()) {
                    yield true;
                }
                yield false;
            }
            case '\u000b' -> {
                if (type.isInterface() || type.isAnnotation()) {
                    yield true;
                }
                yield false;
            }
            case 'E' -> type.isEnum();
            case 'A' -> type.isAnnotation();
            case '\u0000' -> true;
            default -> false;
        };
    }

    @Override
    public LocatorResponse resolveLevel(ASTNode node, IBinding binding, MatchLocator locator) {
        if (binding == null) {
            return this.toResponse(1);
        }
        if (!(binding instanceof ITypeBinding)) {
            return this.toResponse(0);
        }
        ITypeBinding type = (ITypeBinding)binding;
        if (!DOMTypeDeclarationLocator.matchSearchForTypeSuffix(type, this.locator.pattern.typeSuffix)) {
            return this.toResponse(0);
        }
        if (this.matchModule(this.locator.pattern, type) == 0) {
            return this.toResponse(0);
        }
        if (this.locator.pattern instanceof QualifiedTypeDeclarationPattern) {
            QualifiedTypeDeclarationPattern qualifiedPattern = (QualifiedTypeDeclarationPattern)this.locator.pattern;
            int level = this.resolveLevelForType(qualifiedPattern.simpleName, qualifiedPattern.qualification, type);
            return this.toResponse(level);
        }
        char[] enclosingTypeName = this.locator.pattern.enclosingTypeNames == null ? null : CharOperation.concatWith((char[][])this.locator.pattern.enclosingTypeNames, (char)'.');
        int level = this.resolveLevelForType(this.locator.pattern.simpleName, this.locator.pattern.pkg, enclosingTypeName, type);
        return this.toResponse(level);
    }

    protected int resolveLevelForType(char[] simpleNamePattern, char[] qualificationPattern, char[] enclosingNamePattern, ITypeBinding type) {
        if (enclosingNamePattern == null) {
            return this.resolveLevelForType(simpleNamePattern, qualificationPattern, type);
        }
        if (qualificationPattern == null) {
            return this.resolveLevelForType(simpleNamePattern, enclosingNamePattern, type);
        }
        char[] fullQualificationPattern = CharOperation.concat((char[])qualificationPattern, (char[])enclosingNamePattern, (char)'.');
        if (CharOperation.equals((char[])this.locator.pattern.pkg, (char[])type.getPackage().getName().toCharArray())) {
            return this.resolveLevelForType(simpleNamePattern, fullQualificationPattern, type);
        }
        return 0;
    }

    private int matchModule(TypeDeclarationPattern typePattern, ITypeBinding type) {
        IModuleBinding module = type.getModule();
        if (module == null || module.getName() == null || typePattern.moduleNames == null) {
            return 2;
        }
        String bindModName = module.getName();
        if (typePattern.modulePatterns == null) {
            char[][] moduleList;
            for (char[] m : moduleList = this.locator.getModuleList(typePattern)) {
                int ret = this.locator.matchNameValue(m, bindModName.toCharArray());
                if (ret == 0) continue;
                return ret;
            }
        } else {
            for (Pattern p : typePattern.modulePatterns) {
                Matcher matcher = p.matcher(bindModName);
                if (!matcher.matches()) continue;
                return 3;
            }
        }
        return 0;
    }
}

