/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class WorkManager
implements IManager {
    private final ThreadLocal<Boolean> checkInFailed = new ThreadLocal();
    private volatile boolean hasBuildChanges;
    private IJobManager jobManager;
    private final ILock lock;
    private int nestedOperations = 0;
    private NotifyRule notifyRule = new NotifyRule();
    private boolean operationCanceled = false;
    private int preparedOperations = 0;
    private Workspace workspace;

    WorkManager(Workspace workspace) {
        this.workspace = workspace;
        this.jobManager = Job.getJobManager();
        this.lock = this.jobManager.newLock();
    }

    public int beginUnprotected() {
        int depth = this.lock.getDepth();
        int i = 0;
        while (i < depth) {
            this.lock.release();
            ++i;
        }
        return depth;
    }

    void checkIn(ISchedulingRule rule, IProgressMonitor monitor) throws CoreException {
        boolean success = false;
        try {
            if (this.workspace.isTreeLocked()) {
                String msg = Messages.resources_cannotModify;
                throw new ResourceException(380, null, msg, null);
            }
            this.jobManager.beginRule(rule, monitor);
            this.lock.acquire();
            this.incrementPreparedOperations();
            success = true;
        }
        finally {
            if (!success) {
                this.checkInFailed.set(Boolean.TRUE);
            } else {
                this.checkInFailed.remove();
            }
        }
    }

    boolean checkInFailed(ISchedulingRule rule) {
        if (this.checkInFailed.get() != null) {
            this.checkInFailed.remove();
            if (!this.workspace.isTreeLocked()) {
                this.jobManager.endRule(rule);
            }
            return true;
        }
        return false;
    }

    synchronized void checkOut(ISchedulingRule rule) {
        this.decrementPreparedOperations();
        this.rebalanceNestedOperations();
        if (this.preparedOperations == 0) {
            this.hasBuildChanges = false;
        }
        this.operationCanceled = false;
        try {
            this.lock.release();
        }
        finally {
            this.jobManager.endRule(rule);
        }
    }

    private void decrementPreparedOperations() {
        --this.preparedOperations;
    }

    public void endUnprotected(int depth) {
        int i = 0;
        while (i < depth) {
            this.lock.acquire();
            ++i;
        }
    }

    ILock getLock() {
        return this.lock;
    }

    ISchedulingRule getNotifyRule() {
        return this.notifyRule;
    }

    synchronized int getPreparedOperationDepth() {
        return this.preparedOperations;
    }

    void incrementNestedOperations() {
        ++this.nestedOperations;
    }

    private void incrementPreparedOperations() {
        ++this.preparedOperations;
    }

    boolean isBalanced() {
        return this.nestedOperations == this.preparedOperations;
    }

    public boolean isLockAlreadyAcquired() {
        boolean result = false;
        try {
            boolean success = this.lock.acquire(0L);
            if (success) {
                result = this.lock.getDepth() > 1;
                this.lock.release();
            }
        }
        catch (InterruptedException interruptedException) {}
        return result;
    }

    void operationCanceled() {
        this.operationCanceled = true;
    }

    void rebalanceNestedOperations() {
        this.nestedOperations = this.preparedOperations;
    }

    synchronized void setBuild(boolean hasChanges) {
        if (hasChanges && Policy.DEBUG_BUILD_NEEDED) {
            Policy.debug("Set build hasChanges: " + hasChanges + " hasBuildChanges: " + this.hasBuildChanges);
            if (!this.hasBuildChanges && Policy.DEBUG_BUILD_NEEDED_STACK) {
                Policy.debug(new RuntimeException("Set build hasChanges!"));
            }
        }
        this.hasBuildChanges = this.hasBuildChanges || hasChanges;
    }

    boolean shouldBuild() {
        if (this.hasBuildChanges) {
            return !this.operationCanceled;
        }
        return false;
    }

    @Override
    public void shutdown(IProgressMonitor monitor) {
    }

    @Override
    public void startup(IProgressMonitor monitor) {
        this.jobManager.beginRule(this.workspace.getRoot(), monitor);
        this.lock.acquire();
    }

    void postWorkspaceStartup() {
        try {
            this.lock.release();
        }
        finally {
            this.jobManager.endRule(this.workspace.getRoot());
        }
    }

    static class NotifyRule
    implements ISchedulingRule {
        NotifyRule() {
        }

        @Override
        public boolean contains(ISchedulingRule rule) {
            return rule instanceof IResource || rule.getClass().equals(NotifyRule.class);
        }

        @Override
        public boolean isConflicting(ISchedulingRule rule) {
            return this.contains(rule);
        }
    }
}

