/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.List;
import java.util.function.BiPredicate;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FakedTrackingVariable;
import org.eclipse.jdt.internal.compiler.ast.RecordComponent;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.AnnotationContext;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;

public class MethodDeclaration
extends AbstractMethodDeclaration {
    public TypeReference returnType;
    public TypeParameter[] typeParameters;

    public MethodDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
        this.bits |= 0x100;
    }

    public void analyseCode(ClassScope classScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            int n;
            if (this.binding == null) {
                return;
            }
            if (!this.binding.isUsed() && !this.binding.isAbstract() && (this.binding.isPrivate() || (this.binding.modifiers & 0x30000000) == 0 && this.binding.isOrEnclosedByPrivateType()) && !classScope.referenceCompilationUnit().compilationResult.hasSyntaxError) {
                this.scope.problemReporter().unusedPrivateMethod(this);
            }
            if (this.binding.declaringClass.isEnum() && (this.selector == TypeConstants.VALUES || this.selector == TypeConstants.VALUEOF)) {
                return;
            }
            if (this.binding.isAbstract() || this.binding.isNative()) {
                return;
            }
            if (this.typeParameters != null && !this.scope.referenceCompilationUnit().compilationResult.hasSyntaxError) {
                TypeParameter[] typeParameterArray = this.typeParameters;
                int n2 = this.typeParameters.length;
                int n3 = 0;
                while (n3 < n2) {
                    TypeParameter typeParameter = typeParameterArray[n3];
                    if ((typeParameter.binding.modifiers & 0x8000000) == 0) {
                        this.scope.problemReporter().unusedTypeParameter(typeParameter);
                    }
                    ++n3;
                }
            }
            ExceptionHandlingFlowContext methodContext = new ExceptionHandlingFlowContext(flowContext, this, this.binding.thrownExceptions, null, this.scope, FlowInfo.DEAD_END);
            MethodDeclaration.analyseArguments(classScope.environment(), flowInfo, flowContext, this.arguments, this.binding, this.scope);
            BiPredicate<TypeBinding, ReferenceBinding> condition = (argType, declClass) -> {
                ReferenceBinding enclosingType = argType.enclosingType();
                return enclosingType != null && TypeBinding.equalsEquals(declClass, enclosingType.actualType());
            };
            boolean referencesGenericType = false;
            ReferenceBinding declaringClass = this.binding.declaringClass;
            if (declaringClass.isGenericType()) {
                if (condition.test(this.binding.returnType, declaringClass)) {
                    referencesGenericType = true;
                }
                if (!referencesGenericType && this.binding.parameters != null && this.arguments != null) {
                    int length = Math.min(this.binding.parameters.length, this.arguments.length);
                    int i = 0;
                    while (i < length) {
                        if (condition.test(this.binding.parameters[i], this.binding.declaringClass)) {
                            referencesGenericType = true;
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (this.binding.declaringClass instanceof MemberTypeBinding && !this.binding.declaringClass.isStatic() || referencesGenericType) {
                this.bits &= 0xFFFFFEFF;
            }
            CompilerOptions compilerOptions = this.scope.compilerOptions();
            if (compilerOptions.isAnnotationBasedResourceAnalysisEnabled && this.binding.isClosingMethod()) {
                ReferenceBinding currentClass = this.binding.declaringClass;
                while (currentClass != null) {
                    FieldBinding[] fieldBindingArray = currentClass.fields();
                    n = fieldBindingArray.length;
                    int n4 = 0;
                    while (n4 < n) {
                        FieldBinding fieldBinding = fieldBindingArray[n4];
                        if (!fieldBinding.isStatic() && fieldBinding.type.hasTypeBit(3) && (fieldBinding.tagBits & 0x200000000000000L) != 0L) {
                            fieldBinding.closeTracker = new FakedTrackingVariable(fieldBinding, (BlockScope)this.scope, (ASTNode)this, flowInfo, flowContext, 2, true);
                        }
                        ++n4;
                    }
                    currentClass = currentClass.superclass();
                }
            }
            if (this.statements != null) {
                boolean enableSyntacticNullAnalysisForFields = compilerOptions.enableSyntacticNullAnalysisForFields;
                int complaintLevel = (flowInfo.reachMode() & 3) == 0 ? 0 : 1;
                Statement[] statementArray = this.statements;
                int n5 = this.statements.length;
                n = 0;
                while (n < n5) {
                    Statement stat = statementArray[n];
                    if ((complaintLevel = stat.complainIfUnreachable(flowInfo, this.scope, complaintLevel, true)) < 2) {
                        flowInfo = stat.analyseCode(this.scope, methodContext, flowInfo);
                    }
                    if (enableSyntacticNullAnalysisForFields) {
                        methodContext.expireNullCheckedFieldInfo();
                    }
                    if (compilerOptions.analyseResourceLeaks) {
                        FakedTrackingVariable.cleanUpUnassigned(this.scope, stat, flowInfo, false);
                    }
                    ++n;
                }
            } else {
                this.bits &= 0xFFFFFEFF;
            }
            TypeBinding returnTypeBinding = this.binding.returnType;
            if (returnTypeBinding == TypeBinding.VOID || this.isAbstract()) {
                if ((flowInfo.tagBits & 1) == 0) {
                    this.bits |= 0x40;
                }
            } else if (flowInfo != FlowInfo.DEAD_END) {
                this.scope.problemReporter().shouldReturn(returnTypeBinding, this);
            }
            methodContext.complainIfUnusedExceptionHandlers(this);
            this.scope.checkUnusedParameters(this.binding);
            if (!(this.binding.isStatic() || (this.bits & 0x100) == 0 || this.isDefaultMethod() || this.binding.isOverriding() || this.binding.isImplementing())) {
                if (this.binding.isPrivate() || this.binding.isFinal() || this.binding.declaringClass.isFinal()) {
                    this.scope.problemReporter().methodCanBeDeclaredStatic(this);
                } else {
                    this.scope.problemReporter().methodCanBePotentiallyDeclaredStatic(this);
                }
            }
            this.scope.checkUnclosedCloseables(flowInfo, null, null, null);
        }
        catch (AbortMethod e) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    @Override
    public void getAllAnnotationContexts(int targetType, List allAnnotationContexts) {
        TypeReference.AnnotationCollector collector = new TypeReference.AnnotationCollector(this.returnType, targetType, (List<AnnotationContext>)allAnnotationContexts);
        Annotation[] annotationArray = this.annotations;
        int n = this.annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            annotation.traverse((ASTVisitor)collector, (BlockScope)null);
            ++n2;
        }
    }

    public boolean hasNullTypeAnnotation(TypeReference.AnnotationPosition position) {
        return TypeReference.containsNullAnnotation(this.annotations) || this.returnType != null && this.returnType.hasNullTypeAnnotation(position);
    }

    @Override
    public boolean isDefaultMethod() {
        return (this.modifiers & 0x10000) != 0;
    }

    @Override
    public boolean isCandidateMain() {
        if (this.binding == null) {
            return false;
        }
        return this.binding.isCandindateMain();
    }

    @Override
    public boolean isMethod() {
        return true;
    }

    @Override
    public void parseStatements(Parser parser, CompilationUnitDeclaration unit) {
        parser.parse(this, unit);
    }

    @Override
    public StringBuilder printReturnType(int indent, StringBuilder output) {
        if (this.returnType == null) {
            return output;
        }
        return this.returnType.printExpression(0, output).append(' ');
    }

    @Override
    public void resolveStatements() {
        int bindingModifiers;
        RecordComponent recordComponent;
        if (this.returnType != null && this.binding != null) {
            this.bits |= this.returnType.bits & 0x100000;
            this.returnType.resolvedType = this.binding.returnType;
        }
        ReferenceBinding declaringClass = this.binding != null ? this.binding.declaringClass : null;
        RecordComponent recordComponent2 = recordComponent = declaringClass != null && declaringClass.isRecord() && (this.arguments == null || this.arguments.length == 0) ? declaringClass.getRecordComponent(this.selector) : null;
        if (recordComponent != null) {
            if (this.returnType != null && TypeBinding.notEquals(this.returnType.resolvedType, recordComponent.type.resolvedType)) {
                this.scope.problemReporter().componentAccessorReturnTypeMismatch(this.returnType, recordComponent.type.resolvedType);
            }
            if (this.typeParameters != null) {
                this.scope.problemReporter().componentAccessorMethodShouldNotBeGeneric(this);
            }
            if (this.binding != null) {
                if (!this.binding.isPublic()) {
                    this.scope.problemReporter().componentAccessorMethodShouldBePublic(this);
                }
                if (this.binding.isStatic()) {
                    this.scope.problemReporter().componentAccessorMethodShouldNotBeStatic(this);
                }
                if ((this.binding.modifiers & 0x10000000) == 0) {
                    this.scope.problemReporter().componentAccessorMissingOverrideAnnotation(this);
                }
            }
            if (this.thrownExceptions != null) {
                this.scope.problemReporter().componentAccessorMethodHasThrowsClause(this);
            }
        }
        if (CharOperation.equals(this.scope.enclosingSourceType().sourceName, this.selector)) {
            this.scope.problemReporter().methodWithConstructorName(this);
        }
        boolean returnsUndeclTypeVar = false;
        if (this.returnType != null && this.returnType.resolvedType instanceof TypeVariableBinding) {
            returnsUndeclTypeVar = true;
        }
        if (this.typeParameters != null) {
            TypeParameter[] typeParameterArray = this.typeParameters;
            int n = this.typeParameters.length;
            int n2 = 0;
            while (n2 < n) {
                TypeParameter typeParameter = typeParameterArray[n2];
                this.bits |= typeParameter.bits & 0x100000;
                if (returnsUndeclTypeVar && TypeBinding.equalsEquals(typeParameter.binding, this.returnType.resolvedType)) {
                    returnsUndeclTypeVar = false;
                }
                ++n2;
            }
        }
        CompilerOptions compilerOptions = this.scope.compilerOptions();
        if (this.binding != null && recordComponent == null) {
            boolean hasUnresolvedArguments;
            long complianceLevel = compilerOptions.complianceLevel;
            int bindingModifiers2 = this.binding.modifiers;
            boolean hasOverrideAnnotation = (this.binding.tagBits & 0x2000000000000L) != 0L;
            boolean bl = hasUnresolvedArguments = (this.binding.tagBits & 0x200L) != 0L;
            if (hasOverrideAnnotation && !hasUnresolvedArguments) {
                if ((bindingModifiers2 & 0x10000008) != 0x10000000 && (bindingModifiers2 & 0x20000008) != 0x20000000) {
                    this.scope.problemReporter().methodMustOverride(this, complianceLevel);
                }
            } else if (!declaringClass.isInterface()) {
                if ((bindingModifiers2 & 0x10000008) == 0x10000000) {
                    this.scope.problemReporter().missingOverrideAnnotation(this);
                } else if (compilerOptions.reportMissingOverrideAnnotationForInterfaceMethodImplementation && this.binding.isImplementing()) {
                    this.scope.problemReporter().missingOverrideAnnotationForInterfaceMethodImplementation(this);
                }
            } else if (compilerOptions.reportMissingOverrideAnnotationForInterfaceMethodImplementation && ((bindingModifiers2 & 0x10000008) == 0x10000000 || this.binding.isImplementing())) {
                this.scope.problemReporter().missingOverrideAnnotationForInterfaceMethodImplementation(this);
            }
        }
        switch (TypeDeclaration.kind(this.scope.referenceType().modifiers)) {
            case 3: {
                if (this.selector == TypeConstants.VALUES || this.selector == TypeConstants.VALUEOF) break;
            }
            case 1: 
            case 5: {
                if ((this.modifiers & 0x1000000) != 0) {
                    if ((this.modifiers & 0x100) != 0 || (this.modifiers & 0x400) != 0) break;
                    this.scope.problemReporter().methodNeedBody(this);
                    break;
                }
                if ((this.modifiers & 0x100) != 0 || (this.modifiers & 0x400) != 0) {
                    this.scope.problemReporter().methodNeedingNoBody(this);
                    break;
                }
                if (this.binding != null && !this.binding.isStatic() && !(declaringClass instanceof LocalTypeBinding) && !returnsUndeclTypeVar) break;
                this.bits &= 0xFFFFFEFF;
                break;
            }
            case 2: {
                boolean isPrivateMethod;
                if ((this.modifiers & 0x1000400) != 0x1000000) break;
                boolean bl = isPrivateMethod = compilerOptions.sourceLevel >= 0x350000L && (this.modifiers & 2) != 0;
                if (!isPrivateMethod && (this.modifiers & 0x10008) == 0) break;
                this.scope.problemReporter().methodNeedBody(this);
            }
        }
        super.resolveStatements();
        if (compilerOptions.getSeverity(0x20100000) != 256 && this.binding != null && ((bindingModifiers = this.binding.modifiers) & 0x30000000) == 0x10000000 && (this.bits & 0x10) == 0) {
            this.scope.problemReporter().overridesMethodWithoutSuperInvocation(this.binding);
        }
    }

    @Override
    public void traverse(ASTVisitor visitor, ClassScope classScope) {
        if (visitor.visit(this, classScope)) {
            int i;
            if (this.javadoc != null) {
                this.javadoc.traverse(visitor, this.scope);
            }
            if (this.annotations != null) {
                int annotationsLength = this.annotations.length;
                i = 0;
                while (i < annotationsLength) {
                    this.annotations[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
            if (this.typeParameters != null) {
                int typeParametersLength = this.typeParameters.length;
                i = 0;
                while (i < typeParametersLength) {
                    this.typeParameters[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
            if (this.returnType != null) {
                this.returnType.traverse(visitor, this.scope);
            }
            if (this.arguments != null) {
                int argumentLength = this.arguments.length;
                i = 0;
                while (i < argumentLength) {
                    this.arguments[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
            if (this.thrownExceptions != null) {
                int thrownExceptionsLength = this.thrownExceptions.length;
                i = 0;
                while (i < thrownExceptionsLength) {
                    this.thrownExceptions[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
            if (this.statements != null) {
                int statementsLength = this.statements.length;
                i = 0;
                while (i < statementsLength) {
                    this.statements[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, classScope);
    }

    @Override
    public TypeParameter[] typeParameters() {
        return this.typeParameters;
    }
}

