/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.subsystems.files;

import java.io.File;
import java.lang.reflect.Method;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.IService;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.clientserver.messages.SystemElementNotFoundException;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.services.files.RemoteFileException;
import org.eclipse.rse.services.shells.IHostOutput;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IHostShellOutputListener;
import org.eclipse.rse.services.shells.IShellService;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.tests.core.connection.RSEBaseConnectionTestCase;
import org.eclipse.rse.tests.subsystems.shells.ShellOutputListener;

public class FileServiceTest
extends RSEBaseConnectionTestCase {
    private String fPropertiesFileName;
    public static String fDefaultPropertiesFile = "localConnection.properties";
    private IFileServiceSubSystem fss;
    private IFileService fs;
    private IRemoteFile fHomeDirectory;
    private IRemoteFile remoteTempDir;
    private String tempDirPath;
    private IProgressMonitor mon = new NullProgressMonitor();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public FileServiceTest(String name) {
        this(name, fDefaultPropertiesFile);
    }

    public FileServiceTest(String name, String propertiesFileName) {
        super(name);
        this.fPropertiesFileName = propertiesFileName;
        if (propertiesFileName != null) {
            int idx = propertiesFileName.indexOf("Connection.properties");
            String targetName = propertiesFileName.substring(0, idx);
            this.setTargetName(targetName);
        }
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String baseName = clazz.getName();
        TestSuite suite = new TestSuite(baseName);
        String[] connTypes = new String[]{"local", "ssh", "ftpWindows", "ftpSsh", "linux", "windows", "unix"};
        int i = 0;
        while (i < connTypes.length) {
            String suiteName = connTypes[i] == null ? "EFS" : connTypes[i];
            String propFileName = connTypes[i] == null ? null : String.valueOf(connTypes[i]) + "Connection.properties";
            TestSuite subSuite = new TestSuite(String.valueOf(baseName) + "." + suiteName);
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceTest");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Method[] m = clazz2.getMethods();
            int j = 0;
            while (j < m.length) {
                String testName = m[j].getName();
                if (testName.startsWith("test")) {
                    subSuite.addTest((Test)new FileServiceTest(testName, propFileName));
                }
                ++j;
            }
            suite.addTest((Test)subSuite);
            ++i;
        }
        return suite;
    }

    public void setUp() throws Exception {
        super.setUp();
        IHost host = this.getHost(this.fPropertiesFileName);
        this.fss = (IFileServiceSubSystem)RemoteFileUtility.getFileSubSystem((IHost)host);
        this.fs = this.fss.getFileService();
        this.fss.checkIsConnected(this.getDefaultProgressMonitor());
        this.fHomeDirectory = this.fss.getRemoteFileObject(".", this.getDefaultProgressMonitor());
        this.remoteTempDir = this.fss.getRemoteFileObject(this.fHomeDirectory, "rsetest" + System.currentTimeMillis(), this.getDefaultProgressMonitor());
        this.fss.createFolder(this.remoteTempDir, this.getDefaultProgressMonitor());
        this.tempDirPath = this.remoteTempDir.getAbsolutePath();
    }

    public void tearDown() throws Exception {
        this.fss.delete(this.remoteTempDir, this.getDefaultProgressMonitor());
        super.tearDown();
    }

    public boolean isWindows() {
        return this.fss.getHost().getSystemType().isWindows();
    }

    public String getTestFileName() {
        if (!this.isWindows()) {
            String testName = "a !@#${a}\"' fi\tle\b\\%^&*()?_ =[]~+-'`;:,.|<>";
            if (this.fss.getSubSystemConfiguration().getServiceImplType().getName().equals("org.eclipse.rse.services.dstore.IDStoreService")) {
                testName.replace('\\', ' ');
            }
        }
        return "a !@#${a}'` file%^&()_ =[]~+-;.,";
    }

    public IShellService getRelatedShellService() {
        IHost host = this.fss.getHost();
        ISubSystem[] subSystems = host.getSubSystems();
        IShellService ssvc = null;
        int i = 0;
        while (subSystems != null && i < subSystems.length) {
            IService svc = subSystems[i].getSubSystemConfiguration().getService(host);
            if (svc != null) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.rse.services.shells.IShellService");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((ssvc = (IShellService)svc.getAdapter((Class)clazz)) != null) {
                    try {
                        subSystems[i].checkIsConnected(this.getDefaultProgressMonitor());
                        return ssvc;
                    }
                    catch (SystemMessageException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
        return null;
    }

    public void testGetRootProperties() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        IHostFile[] roots = this.fs.getRoots((IProgressMonitor)new NullProgressMonitor());
        FileServiceTest.assertNotNull((Object)roots);
        FileServiceTest.assertTrue((roots.length > 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < roots.length) {
            FileServiceTest.assertTrue((boolean)roots[i].isRoot());
            FileServiceTest.assertTrue((boolean)roots[i].exists());
            FileServiceTest.assertNull((Object)roots[i].getParentPath());
            String rootName = roots[i].getName();
            FileServiceTest.assertNotNull((Object)rootName);
            System.out.println(rootName);
            IHostFile newHf = this.fs.getFile(null, rootName, (IProgressMonitor)new NullProgressMonitor());
            FileServiceTest.assertTrue((boolean)newHf.isRoot());
            FileServiceTest.assertTrue((boolean)newHf.exists());
            FileServiceTest.assertEquals((String)newHf.getName(), (String)rootName);
            newHf = this.fs.getFile("", rootName, (IProgressMonitor)new NullProgressMonitor());
            FileServiceTest.assertTrue((boolean)newHf.isRoot());
            FileServiceTest.assertTrue((boolean)newHf.exists());
            FileServiceTest.assertEquals((String)newHf.getName(), (String)rootName);
            ++i;
        }
    }

    public void testCaseSensitive() {
        if (this.isTestDisabled()) {
            return;
        }
        if (this.isWindows()) {
            FileServiceTest.assertFalse((boolean)this.fs.isCaseSensitive());
            FileServiceTest.assertFalse((boolean)this.fss.isCaseSensitive());
            FileServiceTest.assertFalse((boolean)this.fss.getSubSystemConfiguration().isCaseSensitive());
        } else {
            FileServiceTest.assertTrue((boolean)this.fs.isCaseSensitive());
            FileServiceTest.assertTrue((boolean)this.fss.isCaseSensitive());
            FileServiceTest.assertTrue((boolean)this.fss.getSubSystemConfiguration().isCaseSensitive());
        }
    }

    public void testCreateFile() throws SystemMessageException {
        if (this.isTestDisabled()) {
            return;
        }
        String testName = this.getTestFileName();
        IHostFile hf = this.fs.createFile(this.tempDirPath, testName, this.mon);
        FileServiceTest.assertTrue((boolean)hf.exists());
        FileServiceTest.assertTrue((boolean)hf.canRead());
        FileServiceTest.assertTrue((boolean)hf.canWrite());
        FileServiceTest.assertEquals((String)hf.getName(), (String)testName);
        FileServiceTest.assertEquals((String)hf.getParentPath(), (String)this.tempDirPath);
        FileServiceTest.assertEquals((long)hf.getSize(), (long)0L);
        long modDate = hf.getModifiedDate();
        FileServiceTest.assertTrue((modDate > 0L ? 1 : 0) != 0);
        if (this.fss.getHost().getSystemType().isLocal()) {
            File theFile = new File(this.remoteTempDir.getAbsolutePath(), testName);
            FileServiceTest.assertTrue((boolean)theFile.exists());
            FileServiceTest.assertTrue((modDate == theFile.lastModified() ? 1 : 0) != 0);
        }
    }

    public void testCreateCaseSensitive() throws SystemMessageException {
        if (this.isTestDisabled()) {
            return;
        }
        String testName = this.getTestFileName();
        String testName2 = testName.toUpperCase();
        IHostFile hf = this.fs.createFile(this.tempDirPath, testName, this.mon);
        if (this.fss.isCaseSensitive()) {
            IHostFile hf2 = this.fs.getFile(this.tempDirPath, testName2, this.mon);
            FileServiceTest.assertFalse((boolean)hf2.exists());
            hf2 = this.fs.createFolder(this.tempDirPath, testName2, this.mon);
            FileServiceTest.assertTrue((boolean)hf2.exists());
            FileServiceTest.assertTrue((boolean)hf2.isDirectory());
            FileServiceTest.assertFalse((boolean)hf.equals(hf2));
        } else {
            IHostFile hf2 = this.fs.getFile(this.tempDirPath, testName2, this.mon);
            FileServiceTest.assertTrue((boolean)hf2.exists());
            try {
                hf2 = this.fs.createFolder(this.tempDirPath, testName2, this.mon);
            }
            catch (SystemMessageException e) {
                FileServiceTest.assertNotNull((Object)((Object)e));
            }
            FileServiceTest.assertTrue((boolean)hf2.exists());
            FileServiceTest.assertFalse((boolean)hf2.isDirectory());
            FileServiceTest.assertEquals((long)hf.getModifiedDate(), (long)hf2.getModifiedDate());
            FileServiceTest.assertEquals((long)hf.getSize(), (long)hf2.getSize());
            FileServiceTest.assertEquals((Object)new File(this.tempDirPath, testName), (Object)new File(this.tempDirPath, testName2));
            FileServiceTest.assertEquals((Object)hf, (Object)hf2);
        }
    }

    public String[] runRemoteCommand(IShellService shellService, String workingDirectory, String cmd) throws SystemMessageException, InterruptedException {
        IHostShell hostShell = null;
        hostShell = shellService.runCommand(workingDirectory, cmd, null, this.mon);
        ShellOutputListener outputListener = new ShellOutputListener();
        hostShell.addOutputListener((IHostShellOutputListener)outputListener);
        hostShell.writeToShell("exit");
        FileServiceTest.assertNotNull((Object)hostShell);
        FileServiceTest.assertNotNull((Object)hostShell.getStandardOutputReader());
        while (hostShell.isActive()) {
            Thread.sleep(1000L);
        }
        Object[] allOutput = outputListener.getAllOutput();
        if (allOutput != null) {
            String[] sOutput = new String[allOutput.length];
            int i = 0;
            while (i < allOutput.length) {
                sOutput[i] = allOutput[i] instanceof IHostOutput ? ((IHostOutput)allOutput[i]).getString() : allOutput[i].toString();
                ++i;
            }
            return sOutput;
        }
        return null;
    }

    public boolean mkSymLink(String source, String target) {
        IShellService ss;
        if (!this.fss.getHost().getSystemType().isWindows() && (ss = this.getRelatedShellService()) != null) {
            String[] allOutput;
            String cmd;
            block6: {
                String src = PathUtility.enQuoteUnix((String)source);
                String tgt = PathUtility.enQuoteUnix((String)target);
                cmd = "ln -s " + src + " " + tgt;
                allOutput = this.runRemoteCommand(ss, this.tempDirPath, cmd);
                IHostFile hf = this.fs.getFile(this.tempDirPath, target, this.mon);
                if (!hf.exists()) break block6;
                return true;
            }
            try {
                allOutput = new String[]{"Failed to symlink: " + cmd};
            }
            catch (Exception e) {
                allOutput = new String[]{"Exception thrown: " + e};
            }
            System.out.println("WARNING: Could not create symlink");
            if (allOutput != null) {
                int i = 0;
                while (i < allOutput.length) {
                    System.out.println(allOutput[i]);
                    ++i;
                }
            }
        }
        return false;
    }

    public void testListEmptyFolder() throws SystemMessageException {
        if (this.isTestDisabled()) {
            return;
        }
        String testName = "empty";
        IHostFile hf = this.fs.createFolder(this.tempDirPath, testName, this.mon);
        FileServiceTest.assertTrue((boolean)hf.exists());
        FileServiceTest.assertTrue((boolean)hf.isDirectory());
        FileServiceTest.assertTrue((boolean)hf.canRead());
        FileServiceTest.assertTrue((boolean)hf.canWrite());
        FileServiceTest.assertEquals((String)testName, (String)hf.getName());
        FileServiceTest.assertEquals((String)this.tempDirPath, (String)hf.getParentPath());
        long modDate = hf.getModifiedDate();
        FileServiceTest.assertTrue((modDate > 0L ? 1 : 0) != 0);
        if (this.fss.getHost().getSystemType().isLocal()) {
            File theFile = new File(this.remoteTempDir.getAbsolutePath(), testName);
            FileServiceTest.assertTrue((boolean)theFile.exists());
            FileServiceTest.assertTrue((modDate == theFile.lastModified() ? 1 : 0) != 0);
        }
        IHostFile[] hfa = this.fs.list(hf.getAbsolutePath(), "*", 0, this.mon);
        FileServiceTest.assertEquals((int)0, (int)hfa.length);
        if (this.mkSymLink(testName, "lto" + testName)) {
            IHostFile hf2 = this.fs.getFile(this.tempDirPath, "lto" + testName, this.mon);
            FileServiceTest.assertTrue((boolean)hf2.isDirectory());
            hfa = this.fs.list(hf2.getAbsolutePath(), "*", 0, this.mon);
            FileServiceTest.assertEquals((int)0, (int)hfa.length);
        }
    }

    public void testListNonExistentFolder() throws SystemMessageException, InterruptedException {
        if (this.isTestDisabled()) {
            return;
        }
        String testPath = String.valueOf(this.tempDirPath) + "/non/existent";
        try {
            IHostFile[] hfa = this.fs.list(testPath, "*", 0, this.mon);
            FileServiceTest.assertEquals((String)"Exception expected on list nonexistent", (int)-1, (int)hfa.length);
        }
        catch (SystemMessageException e) {
            FileServiceTest.assertTrue((boolean)(e instanceof SystemElementNotFoundException));
        }
        if (this.mkSymLink("non/existent", "ltononex")) {
            IHostFile hf2 = this.fs.getFile(this.tempDirPath, "ltononex", this.mon);
            try {
                IHostFile[] hfa = this.fs.list(hf2.getAbsolutePath(), "*", 0, this.mon);
                FileServiceTest.assertEquals((String)"Exception expected on list broken symlink", (int)-1, (int)hfa.length);
            }
            catch (SystemMessageException e) {
                FileServiceTest.assertTrue((boolean)(e instanceof SystemElementNotFoundException));
            }
        }
    }

    public void testListNotAFolder() throws SystemMessageException {
        if (this.isTestDisabled()) {
            return;
        }
        String testName = this.getTestFileName();
        IHostFile hf = this.fs.createFile(this.tempDirPath, testName, this.mon);
        FileServiceTest.assertTrue((boolean)hf.exists());
        FileServiceTest.assertTrue((boolean)hf.canRead());
        FileServiceTest.assertTrue((boolean)hf.canWrite());
        FileServiceTest.assertEquals((String)hf.getName(), (String)testName);
        FileServiceTest.assertEquals((String)hf.getParentPath(), (String)this.tempDirPath);
        FileServiceTest.assertEquals((long)hf.getSize(), (long)0L);
        long modDate = hf.getModifiedDate();
        FileServiceTest.assertTrue((modDate > 0L ? 1 : 0) != 0);
        if (this.fss.getHost().getSystemType().isLocal()) {
            File theFile = new File(this.remoteTempDir.getAbsolutePath(), testName);
            FileServiceTest.assertTrue((boolean)theFile.exists());
            FileServiceTest.assertTrue((modDate == theFile.lastModified() ? 1 : 0) != 0);
        }
        try {
            IHostFile[] hfa = this.fs.list(hf.getAbsolutePath(), "*", 0, this.mon);
            FileServiceTest.assertEquals((String)"Exception expected on list not-a-folder", (int)-1, (int)hfa.length);
        }
        catch (SystemMessageException e) {
            FileServiceTest.assertTrue((boolean)(e instanceof RemoteFileException));
        }
        if (this.mkSymLink(testName, "lto" + testName)) {
            try {
                IHostFile hf2 = this.fs.getFile(this.tempDirPath, "lto" + testName, this.mon);
                FileServiceTest.assertTrue((boolean)hf2.isFile());
                IHostFile[] hfa = this.fs.list(hf2.getAbsolutePath(), "*", 0, this.mon);
                FileServiceTest.assertEquals((String)"Exception expected on list symlink-to-folder", (int)-1, (int)hfa.length);
            }
            catch (SystemMessageException e) {
                FileServiceTest.assertTrue((boolean)(e instanceof RemoteFileException));
            }
        }
    }
}

