/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.internal.core.util.ssl;

import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.dstore.core.util.ssl.DStoreKeyStore;
import org.eclipse.dstore.core.util.ssl.IDataStoreTrustManager;

public class DataStoreTrustManager
implements IDataStoreTrustManager {
    private KeyStore _keystore;
    private List _untrustedCerts;
    private List _verifyExceptions;
    private List _trustedCerts = new ArrayList();

    public DataStoreTrustManager() {
        this._untrustedCerts = new ArrayList();
        this._verifyExceptions = new ArrayList();
    }

    public void setKeystore(String filePath, String password) {
        try {
            KeyStore ks;
            this._keystore = ks = DStoreKeyStore.getKeyStore(filePath, password);
            this.loadTrustedCertificates();
        }
        catch (Exception exception) {}
    }

    private void loadTrustedCertificates() {
        this._trustedCerts.clear();
        try {
            Enumeration<String> aliases = this._keystore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate cert = this._keystore.getCertificate(alias);
                this._trustedCerts.add(cert);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List getUntrustedCerts() {
        return this._untrustedCerts;
    }

    public List getVerifyExceptions() {
        return this._verifyExceptions;
    }

    private void checkTrusted(X509Certificate[] certs, String arg1) throws CertificateException {
        this._untrustedCerts.clear();
        this._verifyExceptions.clear();
        int i = 0;
        while (i < certs.length) {
            X509Certificate cert = certs[i];
            boolean foundMatch = false;
            if (this._trustedCerts.size() > 0) {
                int j = 0;
                while (j < this._trustedCerts.size() && !foundMatch) {
                    X509Certificate tcert = (X509Certificate)this._trustedCerts.get(j);
                    try {
                        if (cert.getSubjectDN().equals(tcert.getIssuerDN())) {
                            cert.verify(tcert.getPublicKey());
                            foundMatch = true;
                        }
                    }
                    catch (Exception exception) {}
                    ++j;
                }
            }
            if (!foundMatch) {
                this._untrustedCerts.add(cert);
            }
            ++i;
        }
        if (this._trustedCerts.size() == 0 || this._untrustedCerts.size() > 0) {
            throw new CertificateException();
        }
    }

    public void checkClientTrusted(X509Certificate[] certs, String arg1) throws CertificateException {
        this.checkTrusted(certs, arg1);
    }

    public void checkServerTrusted(X509Certificate[] certs, String arg1) throws CertificateException {
        this.checkTrusted(certs, arg1);
    }

    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }
}

