/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver.search;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.eclipse.rse.services.clientserver.search.SystemSearchLineMatch;
import org.eclipse.rse.services.clientserver.search.SystemSearchStringMatcher;

public class SystemSearchStringMatchLocator {
    private Reader reader;
    private SystemSearchStringMatcher stringMatcher;
    private int fPushbackChar;
    private boolean fPushback;

    public SystemSearchStringMatchLocator(Reader reader, SystemSearchStringMatcher stringMatcher) {
        this.reader = reader;
        this.stringMatcher = stringMatcher;
    }

    public SystemSearchStringMatcher getStringMatcher() {
        return this.stringMatcher;
    }

    public Reader getReader() {
        return this.reader;
    }

    public SystemSearchLineMatch[] locateMatches() throws IOException {
        ArrayList<SystemSearchLineMatch> matches;
        block10: {
            int lineCounter = 1;
            int charCounter = 0;
            boolean eof = false;
            matches = new ArrayList<SystemSearchLineMatch>();
            try {
                try {
                    while (!eof) {
                        StringBuffer sb = new StringBuffer(200);
                        int eolStrLength = this.readLine(this.reader, sb);
                        eof = eolStrLength == -1;
                        int lineLength = sb.length();
                        String line = sb.toString();
                        if (lineLength != 0 && this.stringMatcher.matches(line)) {
                            int beginOffset = charCounter + 0;
                            int endOffset = charCounter + lineLength;
                            SystemSearchLineMatch match = new SystemSearchLineMatch(line.trim(), lineCounter);
                            match.addEntry(beginOffset, endOffset);
                            matches.add(match);
                        }
                        charCounter += lineLength + eolStrLength;
                        ++lineCounter;
                    }
                }
                catch (IOException iOException) {
                    if (this.reader != null) {
                        this.reader.close();
                    }
                    break block10;
                }
            }
            catch (Throwable throwable) {
                if (this.reader != null) {
                    this.reader.close();
                }
                throw throwable;
            }
            if (this.reader != null) {
                this.reader.close();
            }
        }
        SystemSearchLineMatch[] matchArray = new SystemSearchLineMatch[matches.size()];
        matches.toArray(matchArray);
        return matchArray;
    }

    protected int readLine(Reader reader, StringBuffer sb) throws IOException {
        int ch = -1;
        if (this.fPushback) {
            ch = this.fPushbackChar;
            this.fPushback = false;
        } else {
            ch = reader.read();
        }
        while (ch >= 0) {
            if (ch == 10) {
                return 1;
            }
            if (ch == 13) {
                ch = reader.read();
                if (ch == 10) {
                    return 2;
                }
                this.fPushbackChar = ch;
                this.fPushback = true;
                return 1;
            }
            sb.append((char)ch);
            ch = reader.read();
        }
        return -1;
    }
}

