/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core.model;

import org.eclipse.rse.core.model.IPropertyType;

public class PropertyType
implements IPropertyType {
    private int _type = 0;
    private String[] _enumValues;
    private static final String ENUMERATION_STR = "enumeration:";
    private static IPropertyType _booleanPropertyType = new PropertyType(3);
    private static IPropertyType _integerPropertyType = new PropertyType(1);
    private static IPropertyType _stringPropertyType = new PropertyType(0);

    private PropertyType(int type) {
        this._type = type;
    }

    public static IPropertyType getBooleanPropertyType() {
        return _booleanPropertyType;
    }

    public static IPropertyType getIntegerPropertyType() {
        return _integerPropertyType;
    }

    public static IPropertyType getStringPropertyType() {
        return _stringPropertyType;
    }

    public static IPropertyType getEnumPropertyType(String[] values) {
        PropertyType type = new PropertyType(2);
        type._enumValues = values;
        return type;
    }

    public static IPropertyType fromString(String typeStr) {
        if (typeStr.equals(String.class.toString())) {
            return PropertyType.getStringPropertyType();
        }
        if (typeStr.equals(Integer.class.toString())) {
            return PropertyType.getIntegerPropertyType();
        }
        if (typeStr.startsWith(ENUMERATION_STR)) {
            String subString = typeStr.substring(ENUMERATION_STR.length());
            String[] enumValues = subString.split(",");
            return PropertyType.getEnumPropertyType(enumValues);
        }
        if (typeStr.equals(Boolean.class.toString())) {
            return PropertyType.getBooleanPropertyType();
        }
        return PropertyType.getStringPropertyType();
    }

    public int getType() {
        return this._type;
    }

    public boolean isString() {
        return this._type == 0;
    }

    public boolean isInteger() {
        return this._type == 1;
    }

    public boolean isEnum() {
        return this._type == 2;
    }

    public boolean isBoolean() {
        return this._type == 3;
    }

    public String[] getEnumValues() {
        return this._enumValues;
    }

    public String toString() {
        if (this.isString()) {
            return String.class.getName();
        }
        if (this.isInteger()) {
            return Integer.class.getName();
        }
        if (this.isEnum()) {
            StringBuffer buf = new StringBuffer();
            buf.append(ENUMERATION_STR);
            String[] enumValues = this.getEnumValues();
            int i = 0;
            while (i < enumValues.length) {
                buf.append(enumValues[i]);
                if (i + 1 < enumValues.length) {
                    buf.append(",");
                }
                ++i;
            }
            return buf.toString();
        }
        if (this.isBoolean()) {
            return Boolean.class.getName();
        }
        return super.toString();
    }
}

