/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.emulator;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

class EditActionAccelerators {
    private static final String COPY_COMMAND_ID = "org.eclipse.tm.terminal.copy";
    private static final String PASTE_COMMAND_ID = "org.eclipse.tm.terminal.paste";
    private final Map commandIdsByAccelerator = new HashMap();

    EditActionAccelerators() {
    }

    private void load() {
        this.addAccelerator(COPY_COMMAND_ID);
        this.addAccelerator(PASTE_COMMAND_ID);
    }

    private void addAccelerator(String commandId) {
        KeySequence keySequence = EditActionAccelerators.bindingFor(commandId);
        if (keySequence == null) {
            return;
        }
        KeyStroke[] keyStrokes = keySequence.getKeyStrokes();
        if (keyStrokes.length != 0) {
            int accelerator = SWTKeySupport.convertKeyStrokeToAccelerator((KeyStroke)keyStrokes[0]);
            this.commandIdsByAccelerator.put(new Integer(accelerator), commandId);
        }
    }

    private static KeySequence bindingFor(String commandId) {
        IBindingService bindingService = EditActionAccelerators.bindingService();
        TriggerSequence binding = bindingService.getBestActiveBindingFor(commandId);
        if (binding instanceof KeySequence) {
            KeySequence keySequence = (KeySequence)binding;
            return keySequence;
        }
        return null;
    }

    private static IBindingService bindingService() {
        return (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
    }

    boolean isCopyAction(int accelerator) {
        return this.isMatchingAction(accelerator, COPY_COMMAND_ID);
    }

    boolean isPasteAction(int accelerator) {
        return this.isMatchingAction(accelerator, PASTE_COMMAND_ID);
    }

    private boolean isMatchingAction(int accelerator, String commandId) {
        if (this.commandIdsByAccelerator.isEmpty()) {
            this.load();
        }
        return commandId.equals(this.commandIdsByAccelerator.get(new Integer(accelerator)));
    }
}

