/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.core.registries;

import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystemConfigurationProxy;
import org.eclipse.rse.tests.RSETestsPlugin;
import org.eclipse.rse.tests.core.RSECoreTestCase;

public class SubSystemConfigurationProxyTestCase
extends RSECoreTestCase {
    private void assertProxyApplicable(ISubSystemConfigurationProxy proxy, IRSESystemType systemType, boolean isApplicable) {
        if (proxy.appliesToSystemType(systemType) != isApplicable) {
            StringBuffer buf = new StringBuffer(120);
            buf.append("Proxy \"");
            buf.append(proxy.getId());
            buf.append("\" is expected ");
            if (!isApplicable) {
                buf.append("not ");
            }
            buf.append("to be applicable to systemType \"");
            buf.append(systemType.getId());
            buf.append("\", but returned ");
            if (isApplicable) {
                buf.append("not ");
            }
            buf.append("to be!");
            SubSystemConfigurationProxyTestCase.assertTrue((String)buf.toString(), (boolean)false);
        }
    }

    public void testSubSystemConfigurationProxy() {
        if (this.isTestDisabled()) {
            return;
        }
        ISystemRegistry systemRegistry = RSECorePlugin.getTheSystemRegistry();
        SubSystemConfigurationProxyTestCase.assertNotNull((String)"Failed to fetch RSE system registry instance!", (Object)systemRegistry);
        ISubSystemConfigurationProxy[] proxies = systemRegistry.getSubSystemConfigurationProxies();
        int i = 0;
        while (i < proxies.length) {
            ISubSystemConfigurationProxy proxy = proxies[i];
            if (proxy.getDeclaringBundle().equals(RSETestsPlugin.getDefault().getBundle())) {
                IRSESystemType systemType;
                int j;
                IRSESystemType[] systemTypes;
                SubSystemConfigurationProxyTestCase.assertNotNull((String)"Unexpected retrun value null for proxy.toString()!", (Object)proxy.toString());
                SubSystemConfigurationProxyTestCase.assertEquals((String)"Proxy object changed hash code between two calls!", (int)proxy.hashCode(), (int)proxy.hashCode());
                SubSystemConfigurationProxyTestCase.assertFalse((String)"Unexpected return value true for proxy.equals(null)!", (boolean)proxy.equals(null));
                SubSystemConfigurationProxyTestCase.assertTrue((String)"Unexpected return value false for proxy.equals(proxy)!", (boolean)proxy.equals(proxy));
                if ("org.eclipse.rse.tests.subsystems.TestSubSystem".equals(proxy.getId())) {
                    SubSystemConfigurationProxyTestCase.assertEquals((String)"Unexpected return value for proxy.getDescription()!", (String)"Test Subsystem", (String)proxy.getDescription());
                    SubSystemConfigurationProxyTestCase.assertEquals((String)"Unexpected return value for proxy.getVendor()!", (String)"Eclipse.org", (String)proxy.getVendor());
                    SubSystemConfigurationProxyTestCase.assertEquals((String)"Unexpected return value for proxy.getName()!", (String)"Tests", (String)proxy.getName());
                    SubSystemConfigurationProxyTestCase.assertEquals((String)"Unexpected return value for proxy.getDeclaredSystemTypeIds()!", (String)"org.eclipse.rse.systemtype.local;org.eclipse.rse.systemtype.windows", (String)proxy.getDeclaredSystemTypeIds());
                    SubSystemConfigurationProxyTestCase.assertFalse((String)"Unexpected return value true for proxy.supportsAllSystemTypes()!", (boolean)proxy.supportsAllSystemTypes());
                    SubSystemConfigurationProxyTestCase.assertEquals((String)"Unexpected return value for proxy.getPriority()!", (int)50000, (int)proxy.getPriority());
                    SubSystemConfigurationProxyTestCase.assertEquals((String)"Unexpected return value for proxy.getCategory()!", (String)"users", (String)proxy.getCategory());
                    SubSystemConfigurationProxyTestCase.assertNotNull((String)"Unexpected return value null for proxy.getSubSystemConfiguration()!", (Object)proxy.getSubSystemConfiguration());
                    systemTypes = RSECorePlugin.getTheCoreRegistry().getSystemTypes();
                    SubSystemConfigurationProxyTestCase.assertNotNull((String)"Failed to fetch list of registered system types!", (Object)systemTypes);
                    j = 0;
                    while (j < systemTypes.length) {
                        systemType = systemTypes[j];
                        SubSystemConfigurationProxyTestCase.assertNotNull((String)"Invalid null value in list of registered system types!", (Object)systemType);
                        if (systemType.getId().equals("org.eclipse.rse.systemtype.local") || systemType.getId().equals("org.eclipse.rse.systemtype.windows")) {
                            this.assertProxyApplicable(proxy, systemType, true);
                        } else {
                            this.assertProxyApplicable(proxy, systemType, false);
                        }
                        ++j;
                    }
                }
                if ("org.eclipse.rse.tests.subsystems.TestSubSystem2".equals(proxy.getId())) {
                    SubSystemConfigurationProxyTestCase.assertEquals((String)"Unexpected return value for proxy.getDescription()!", (String)"Test Subsystem 2", (String)proxy.getDescription());
                    SubSystemConfigurationProxyTestCase.assertEquals((String)"Unexpected return value for proxy.getVendor()!", (String)"Eclipse.org", (String)proxy.getVendor());
                    SubSystemConfigurationProxyTestCase.assertEquals((String)"Unexpected return value for proxy.getName()!", (String)"Tests2", (String)proxy.getName());
                    SubSystemConfigurationProxyTestCase.assertEquals((String)"Unexpected return value for proxy.getDeclaredSystemTypeIds()!", (String)"org.eclipse.rse.tests.*", (String)proxy.getDeclaredSystemTypeIds());
                    SubSystemConfigurationProxyTestCase.assertFalse((String)"Unexpected return value true for proxy.supportsAllSystemTypes()!", (boolean)proxy.supportsAllSystemTypes());
                    SubSystemConfigurationProxyTestCase.assertEquals((String)"Unexpected return value for proxy.getPriority()!", (int)100000, (int)proxy.getPriority());
                    SubSystemConfigurationProxyTestCase.assertEquals((String)"Unexpected return value for proxy.getCategory()!", (String)"users", (String)proxy.getCategory());
                    SubSystemConfigurationProxyTestCase.assertNotNull((String)"Unexpected return value null for proxy.getSubSystemConfiguration()!", (Object)proxy.getSubSystemConfiguration());
                    systemTypes = RSECorePlugin.getTheCoreRegistry().getSystemTypes();
                    SubSystemConfigurationProxyTestCase.assertNotNull((String)"Failed to fetch list of registered system types!", (Object)systemTypes);
                    j = 0;
                    while (j < systemTypes.length) {
                        systemType = systemTypes[j];
                        SubSystemConfigurationProxyTestCase.assertNotNull((String)"Invalid null value in list of registered system types!", (Object)systemType);
                        if (systemType.getId().startsWith("org.eclipse.rse.tests.")) {
                            this.assertProxyApplicable(proxy, systemType, true);
                        } else {
                            this.assertProxyApplicable(proxy, systemType, false);
                        }
                        ++j;
                    }
                }
                if ("org.eclipse.rse.tests.subsystems.TestSubSystem3".equals(proxy.getId())) {
                    SubSystemConfigurationProxyTestCase.assertEquals((String)"Unexpected return value for proxy.getDescription()!", (String)"Test Subsystem 3", (String)proxy.getDescription());
                    SubSystemConfigurationProxyTestCase.assertEquals((String)"Unexpected return value for proxy.getVendor()!", (String)"Eclipse TM Project", (String)proxy.getVendor());
                    SubSystemConfigurationProxyTestCase.assertEquals((String)"Unexpected return value for proxy.getName()!", (String)"Tests3", (String)proxy.getName());
                    SubSystemConfigurationProxyTestCase.assertEquals((String)"Unexpected return value for proxy.getDeclaredSystemTypeIds()!", (String)"org.eclipse.rse.systemtype.*n?x", (String)proxy.getDeclaredSystemTypeIds());
                    SubSystemConfigurationProxyTestCase.assertFalse((String)"Unexpected return value true for proxy.supportsAllSystemTypes()!", (boolean)proxy.supportsAllSystemTypes());
                    SubSystemConfigurationProxyTestCase.assertEquals((String)"Unexpected return value for proxy.getPriority()!", (int)2000, (int)proxy.getPriority());
                    SubSystemConfigurationProxyTestCase.assertEquals((String)"Unexpected return value for proxy.getCategory()!", (String)"users", (String)proxy.getCategory());
                    SubSystemConfigurationProxyTestCase.assertNotNull((String)"Unexpected return value null for proxy.getSubSystemConfiguration()!", (Object)proxy.getSubSystemConfiguration());
                    systemTypes = RSECorePlugin.getTheCoreRegistry().getSystemTypes();
                    SubSystemConfigurationProxyTestCase.assertNotNull((String)"Failed to fetch list of registered system types!", (Object)systemTypes);
                    j = 0;
                    while (j < systemTypes.length) {
                        systemType = systemTypes[j];
                        SubSystemConfigurationProxyTestCase.assertNotNull((String)"Invalid null value in list of registered system types!", (Object)systemType);
                        if ("Unix".equalsIgnoreCase(systemType.getName()) || "Linux".equalsIgnoreCase(systemType.getName())) {
                            this.assertProxyApplicable(proxy, systemType, true);
                        } else {
                            this.assertProxyApplicable(proxy, systemType, false);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }
}

