/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.internal.core.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.dstore.core.model.DataStoreAttributes;

public class ServerAttributes
extends DataStoreAttributes {
    public ServerAttributes() {
        String pluginPath = System.getProperty("A_PLUGIN_PATH");
        if (pluginPath != null) {
            pluginPath = pluginPath.trim();
        }
        if (pluginPath != null && pluginPath.length() > 0) {
            File f = new File(pluginPath);
            try {
                pluginPath = f.getCanonicalPath();
            }
            catch (Exception exception) {
                pluginPath = f.getAbsolutePath();
            }
            this.setAttribute(0, String.valueOf(pluginPath) + File.separator);
        } else {
            this.setAttribute(0, "/home/");
        }
        this.setAttribute(6, ServerAttributes.getHostName());
        this.setAttribute(3, "server_host");
        this.setAttribute(4, "/home/");
    }

    public static String getHostName() {
        String hostname = System.getProperty("hostname");
        if (hostname == null || hostname.length() == 0) {
            String readHostname = System.getProperty("read.hostname");
            if (readHostname != null && readHostname.equals("true")) {
                try {
                    Process p = Runtime.getRuntime().exec("hostname");
                    InputStream inStream = p.getInputStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
                    hostname = reader.readLine();
                }
                catch (IOException iOException) {}
            }
            if (hostname == null || hostname.length() == 0) {
                try {
                    hostname = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException unknownHostException) {}
            }
            System.setProperty("hostname", hostname);
        }
        return hostname;
    }
}

