/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.connector.process;

import java.io.File;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.internal.terminal.emulator.VT100Emulator;
import org.eclipse.tm.internal.terminal.emulator.VT100TerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.NullSettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.terminal.connector.process.ProcessMonitor;
import org.eclipse.tm.terminal.connector.process.ProcessSettings;
import org.eclipse.tm.terminal.connector.process.nls.Messages;
import org.eclipse.tm.terminal.view.core.utils.Env;
import org.eclipse.tm.terminal.view.ui.manager.ConsoleManager;
import org.eclipse.tm.terminal.view.ui.streams.AbstractStreamsConnector;

public class ProcessConnector
extends AbstractStreamsConnector {
    private final ProcessSettings settings;
    private PTY pty;
    private Process process;
    private ProcessMonitor monitor;
    private int width = -1;
    private int height = -1;

    public ProcessConnector() {
        this(new ProcessSettings());
    }

    public ProcessConnector(ProcessSettings settings) {
        Assert.isNotNull((Object)settings);
        this.settings = settings;
    }

    public Process getProcess() {
        return this.process;
    }

    public void connect(ITerminalControl control) {
        Assert.isNotNull((Object)control);
        super.connect(control);
        this.pty = null;
        this.width = -1;
        this.height = -1;
        try {
            String lineSeparator;
            boolean isAnsiTerminal = false;
            this.process = this.settings.getProcess();
            this.pty = this.settings.getPTY();
            if (this.process == null) {
                if (PTY.isSupported((PTY.Mode)PTY.Mode.TERMINAL)) {
                    try {
                        this.pty = new PTY(PTY.Mode.TERMINAL);
                        VT100Emulator text = ((VT100TerminalControl)control).getTerminalText();
                        text.fontChanged();
                    }
                    catch (IOException iOException) {}
                }
                StringBuilder command = new StringBuilder(this.settings.getImage());
                String arguments = this.settings.getArguments();
                if (arguments != null && !"".equals(arguments.trim())) {
                    command.append(" ");
                    command.append(arguments.trim());
                }
                File workingDir = null;
                if (this.settings.getWorkingDir() != null) {
                    workingDir = new File(this.settings.getWorkingDir());
                }
                String[] envp = null;
                if (this.settings.getEnvironment() != null) {
                    envp = this.settings.getEnvironment();
                }
                if (this.settings.isMergeWithNativeEnvironment()) {
                    envp = Env.getEnvironment((String[])envp, (boolean)true);
                }
                isAnsiTerminal = ProcessConnector.getTermVariable(envp).startsWith("ansi");
                if (this.pty != null) {
                    StreamTokenizer st = new StreamTokenizer(new StringReader(command.toString()));
                    st.resetSyntax();
                    st.whitespaceChars(0, 32);
                    st.whitespaceChars(160, 160);
                    st.wordChars(33, 255);
                    st.quoteChar(34);
                    st.quoteChar(39);
                    ArrayList<String> argv = new ArrayList<String>();
                    int ttype = st.nextToken();
                    while (ttype != -1) {
                        argv.add(st.sval);
                        ttype = st.nextToken();
                    }
                    this.process = ProcessFactory.getFactory().exec(argv.toArray(new String[argv.size()]), envp, workingDir, this.pty);
                } else {
                    this.process = Runtime.getRuntime().exec(command.toString(), envp, workingDir);
                }
            }
            if ((lineSeparator = this.settings.getLineSeparator()) == null && this.pty == null) {
                lineSeparator = System.getProperty("line.separator");
                lineSeparator = "\r".equals(lineSeparator) ? "\\r" : ("\n".equals(lineSeparator) ? "\\n" : "\\r\\n");
            }
            this.setStdoutListeners(this.settings.getStdOutListeners());
            this.setStderrListeners(this.settings.getStdErrListeners());
            if (this.pty != null && !isAnsiTerminal) {
                control.setVT100LineWrapping(true);
            }
            this.connectStreams(control, this.process.getOutputStream(), this.process.getInputStream(), this.pty == null ? this.process.getErrorStream() : null, this.settings.isLocalEcho(), lineSeparator);
            control.setState(TerminalState.CONNECTED);
            this.monitor = new ProcessMonitor(this);
            this.monitor.startMonitoring();
        }
        catch (IOException e) {
            this.disconnect();
            CTabItem item = ConsoleManager.getInstance().findConsole(control);
            if (item != null) {
                item.dispose();
            }
            String msg = e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "";
            Assert.isNotNull((Object)msg);
            msg = msg.replace("Exec_tty error:", "").trim();
            msg = NLS.bind((String)Messages.ProcessConnector_error_creatingProcess, (Object)this.settings.getImage(), (Object)msg);
            MessageDialog.openError((Shell)control.getShell(), (String)Messages.ProcessConnector_error_title, (String)msg);
        }
    }

    private static String getTermVariable(String[] envp) {
        if (envp != null && !"win32".equals(Platform.getOS())) {
            String[] stringArray = envp;
            int n = envp.length;
            int n2 = 0;
            while (n2 < n) {
                String var = stringArray[n2];
                if (var.startsWith("TERM=")) {
                    return var.substring(5);
                }
                ++n2;
            }
        }
        return "xterm";
    }

    public boolean isLocalEcho() {
        return this.settings.isLocalEcho();
    }

    public void doDisconnect() {
        this.monitor.dispose();
        boolean isWindows = "win32".equals(Platform.getOS());
        if (!isWindows && this.process != null) {
            this.process.destroy();
            this.process = null;
        }
        super.doDisconnect();
        if (isWindows && this.process != null) {
            this.process.destroy();
            this.process = null;
        }
        this.fControl.setState(TerminalState.CLOSED);
    }

    public void setDefaultSettings() {
        this.settings.load((ISettingsStore)new NullSettingsStore());
    }

    public String getSettingsSummary() {
        return this.settings.getImage() != null ? this.settings.getImage() : "";
    }

    public void load(ISettingsStore store) {
        this.settings.load(store);
    }

    public void save(ISettingsStore store) {
        this.settings.save(store);
    }

    public void setTerminalSize(int newWidth, int newHeight) {
        if (this.width != newWidth || this.height != newHeight) {
            this.width = newWidth;
            this.height = newHeight;
            if (this.pty != null) {
                this.pty.setTerminalSize(newWidth, newHeight);
            }
        }
    }
}

