/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.scripting.core;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.ScriptResult;
import org.eclipse.ease.service.EngineDescription;
import org.eclipse.ease.service.ScriptService;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.scripting.core.Activator;

public class ScriptExecutionHelper {
    public static @Nullable Object executeScript(String filePath) {
        return ScriptExecutionHelper.executeScript(filePath, null, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static @Nullable Object executeScript(String filePath, @Nullable String engineID, @Nullable List<String> arguments) {
        Object scriptObject;
        Path path = Paths.get(filePath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            Activator.getInstance().logWarning(String.format("Script file does not exist %s", filePath));
            return null;
        }
        EngineDescription engineDescription = ScriptExecutionHelper.getEngine(filePath, engineID);
        if (engineDescription == null) {
            Activator.getInstance().logWarning(String.format("No engine was found to execute script %s", filePath));
            return null;
        }
        IScriptEngine engine = engineDescription.createEngine();
        if (arguments != null) {
            engine.setVariable("argv", (Object)arguments.toArray(new String[arguments.size()]));
        }
        if ((scriptObject = ResourceTools.resolve((Object)filePath)) == null) {
            Activator.getInstance().logWarning(String.format("The script cannot be resolved %s", filePath));
            return null;
        }
        ScriptResult scriptResult = engine.execute(scriptObject);
        engine.schedule();
        Object result = scriptResult.get();
        if (result == null) return 0;
        if (ScriptResult.VOID.equals(result)) {
            return 0;
        }
        {
            catch (Exception e1) {
                Activator.getInstance().logWarning(String.format("Script execution was interrupted (%s) by exeception: %s", filePath, e1.toString()));
                return null;
            }
            try {
                return Integer.parseInt(result.toString());
            }
            catch (Exception exception) {}
            {
                try {
                    return (int)Double.parseDouble(result.toString());
                }
                catch (Exception exception) {
                    try {
                        int n;
                        if (Boolean.parseBoolean(result.toString())) {
                            n = 0;
                            return n;
                        }
                        n = -1;
                        return n;
                    }
                    catch (Exception exception2) {
                        return null;
                    }
                }
            }
        }
    }

    private static @Nullable EngineDescription getEngine(@Nullable String filePath, @Nullable String engineID) {
        ScriptService scriptService = ScriptService.getInstance();
        if (engineID != null) {
            EngineDescription engineDescription = scriptService.getEngineByID(engineID);
            if (engineDescription == null) {
                throw new NullPointerException("Script engine not found " + engineID);
            }
            return engineDescription;
        }
        ScriptType scriptType = scriptService.getScriptType(filePath);
        if (scriptType == null) {
            Activator.getInstance().logWarning(String.format("No script type was found for script %s", filePath));
            return null;
        }
        EngineDescription engineDescription = scriptService.getEngine(scriptType.getName());
        return engineDescription;
    }
}

