/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.monitoring;

import java.lang.management.ThreadInfo;

public class StackSample {
    private final long timestamp;
    private final ThreadInfo[] traces;

    public StackSample(long timestamp, ThreadInfo[] traces) {
        this.timestamp = timestamp;
        this.traces = traces;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final ThreadInfo[] getStackTraces() {
        return this.traces;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("At ");
        buf.append(this.timestamp);
        if (this.traces.length != 0) {
            buf.append(" threads:\n");
            ThreadInfo[] threadInfoArray = this.traces;
            int n = this.traces.length;
            int n2 = 0;
            while (n2 < n) {
                ThreadInfo threadInfo = threadInfoArray[n2];
                buf.append(threadInfo.toString());
                ++n2;
            }
        }
        return buf.toString();
    }
}

