/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.analysis.callsite;

import com.google.common.annotations.VisibleForTesting;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.core.analysis.callsite.StateSystemStringInterner;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.analysis.callsite.ITmfCallsiteIterator;
import org.eclipse.tracecompass.tmf.core.analysis.callsite.TimeCallsite;
import org.eclipse.tracecompass.tmf.core.event.lookup.TmfCallsite;

class CallsiteIterator
implements ITmfCallsiteIterator {
    private @Nullable ITmfStateSystem fSS = null;
    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable StateSystemUtils.QuarkIterator fFileIterator = null;
    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable StateSystemUtils.QuarkIterator fLineIterator = null;
    private int fSourceQuark = -2;
    private @Nullable TimeCallsite fPrevious = null;
    private @Nullable TimeCallsite fNext = null;
    private @Nullable ITmfStateInterval fFileInterval = null;
    private @Nullable ITmfStateInterval fLineInterval = null;
    private final long fInitialTime;
    private final StateSystemStringInterner fInterner;

    @VisibleForTesting
    public CallsiteIterator(@Nullable ITmfStateSystem ss, String traceId, String deviceType, String deviceId, long initialTime, StateSystemStringInterner interner) {
        this.fInterner = interner;
        this.fInitialTime = initialTime;
        if (ss == null) {
            return;
        }
        int deviceQuark = ss.optQuarkAbsolute(new String[]{"Devices", traceId, deviceType, deviceId});
        if (deviceQuark == -2) {
            return;
        }
        int fileQuark = ss.optQuarkRelative(deviceQuark, new String[]{"Files"});
        if (fileQuark == -2) {
            return;
        }
        int lineQuark = ss.optQuarkRelative(deviceQuark, new String[]{"Lines"});
        if (lineQuark == -2) {
            return;
        }
        this.fFileIterator = new StateSystemUtils.QuarkIterator(ss, fileQuark, initialTime);
        this.fLineIterator = new StateSystemUtils.QuarkIterator(ss, lineQuark, initialTime);
        this.fSourceQuark = ss.optQuarkAbsolute(new String[]{"Sources"});
        this.fSS = ss;
    }

    private static boolean notMatchNext(@Nullable ITmfStateInterval interval, long time) {
        return interval == null || interval.getValue() == null || interval.getStartTime() < time;
    }

    private static boolean notMatchPrevious(@Nullable ITmfStateInterval interval, long time) {
        return interval == null || interval.getValue() == null || interval.getStartTime() > time;
    }

    @Override
    public boolean hasNext() {
        TimeCallsite next;
        if (this.fNext != null) {
            return true;
        }
        StateSystemUtils.QuarkIterator fileIterator = this.fFileIterator;
        StateSystemUtils.QuarkIterator lineIterator = this.fLineIterator;
        ITmfStateInterval lineInterval = this.fLineInterval;
        ITmfStateInterval fileInterval = this.fFileInterval;
        long nextTime = Long.MIN_VALUE;
        if (fileIterator == null || lineIterator == null || lineInterval == null && !lineIterator.hasNext() || fileInterval == null && !fileIterator.hasNext()) {
            return false;
        }
        nextTime = fileInterval != null && lineInterval != null ? Math.min(lineInterval.getEndTime() + 1L, fileInterval.getEndTime() + 1L) : this.fInitialTime;
        this.fPrevious = null;
        if (fileInterval == null) {
            fileInterval = fileIterator.next();
        }
        if (lineInterval == null) {
            lineInterval = lineIterator.next();
        }
        while (CallsiteIterator.notMatchNext(fileInterval, nextTime) && CallsiteIterator.notMatchNext(lineInterval, nextTime)) {
            int compare = Long.compare(fileInterval.getEndTime(), lineInterval.getEndTime());
            if (compare <= 0) {
                if (fileIterator.hasNext()) {
                    fileInterval = fileIterator.next();
                } else {
                    return false;
                }
            }
            if (compare < 0) continue;
            if (lineIterator.hasNext()) {
                lineInterval = lineIterator.next();
                continue;
            }
            return false;
        }
        this.fFileInterval = fileInterval;
        this.fLineInterval = lineInterval;
        this.fNext = next = this.getCallsite(fileInterval, lineInterval);
        return next != null;
    }

    @Override
    public TimeCallsite next() {
        if (this.hasNext()) {
            TimeCallsite next = Objects.requireNonNull(this.fNext, "Inconsistent state, should be non null if hasNext returned true");
            this.fNext = null;
            return next;
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasPrevious() {
        TimeCallsite previous;
        if (this.fPrevious != null) {
            return true;
        }
        StateSystemUtils.QuarkIterator fileIterator = this.fFileIterator;
        StateSystemUtils.QuarkIterator lineIterator = this.fLineIterator;
        ITmfStateInterval lineInterval = this.fLineInterval;
        ITmfStateInterval fileInterval = this.fFileInterval;
        long prevTime = Long.MAX_VALUE;
        if (fileIterator == null || lineIterator == null || lineInterval == null && !fileIterator.hasPrevious() || fileInterval == null && !lineIterator.hasPrevious()) {
            return false;
        }
        prevTime = fileInterval != null && lineInterval != null ? Math.max(lineInterval.getStartTime() - 1L, fileInterval.getStartTime() - 1L) : this.fInitialTime;
        this.fNext = null;
        if (fileInterval == null) {
            fileInterval = fileIterator.previous();
        }
        if (lineInterval == null) {
            lineInterval = lineIterator.previous();
        }
        while (CallsiteIterator.notMatchPrevious(fileInterval, prevTime) || CallsiteIterator.notMatchPrevious(lineInterval, prevTime)) {
            int compare = Long.compare(fileInterval.getStartTime(), lineInterval.getStartTime());
            if (compare >= 0) {
                if (fileIterator.hasPrevious()) {
                    fileInterval = fileIterator.previous();
                } else {
                    return false;
                }
            }
            if (compare > 0) continue;
            if (lineIterator.hasPrevious()) {
                lineInterval = lineIterator.previous();
                continue;
            }
            return false;
        }
        this.fFileInterval = fileInterval;
        this.fLineInterval = lineInterval;
        this.fPrevious = previous = this.getCallsite(fileInterval, lineInterval);
        return previous != null;
    }

    @Override
    public TimeCallsite previous() {
        if (this.hasPrevious()) {
            TimeCallsite prev = Objects.requireNonNull(this.fPrevious, "Inconsistent state, should be non null if hasPrevious returned true");
            this.fPrevious = null;
            return prev;
        }
        throw new NoSuchElementException();
    }

    private @Nullable TimeCallsite getCallsite(@Nullable ITmfStateInterval fileInterval, @Nullable ITmfStateInterval lineInterval) {
        ITmfStateSystem ss = this.fSS;
        if (ss == null || fileInterval == null || lineInterval == null) {
            return null;
        }
        try {
            Object value = fileInterval.getValue();
            if (value instanceof Integer) {
                long fileId = (long)((Integer)value).intValue() + ss.getStartTime();
                Object lineValue = lineInterval.getValue();
                if (lineValue instanceof Integer) {
                    long line = ((Integer)lineValue).intValue();
                    String fileName = this.fInterner.resolve(ss, fileId, this.fSourceQuark);
                    if (fileName != null) {
                        long time = Math.max(fileInterval.getStartTime(), lineInterval.getStartTime());
                        return new TimeCallsite(new TmfCallsite(fileName, line == -1L ? null : Long.valueOf(line)), time);
                    }
                }
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {}
        return null;
    }
}

