/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.ui.tests.service;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IChannelInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IDomainInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IEventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ISessionInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceChannelOutputType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEnablement;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEventType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.ILttngControlService;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.LTTngControlService;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.LTTngControlServiceFactory;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.LTTngControlServiceMI;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.LttngVersion;
import org.eclipse.tracecompass.lttng2.control.ui.tests.service.LTTngControlServiceMiTest;
import org.eclipse.tracecompass.tmf.remote.core.shell.ICommandShell;
import org.junit.Assert;
import org.junit.Test;

public class LTTngControlServiceMi3LTTng211
extends LTTngControlServiceMiTest {
    private static final String MI_TEST_STREAM = "LTTngServiceMi3TestLTTng211.cfg";
    private static final String SCEN_GET_SESSION_FILTER_EXPRESSION = "GetSessionFilterExpression";
    private static final String SCEN_LIST_CONTEXT_211 = "ListContext211";

    @Override
    protected ILttngControlService getControlService() {
        try {
            return new LTTngControlServiceMI((ICommandShell)this.getShell(), new LttngVersion("2.11.0"));
        }
        catch (ExecutionException executionException) {
            return null;
        }
    }

    @Override
    protected String getTestStream() {
        return MI_TEST_STREAM;
    }

    @Override
    public void testVersion() {
        try {
            this.fShell.setScenario("LttngVersion");
            ILttngControlService service = LTTngControlServiceFactory.getLttngControlService((ICommandShell)this.fShell);
            Assert.assertNotNull((Object)service);
            Assert.assertEquals((Object)"2.11.0", (Object)service.getVersionString());
        }
        catch (ExecutionException e) {
            Assert.fail((String)("Exeption thrown " + (Object)((Object)e)));
        }
    }

    @Override
    public void testVersionWithPrompt() {
        try {
            this.fShell.setScenario("LttngVersionWithPrompt");
            ILttngControlService service = LTTngControlServiceFactory.getLttngControlService((ICommandShell)this.fShell);
            Assert.assertNotNull((Object)service);
            Assert.assertEquals((Object)"2.11.0", (Object)service.getVersionString());
        }
        catch (ExecutionException e) {
            Assert.fail((String)("Exeption thrown " + (Object)((Object)e)));
        }
    }

    @Override
    public void testVersionCompiled() {
        try {
            this.fShell.setScenario("LttngVersionCompiled");
            ILttngControlService service = LTTngControlServiceFactory.getLttngControlService((ICommandShell)this.fShell);
            Assert.assertNotNull((Object)service);
            Assert.assertEquals((Object)"2.11.0", (Object)service.getVersionString());
        }
        catch (ExecutionException e) {
            Assert.fail((String)("Exeption thrown " + (Object)((Object)e)));
        }
    }

    @Test
    public void testGetSessionWithFilterExpression() throws ExecutionException {
        this.fShell.setScenario(SCEN_GET_SESSION_FILTER_EXPRESSION);
        ISessionInfo session = this.fService.getSession("mysession", (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((Object)session);
        Assert.assertEquals((Object)"mysession", (Object)session.getName());
        Assert.assertEquals((Object)"/home/user/lttng-traces/mysession-20120129-084256", (Object)session.getSessionPath());
        Assert.assertEquals((Object)TraceSessionState.ACTIVE, (Object)session.getSessionState());
        IDomainInfo[] domains = session.getDomains();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)2L, (long)domains.length);
        Assert.assertEquals((Object)"Kernel", (Object)domains[0].getName());
        IChannelInfo[] channels = domains[0].getChannels();
        Assert.assertNotNull((Object)channels);
        Assert.assertEquals((long)1L, (long)channels.length);
        Assert.assertEquals((Object)"channel0", (Object)channels[0].getName());
        Assert.assertEquals((long)4L, (long)channels[0].getNumberOfSubBuffers());
        Assert.assertEquals((Object)"splice()", (Object)channels[0].getOutputType().getInName());
        Assert.assertEquals((Object)TraceChannelOutputType.SPLICE, (Object)channels[0].getOutputType());
        Assert.assertEquals((Object)false, (Object)channels[0].isOverwriteMode());
        Assert.assertEquals((long)200L, (long)channels[0].getReadTimer());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)channels[0].getState());
        Assert.assertEquals((long)262144L, (long)channels[0].getSubBufferSize());
        Assert.assertEquals((long)0L, (long)channels[0].getSwitchTimer());
        IEventInfo[] channel0Events = channels[0].getEvents();
        Assert.assertNotNull((Object)channel0Events);
        Assert.assertEquals((long)1L, (long)channel0Events.length);
        Assert.assertEquals((Object)"block_rq_remap", (Object)channel0Events[0].getName());
        Assert.assertEquals((Object)TraceLogLevel.TRACE_EMERG, (Object)channel0Events[0].getLogLevel());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)channel0Events[0].getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)channel0Events[0].getState());
        Assert.assertEquals((Object)"foo > 10", (Object)channel0Events[0].getFilterExpression());
        Assert.assertEquals((Object)"UST global", (Object)domains[1].getName());
        IChannelInfo[] ustChannels = domains[1].getChannels();
        Assert.assertEquals((Object)"channel0", (Object)ustChannels[0].getName());
        Assert.assertEquals((long)4L, (long)ustChannels[0].getNumberOfSubBuffers());
        Assert.assertEquals((Object)"mmap()", (Object)ustChannels[0].getOutputType().getInName());
        Assert.assertEquals((Object)TraceChannelOutputType.MMAP, (Object)ustChannels[0].getOutputType());
        Assert.assertEquals((Object)false, (Object)ustChannels[0].isOverwriteMode());
        Assert.assertEquals((long)200L, (long)ustChannels[0].getReadTimer());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)ustChannels[0].getState());
        Assert.assertEquals((long)4096L, (long)ustChannels[0].getSubBufferSize());
        Assert.assertEquals((long)0L, (long)ustChannels[0].getSwitchTimer());
        IEventInfo[] ustEvents = ustChannels[0].getEvents();
        Assert.assertEquals((long)1L, (long)ustEvents.length);
        Assert.assertEquals((Object)"ust_tests_hello:tptest_sighandler", (Object)ustEvents[0].getName());
        Assert.assertEquals((Object)TraceLogLevel.TRACE_DEBUG_LINE, (Object)ustEvents[0].getLogLevel());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)ustEvents[0].getEventType());
        Assert.assertEquals((Object)TraceEnablement.DISABLED, (Object)ustEvents[0].getState());
        Assert.assertEquals((Object)"foo > 10", (Object)ustEvents[0].getFilterExpression());
    }

    @Test
    public void testListContext211() throws ExecutionException {
        ((LTTngControlService)this.fService).setVersion("2.11.0");
        this.fShell.setScenario(SCEN_LIST_CONTEXT_211);
        List availContexts = this.fService.getContextList((IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((Object)availContexts);
        Assert.assertEquals((long)12L, (long)availContexts.size());
        HashSet<String> expectedContexts = new HashSet<String>();
        expectedContexts.add("pid");
        expectedContexts.add("procname");
        expectedContexts.add("prio");
        expectedContexts.add("nice");
        expectedContexts.add("vpid");
        expectedContexts.add("tid");
        expectedContexts.add("pthread_id");
        expectedContexts.add("vtid");
        expectedContexts.add("ppid");
        expectedContexts.add("vppid");
        expectedContexts.add("perf:cpu:cpu-cycles");
        expectedContexts.add("perf:cpu:cycles");
        Assert.assertTrue((boolean)expectedContexts.containsAll(availContexts));
    }
}

