/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import org.bouncycastle.util.Pack;
import org.bouncycastle.util.encoders.Hex;

public class FingerprintUtil {
    public static long keyIdFromFingerprint(int n, byte[] byArray) {
        switch (n) {
            case 4: {
                return FingerprintUtil.keyIdFromV4Fingerprint(byArray);
            }
            case 5: {
                return FingerprintUtil.keyIdFromLibrePgpFingerprint(byArray);
            }
            case 6: {
                return FingerprintUtil.keyIdFromV6Fingerprint(byArray);
            }
        }
        return 0L;
    }

    public static long keyIdFromV6Fingerprint(byte[] byArray) {
        return FingerprintUtil.longFromLeftMostBytes(byArray);
    }

    public static long keyIdFromLibrePgpFingerprint(byte[] byArray) {
        return FingerprintUtil.longFromLeftMostBytes(byArray);
    }

    public static long keyIdFromV4Fingerprint(byte[] byArray) {
        return FingerprintUtil.longFromRightMostBytes(byArray);
    }

    public static long longFromLeftMostBytes(byte[] byArray) {
        return FingerprintUtil.readKeyID(byArray);
    }

    public static long longFromRightMostBytes(byte[] byArray) {
        return FingerprintUtil.readKeyID(byArray, byArray.length - 8);
    }

    public static long readKeyID(byte[] byArray) {
        return FingerprintUtil.readKeyID(byArray, 0);
    }

    public static long readKeyID(byte[] byArray, int n) {
        if (byArray.length < 8) {
            throw new IllegalArgumentException("Byte array MUST contain at least 8 bytes");
        }
        return Pack.bigEndianToLong((byte[])byArray, (int)n);
    }

    public static void writeKeyID(long l, byte[] byArray, int n) {
        if (byArray.length - n < 8) {
            throw new IllegalArgumentException("Not enough space to write key-ID to byte array.");
        }
        Pack.longToBigEndian((long)l, (byte[])byArray, (int)n);
    }

    public static void writeKeyID(long l, byte[] byArray) {
        FingerprintUtil.writeKeyID(l, byArray, 0);
    }

    public static String prettifyFingerprint(byte[] byArray) {
        char[] cArray = Hex.toHexString((byte[])byArray).toUpperCase().toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        switch (cArray.length) {
            case 32: {
                int n;
                for (n = 0; n < 4; ++n) {
                    stringBuilder.append(cArray, n * 4, 4).append(' ');
                }
                stringBuilder.append(' ');
                for (n = 4; n < 7; ++n) {
                    stringBuilder.append(cArray, n * 4, 4).append(' ');
                }
                stringBuilder.append(cArray, 28, 4);
                return stringBuilder.toString();
            }
            case 40: {
                int n;
                for (n = 0; n <= 4; ++n) {
                    stringBuilder.append(cArray, n * 4, 4).append(' ');
                }
                stringBuilder.append(' ');
                for (n = 5; n <= 8; ++n) {
                    stringBuilder.append(cArray, n * 4, 4).append(' ');
                }
                stringBuilder.append(cArray, 36, 4);
                return stringBuilder.toString();
            }
            case 64: {
                int n;
                for (n = 0; n < 4; ++n) {
                    stringBuilder.append(cArray, n * 8, 8).append(' ');
                }
                stringBuilder.append(' ');
                for (n = 4; n < 7; ++n) {
                    stringBuilder.append(cArray, n * 8, 8).append(' ');
                }
                stringBuilder.append(cArray, 56, 8);
                return stringBuilder.toString();
            }
        }
        return new String(cArray);
    }
}

