/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.importexport;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.AbstractTracePackageOperation;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.AbstractTracePackageWizardPage;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageExperimentElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageFilesElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageTraceElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.importexport.TracePackageExtractManifestOperation;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.importexport.TracePackageImportOperation;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ImportTracePackageWizardPage
extends AbstractTracePackageWizardPage {
    private static final String ICON_PATH = "icons/wizban/trace_import_wiz.png";
    private static final String PAGE_NAME = "ImportTracePackagePage";
    private static final String STORE_PROJECT_NAME_ID = "ImportTracePackagePage.STORE_PROJECT_NAME_ID";
    private String fValidatedFilePath;
    private TmfTraceFolder fTmfTraceFolder;
    private Text fProjectText;
    private List<IProject> fOpenedTmfProjects;

    public ImportTracePackageWizardPage(IStructuredSelection selection) {
        super(PAGE_NAME, Messages.ImportTracePackageWizardPage_Title, Activator.getDefault().getImageDescripterFromPath(ICON_PATH), selection);
        if (this.getSelection().getFirstElement() instanceof TmfTraceFolder) {
            this.fTmfTraceFolder = (TmfTraceFolder)this.getSelection().getFirstElement();
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        this.createFilePathGroup(composite, Messages.ImportTracePackageWizardPage_FromArchive, 4096);
        this.createElementViewer(composite);
        this.createButtonsGroup(composite);
        if (this.fTmfTraceFolder == null) {
            this.createProjectSelectionGroup(composite);
        }
        this.restoreWidgetValues();
        this.setMessage(Messages.ImportTracePackageWizardPage_Message);
        this.updatePageCompletion();
        this.setControl((Control)composite);
    }

    private void createProjectSelectionGroup(Composite parent) {
        IProject defaultProject;
        Composite projectSelectionGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        projectSelectionGroup.setLayout((Layout)layout);
        projectSelectionGroup.setLayoutData((Object)new GridData(272));
        Label projectLabel = new Label(projectSelectionGroup, 0);
        projectLabel.setText(Messages.ImportTracePackageWizardPage_Project);
        this.fProjectText = new Text(projectSelectionGroup, 2060);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.fProjectText.setLayoutData((Object)data);
        this.fOpenedTmfProjects = TraceUtils.getOpenedTmfProjects();
        if (this.fOpenedTmfProjects.isEmpty() && !(defaultProject = ResourcesPlugin.getWorkspace().getRoot().getProject(TmfCommonConstants.DEFAULT_TRACE_PROJECT_NAME)).exists()) {
            IProject project = TmfProjectRegistry.createProject(TmfCommonConstants.DEFAULT_TRACE_PROJECT_NAME, null, null);
            this.fOpenedTmfProjects.add(project);
        }
        if (!this.fOpenedTmfProjects.isEmpty()) {
            this.selectProject(this.fOpenedTmfProjects.get(0));
        }
        Button button = new Button(projectSelectionGroup, 8);
        button.setText(Messages.ImportTracePackageWizardPage_SelectProjectButton);
        button.addListener(13, event -> {
            ElementListSelectionDialog d = new ElementListSelectionDialog(this.getContainer().getShell(), (ILabelProvider)new WorkbenchLabelProvider());
            d.setBlockOnOpen(true);
            d.setTitle(Messages.ImportTracePackageWizardPage_SelectProjectDialogTitle);
            d.setElements((Object[])this.fOpenedTmfProjects.toArray(new IProject[0]));
            d.open();
            if (d.getFirstResult() != null) {
                IProject project = (IProject)d.getFirstResult();
                this.selectProject(project);
            }
        });
        this.setButtonLayoutData(button);
    }

    @Override
    protected void restoreWidgetValues() {
        String projectName;
        super.restoreWidgetValues();
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && this.fProjectText != null && (projectName = settings.get(STORE_PROJECT_NAME_ID)) != null && !projectName.isEmpty()) {
            for (IProject project : this.fOpenedTmfProjects) {
                if (!project.getName().equals(projectName)) continue;
                this.selectProject(project);
                break;
            }
        }
    }

    @Override
    protected void saveWidgetValues() {
        super.saveWidgetValues();
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_PROJECT_NAME_ID, this.fTmfTraceFolder.getProject().getResource().getName());
        }
    }

    private void selectProject(IProject project) {
        this.fProjectText.setText(project.getName());
        this.fTmfTraceFolder = TmfProjectRegistry.getProject(project, true).getTracesFolder();
        this.updatePageCompletion();
    }

    @Override
    protected boolean determinePageCompletion() {
        return super.determinePageCompletion() && this.fTmfTraceFolder != null;
    }

    protected AbstractTracePackageOperation createExtractManifestOperation(String fileName) {
        return new TracePackageExtractManifestOperation(fileName);
    }

    @Override
    protected Object createElementViewerInput() {
        TracePackageElement[] resultElements;
        final AbstractTracePackageOperation op = this.createExtractManifestOperation(this.getFilePathValue());
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.ImportTracePackageWizardPage_ReadingPackage, 10);
                    op.run(monitor);
                    monitor.done();
                }
            });
            IStatus status = op.getStatus();
            if (status.getSeverity() == 4) {
                this.handleErrorStatus(status);
            }
        }
        catch (InvocationTargetException e1) {
            this.handleError(Messages.TracePackageExtractManifestOperation_ErrorReadingManifest, e1);
        }
        catch (InterruptedException e1) {
            // empty catch block
        }
        if ((resultElements = op.getResultElements()) == null || resultElements.length == 0) {
            return null;
        }
        return resultElements;
    }

    @Override
    protected void createFilePathGroup(Composite parent, String label, int fileDialogStyle) {
        super.createFilePathGroup(parent, label, fileDialogStyle);
        Combo filePathCombo = this.getFilePathCombo();
        filePathCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTracePackageWizardPage.this.updateWithFilePathSelection();
            }
        });
        filePathCombo.addTraverseListener(e -> {
            if (e.detail == 4) {
                e.doit = false;
                this.updateWithFilePathSelection();
            }
        });
    }

    @Override
    protected void updateWithFilePathSelection() {
        if (!this.isFilePathValid()) {
            this.setErrorMessage(Messages.ImportTracePackageWizardPage_ErrorFileNotFound);
            this.getElementViewer().setInput(null);
            return;
        }
        this.setErrorMessage(null);
        this.getContainer().getShell().getDisplay().asyncExec(() -> {
            CheckboxTreeViewer elementViewer = this.getElementViewer();
            Object elementViewerInput = this.createElementViewerInput();
            elementViewer.setInput(elementViewerInput);
            if (elementViewerInput != null) {
                elementViewer.expandToLevel(2);
                ImportTracePackageWizardPage.setAllChecked(elementViewer, false, true);
                this.fValidatedFilePath = this.getFilePathValue();
            }
            this.updatePageCompletion();
        });
    }

    private boolean isFilePathValid() {
        return new File(this.getFilePathValue()).exists();
    }

    public boolean finish() {
        if (!this.checkForConflict()) {
            return false;
        }
        this.saveWidgetValues();
        Object input = this.getElementViewer().getInput();
        TracePackageElement[] traceElements = (TracePackageElement[])input;
        final TracePackageImportOperation importOperation = new TracePackageImportOperation(this.fValidatedFilePath, traceElements, this.fTmfTraceFolder);
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    importOperation.run(monitor);
                }
            });
            IStatus status = importOperation.getStatus();
            if (status.getSeverity() == 4) {
                this.handleErrorStatus(status);
            }
        }
        catch (InvocationTargetException e) {
            this.handleError(Messages.ImportTracePackageWizardPage_ErrorOperation, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return importOperation.getStatus().getSeverity() == 0;
    }

    private boolean checkForConflict() {
        TracePackageElement[] packageElements = (TracePackageElement[])this.getElementViewer().getInput();
        ArrayList<TracePackageExperimentElement> experimentElements = new ArrayList<TracePackageExperimentElement>();
        ArrayList<TracePackageTraceElement> traceElements = new ArrayList<TracePackageTraceElement>();
        HashMap<TracePackageExperimentElement, List<TracePackageTraceElement>> experimentTracesMap = new HashMap<TracePackageExperimentElement, List<TracePackageTraceElement>>();
        ArrayList<TracePackageExperimentElement> experimentToRename = new ArrayList<TracePackageExperimentElement>();
        ArrayList<TracePackageTraceElement> unhandledTraces = new ArrayList<TracePackageTraceElement>();
        TracePackageElement[] tracePackageElementArray = packageElements;
        int n = packageElements.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement packageElement = tracePackageElementArray[n2];
            TracePackageTraceElement traceElement = (TracePackageTraceElement)packageElement;
            if (AbstractTracePackageOperation.isFilesChecked(traceElement)) {
                if (traceElement instanceof TracePackageExperimentElement) {
                    TracePackageExperimentElement experimentElement = (TracePackageExperimentElement)traceElement;
                    experimentElements.add(experimentElement);
                    if (this.experimentExists(experimentElement)) {
                        experimentToRename.add(experimentElement);
                    }
                } else {
                    traceElements.add(traceElement);
                }
            }
            ++n2;
        }
        for (TracePackageTraceElement traceElement : traceElements) {
            this.processTrace(experimentElements, traceElement, experimentTracesMap, unhandledTraces);
        }
        boolean result = true;
        if (!experimentTracesMap.isEmpty() || !experimentToRename.isEmpty()) {
            result &= this.handleExperimentConflict(experimentTracesMap, experimentToRename);
        }
        if (!unhandledTraces.isEmpty()) {
            result &= this.handleTracesConflict(unhandledTraces);
        }
        return result;
    }

    private void processTrace(List<TracePackageExperimentElement> experimentElements, TracePackageTraceElement traceElement, Map<TracePackageExperimentElement, List<TracePackageTraceElement>> experimentTracesMap, List<TracePackageTraceElement> unhandledTraces) {
        boolean isAlone = this.traceExists(traceElement);
        for (TracePackageExperimentElement experimentElement : experimentElements) {
            List<String> tracesPath = experimentElement.getExpTraces();
            if (!this.traceExists(traceElement) || !tracesPath.contains(traceElement.getDestinationElementPath())) continue;
            isAlone = false;
            List<TracePackageTraceElement> traces = experimentTracesMap.get((Object)experimentElement);
            if (traces == null) {
                traces = new ArrayList<TracePackageTraceElement>();
            }
            traces.add(traceElement);
            experimentTracesMap.put(experimentElement, traces);
        }
        if (isAlone) {
            unhandledTraces.add(traceElement);
        }
    }

    private boolean handleExperimentConflict(Map<TracePackageExperimentElement, List<TracePackageTraceElement>> experimentTracesMap, List<TracePackageExperimentElement> experimentToRename) {
        if (!experimentToRename.isEmpty() && experimentTracesMap.isEmpty()) {
            for (TracePackageExperimentElement experimentElement : experimentToRename) {
                int returnCode = this.promptForExperimentRename(experimentElement);
                if (returnCode < 0) {
                    return false;
                }
                String[] response = new String[]{IDialogConstants.NO_LABEL, IDialogConstants.YES_LABEL};
                if (response[returnCode].equals(IDialogConstants.NO_LABEL)) {
                    ImportTracePackageWizardPage.uncheckExperimentElement(experimentElement, Collections.emptyList());
                    continue;
                }
                if (!response[returnCode].equals(IDialogConstants.YES_LABEL)) continue;
                this.changeExperimentName(experimentElement);
            }
        } else {
            for (Map.Entry<TracePackageExperimentElement, List<TracePackageTraceElement>> experimentEntry : experimentTracesMap.entrySet()) {
                int returnCode = this.promptForExperimentOverwrite(experimentEntry, experimentToRename);
                if (returnCode < 0) {
                    return false;
                }
                String[] response = new String[]{IDialogConstants.NO_LABEL, IDialogConstants.YES_LABEL};
                if (!response[returnCode].equals(IDialogConstants.NO_LABEL)) continue;
                ImportTracePackageWizardPage.uncheckExperimentElement(experimentEntry.getKey(), experimentEntry.getValue());
            }
        }
        return true;
    }

    private void changeExperimentName(TracePackageExperimentElement experimentElement) {
        String currentName = experimentElement.getImportName();
        int nameSuffixIndex = 2;
        while (this.experimentExists(experimentElement)) {
            String newName = String.valueOf(currentName) + " (" + nameSuffixIndex + ')';
            experimentElement.setImportName(newName);
            ++nameSuffixIndex;
        }
    }

    private boolean handleTracesConflict(List<TracePackageTraceElement> traceElements) {
        boolean noToAll = false;
        for (TracePackageTraceElement traceElement : traceElements) {
            if (noToAll) {
                ImportTracePackageWizardPage.uncheckTraceElement(traceElement);
                continue;
            }
            int returnCode = this.promptForTraceOverwrite(traceElement);
            if (returnCode < 0) {
                return false;
            }
            String[] response = new String[]{IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.YES_LABEL};
            if (response[returnCode].equals(IDialogConstants.NO_TO_ALL_LABEL)) {
                noToAll = true;
                ImportTracePackageWizardPage.uncheckTraceElement(traceElement);
                continue;
            }
            if (!response[returnCode].equals(IDialogConstants.NO_LABEL)) continue;
            ImportTracePackageWizardPage.uncheckTraceElement(traceElement);
        }
        return true;
    }

    private static void uncheckTraceElement(TracePackageTraceElement traceElement) {
        TracePackageElement[] tracePackageElementArray = traceElement.getChildren();
        int n = tracePackageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement e = tracePackageElementArray[n2];
            if (e instanceof TracePackageFilesElement) {
                ((TracePackageFilesElement)e).setChecked(false);
            }
            ++n2;
        }
    }

    private static void uncheckExperimentElement(TracePackageExperimentElement experimentElement, List<TracePackageTraceElement> expTraceElements) {
        TracePackageElement[] tracePackageElementArray = experimentElement.getChildren();
        int n = tracePackageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement e = tracePackageElementArray[n2];
            if (e instanceof TracePackageFilesElement) {
                ((TracePackageFilesElement)e).setChecked(false);
            }
            ++n2;
        }
        for (TracePackageTraceElement traceElement : expTraceElements) {
            ImportTracePackageWizardPage.uncheckTraceElement(traceElement);
        }
    }

    private boolean experimentExists(TracePackageExperimentElement experimentElement) {
        TmfExperimentFolder experimentsFolder = this.fTmfTraceFolder.getProject().getExperimentsFolder();
        return experimentsFolder != null && experimentsFolder.getChild(experimentElement.getImportName()) != null;
    }

    private boolean traceExists(TracePackageTraceElement traceElement) {
        IResource traceRes = this.fTmfTraceFolder.getResource().findMember(traceElement.getDestinationElementPath());
        return traceRes != null;
    }

    private int promptForTraceOverwrite(TracePackageTraceElement packageElement) {
        String name = packageElement.getDestinationElementPath();
        MessageDialog dialog = new MessageDialog(this.getContainer().getShell(), Messages.ImportTracePackageWizardPage_AlreadyExistsTitle, null, MessageFormat.format(Messages.ImportTracePackageWizardPage_TraceAlreadyExists, name), 3, new String[]{IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.YES_LABEL}, 3){

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10000000;
            }
        };
        return dialog.open();
    }

    private int promptForExperimentRename(TracePackageExperimentElement experimentElement) {
        String dialogMessage = MessageFormat.format(Messages.ImportTracePackageWizardPage_ExperimentAlreadyExists, experimentElement.getImportName());
        MessageDialog dialog = new MessageDialog(this.getContainer().getShell(), Messages.ImportTracePackageWizardPage_AlreadyExistsTitle, null, dialogMessage, 3, new String[]{IDialogConstants.NO_LABEL, IDialogConstants.YES_LABEL}, 3){

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10000000;
            }
        };
        return dialog.open();
    }

    private int promptForExperimentOverwrite(Map.Entry<TracePackageExperimentElement, List<TracePackageTraceElement>> experimentEntry, List<TracePackageExperimentElement> experimentToRename) {
        List<TracePackageTraceElement> traceElements = experimentEntry.getValue();
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < traceElements.size()) {
            builder.append(traceElements.get(i).getImportName());
            if (i < traceElements.size() - 1) {
                builder.append(", ");
            }
            ++i;
        }
        String dialogMessage = experimentToRename.contains((Object)experimentEntry.getKey()) ? MessageFormat.format(Messages.ImportTracePackageWizardPage_ExperimentAndTraceAlreadyExist, experimentEntry.getKey().getImportName(), builder.toString()) : MessageFormat.format(Messages.ImportTracePackageWizardPage_TraceFromExperimentAlreadyExist, experimentEntry.getKey().getImportName(), builder.toString());
        MessageDialog dialog = new MessageDialog(this.getContainer().getShell(), Messages.ImportTracePackageWizardPage_AlreadyExistsTitle, null, dialogMessage, 3, new String[]{IDialogConstants.NO_LABEL, IDialogConstants.YES_LABEL}, 3){

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10000000;
            }
        };
        return dialog.open();
    }
}

