/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.views.uml2sd.load;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.SDView;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.load.IUml2SDLoader;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.load.LoadersManager;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.junit.Test;

public class LoadersManagerTest {
    private static final String SDVIEW_WITH_ONE_LOADER = "org.eclipse.linuxtools.tmf.ui.tests.testSDView1Loader";
    private static final String SDVIEW_WITH_MULTIPLE_LOADER = "org.eclipse.linuxtools.tmf.ui.tests.testSDView2Loaders";
    private static final String TEST_LOADER_CLASS_NAME = "org.eclipse.tracecompass.tmf.ui.tests.uml2sd.load.TestLoaders";
    private static final String TMF_UML2SD_LOADER_CLASS_NAME = "org.eclipse.tracecompass.tmf.ui.views.uml2sd.loader.TmfUml2SDSyncLoader";
    private static final String LOADER_TAG = "uml2SDLoader";
    private static final String LOADER_PREFIX = "uml2SDLoader.";

    @Test
    public void testLoaderManager() {
        SDView view = null;
        try {
            view = (SDView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(SDVIEW_WITH_ONE_LOADER);
            IUml2SDLoader defaultLoader = LoadersManager.getInstance().getCurrentLoader(SDVIEW_WITH_ONE_LOADER, view);
            Assert.assertNotNull((String)"testLoaderManager", (Object)defaultLoader);
            Assert.assertNull((String)"testLoaderManager", (Object)LoadersManager.getInstance().createLoader("blabla", view));
            IUml2SDLoader loader = LoadersManager.getInstance().createLoader(TEST_LOADER_CLASS_NAME, view);
            Assert.assertNotNull((String)"testLoaderManager", (Object)loader);
            Assert.assertEquals((String)"testLoaderManager", (Object)"Test Loader", (Object)loader.getTitleString());
            Assert.assertEquals((String)"testLoaderManager", (Object)loader, (Object)LoadersManager.getInstance().getCurrentLoader(SDVIEW_WITH_ONE_LOADER));
            Assert.assertFalse((String)"testLoaderManager", (loader == defaultLoader ? 1 : 0) != 0);
            IUml2SDLoader loader2 = LoadersManager.getInstance().getCurrentLoader(SDVIEW_WITH_ONE_LOADER, view);
            Assert.assertEquals((String)"testLoaderManager", (Object)loader, (Object)loader2);
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView((IViewPart)view);
            view = (SDView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(SDVIEW_WITH_ONE_LOADER);
            Assert.assertEquals((String)"testLoaderManager", (Object)"Sequence Diagram - First Page", (Object)view.getFrame().getName());
            Assert.assertNull((String)"testLoaderManager", (Object)LoadersManager.getInstance().createLoader(TEST_LOADER_CLASS_NAME, null));
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView((IViewPart)view);
            view = (SDView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(SDVIEW_WITH_MULTIPLE_LOADER);
            Assert.assertEquals((String)"testLoaderManager", (Object)"Sequence Diagram - First Page", (Object)view.getFrame().getName());
            loader = LoadersManager.getInstance().getCurrentLoader(SDVIEW_WITH_MULTIPLE_LOADER, view);
            Assert.assertNotNull((String)"testLoaderManager", (Object)loader);
            Assert.assertEquals((String)"testLoaderManager", (Object)"Test Loader", (Object)loader.getTitleString());
            Assert.assertEquals((String)"testLoaderManager", (Object)loader, (Object)LoadersManager.getInstance().getCurrentLoader(SDVIEW_WITH_MULTIPLE_LOADER));
            loader = LoadersManager.getInstance().createLoader(TMF_UML2SD_LOADER_CLASS_NAME, view);
            Assert.assertNotNull((String)"testLoaderManager", (Object)loader);
            Assert.assertEquals((String)"testLoaderManager", (Object)"Component Interactions", (Object)loader.getTitleString());
            Assert.assertEquals((String)"testLoaderManager", (Object)loader, (Object)LoadersManager.getInstance().getCurrentLoader(SDVIEW_WITH_MULTIPLE_LOADER));
            Assert.assertEquals((String)"testLoaderManager", (Object)TMF_UML2SD_LOADER_CLASS_NAME, (Object)LoadersManagerTest.getSavedLoader(SDVIEW_WITH_MULTIPLE_LOADER));
            loader = LoadersManager.getInstance().createLoader(TEST_LOADER_CLASS_NAME, view);
            Assert.assertNotNull((String)"testLoaderManager", (Object)loader);
            Assert.assertEquals((String)"testLoaderManager", (Object)"Test Loader", (Object)loader.getTitleString());
            Assert.assertEquals((String)"testLoaderManager", (Object)loader, (Object)LoadersManager.getInstance().getCurrentLoader(SDVIEW_WITH_MULTIPLE_LOADER));
            Assert.assertEquals((String)"testLoaderManager", (Object)TEST_LOADER_CLASS_NAME, (Object)LoadersManagerTest.getSavedLoader(SDVIEW_WITH_MULTIPLE_LOADER));
            Assert.assertEquals((String)"testLoaderManager", (Object)TEST_LOADER_CLASS_NAME, (Object)LoadersManager.getInstance().getSavedLoader(SDVIEW_WITH_MULTIPLE_LOADER));
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView((IViewPart)view);
            LoadersManager.getInstance().resetLoader(SDVIEW_WITH_MULTIPLE_LOADER);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    private static String getSavedLoader(String viewId) {
        IPreferenceStore p = Activator.getDefault().getPreferenceStore();
        return p.getString(LOADER_PREFIX + viewId);
    }
}

