/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.viewers.events;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.keyboard.Keystrokes;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCanvas;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotRadio;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.tmf.core.io.BufferedRandomAccessFile;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.SDView;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.Frame;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.provider.ISDAdvancedPagingProvider;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class SDViewTest {
    private static final String UML2DVIEW_ID = "org.eclipse.linuxtools.tmf.ui.tmfUml2SDSyncView";
    private static final String XMLSTUB_ID = "org.eclipse.linuxtools.tmf.core.tests.xmlstub";
    private static final String TRACE_START = "<trace>";
    private static final String EVENT_BEGIN = "<event timestamp=\"";
    private static final String EVENT_MIDDLE1 = " \" name=\"";
    private static final String EVENT_MIDDLE2 = "\">";
    private static final String FIELD_SENDER = "<field name=\"sender\" value=\"";
    private static final String FIELD_RECEIVER = "<field name=\"receiver\" value=\"";
    private static final String FIELD_SIGNAL = "<field name=\"signal\" value=\"";
    private static final String FIELD_END = "\" type=\"string\" />";
    private static final String EVENT_END = "</event>";
    private static final String TRACE_END = "</trace>";
    private static final String PROJECT_NAME = "TestForFiltering";
    private static final String DISABLE_PRINTING_KEY = "org.eclipse.swt.internal.gtk.disablePrinting";
    private static SWTWorkbenchBot fBot;
    private static File fFileLocation;
    private static String fDisablePrinting;

    private static String makeEvent(int ts, String eventName, String send, String recv, String signal) {
        return EVENT_BEGIN + Integer.toString(ts) + EVENT_MIDDLE1 + eventName + EVENT_MIDDLE2 + FIELD_SENDER + send + FIELD_END + FIELD_RECEIVER + recv + FIELD_END + FIELD_SIGNAL + signal + FIELD_END + EVENT_END + "\n";
    }

    @BeforeClass
    public static void init() throws IOException {
        SWTBotUtils.initialize();
        Thread.currentThread().setName("SWTBot Thread");
        SWTBotPreferences.TIMEOUT = 20000L;
        fBot = new SWTWorkbenchBot();
        WaitUtils.waitForJobs();
        fFileLocation = File.createTempFile("sample", ".xml");
        String[] eventNames = new String[]{"test:SEND", "test:RECEIVE"};
        String[] targets = new String[]{"peer1", "peer2"};
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedRandomAccessFile braf = new BufferedRandomAccessFile(fFileLocation, "rw");){
            braf.writeBytes(TRACE_START);
            int i = 0;
            while (i < 20000) {
                braf.writeBytes(SDViewTest.makeEvent(i * 100, eventNames[i % 2], targets[i % 2], targets[(i + 1) % 2], Integer.toString(i % 2 + 1000)));
                ++i;
            }
            braf.writeBytes(TRACE_END);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        fDisablePrinting = System.getProperty(DISABLE_PRINTING_KEY);
        System.setProperty(DISABLE_PRINTING_KEY, "true");
    }

    @Before
    public void beforeTest() {
        SWTBotUtils.createProject(PROJECT_NAME);
        SWTBotTreeItem treeItem = SWTBotUtils.selectTracesFolder(fBot, PROJECT_NAME);
        Assert.assertNotNull((Object)treeItem);
        SWTBotUtils.openTrace(PROJECT_NAME, fFileLocation.getAbsolutePath(), XMLSTUB_ID);
        SWTBotUtils.openView(UML2DVIEW_ID);
    }

    @AfterClass
    public static void cleanUp() {
        SWTBotUtils.closeViewById(UML2DVIEW_ID, fBot);
        fFileLocation.delete();
        if (fDisablePrinting == null) {
            System.getProperties().remove(DISABLE_PRINTING_KEY);
        } else {
            System.setProperty(DISABLE_PRINTING_KEY, fDisablePrinting);
        }
    }

    @After
    public void tearDown() {
        fBot.closeAllEditors();
        SWTBotUtils.deleteProject(PROJECT_NAME, fBot);
    }

    @Test
    public void testSDView() {
        SWTBotView viewBot = fBot.viewById(UML2DVIEW_ID);
        SWTBotCanvas timeCompressionBar = viewBot.bot().canvas(0);
        SWTBotCanvas sdWidget = viewBot.bot().canvas(1);
        Assert.assertNotNull((Object)viewBot);
        viewBot.setFocus();
        WaitUtils.waitForJobs();
        List viewButtons = viewBot.getToolbarButtons();
        ArrayList<String> titles = new ArrayList<String>();
        for (SWTBotToolbarButton buttonBot : viewButtons) {
            titles.add(buttonBot.getToolTipText());
        }
        int commandKeyChar = 8984;
        String findShortcut = (Platform.getOS().equals("macosx") ? Character.valueOf('\u2318') : "Ctrl+") + "F";
        Object[] expected = new String[]{"Reset zoom factor", "Select", "Zoom in the diagram", "Zoom out the diagram", "Go to next page", "Go to previous page", "Go to first page", "Go to last page", "Find... (" + findShortcut + ")"};
        Assert.assertArrayEquals((String)"Buttons", (Object[])expected, (Object[])titles.toArray(new String[0]));
        SDView view = (SDView)viewBot.getViewReference().getPart(false);
        ISDAdvancedPagingProvider pagingProvider = (ISDAdvancedPagingProvider)view.getSDPagingProvider();
        Frame frame = view.getFrame();
        Assert.assertEquals((long)2L, (long)frame.lifeLinesCount());
        timeCompressionBar.click();
        viewBot.toolbarButton("Select").click();
        sdWidget.click(0, 0);
        viewBot.toolbarButton("Zoom in the diagram").click();
        sdWidget.click();
        sdWidget.click();
        viewBot.toolbarButton("Zoom out the diagram").click();
        sdWidget.click();
        viewBot.toolbarButton("Reset zoom factor").click();
        sdWidget.click();
        viewBot.viewMenu("Select").click();
        sdWidget.click(0, 0);
        viewBot.viewMenu("Zoom in").click();
        sdWidget.click();
        sdWidget.click();
        viewBot.viewMenu("Zoom out").click();
        sdWidget.click();
        viewBot.viewMenu("Reset zoom factor").click();
        sdWidget.click();
        Assert.assertEquals((long)0L, (long)pagingProvider.currentPage());
        viewBot.toolbarButton("Find... (" + findShortcut + ")").click();
        SWTBot findDialogBot = fBot.shell("Sequence Diagram Find").bot();
        findDialogBot.comboBox().setText("peer2");
        findDialogBot.checkBox("Lifeline").select();
        findDialogBot.checkBox("Interaction").deselect();
        findDialogBot.button("Find").click();
        findDialogBot.button("Close").click();
        SWTBotUtils.waitUntil(f -> f.getLifeline(1).isSelected(), frame, "Did not find lifeline");
        Assert.assertEquals((long)0L, (long)pagingProvider.currentPage());
        viewBot.setFocus();
        viewBot.toolbarButton("Find... (" + findShortcut + ")").click();
        findDialogBot = fBot.shell("Sequence Diagram Find").bot();
        findDialogBot.comboBox().setText("1001");
        findDialogBot.checkBox("Lifeline").deselect();
        findDialogBot.checkBox("Interaction").select();
        findDialogBot.button("Find").click();
        findDialogBot.button("Close").click();
        SWTBotUtils.waitUntil(f -> f.getSyncMessage(1).isSelected(), frame, "Did not find interaction");
        viewBot.viewMenu("Hide Patterns...").click();
        SWTBot hideDialogBot = fBot.shell("Sequence Diagram Hide Patterns").bot();
        hideDialogBot.button("Add...").click();
        SWTBot definitionBot = fBot.shell("Definition of Hide Pattern").bot();
        definitionBot.comboBox().setText("peer2");
        definitionBot.checkBox("Lifeline").select();
        definitionBot.checkBox("Interaction").deselect();
        definitionBot.button("Create").click();
        hideDialogBot.button("OK").click();
        SWTBotUtils.waitUntil(v -> v.getFrame().lifeLinesCount() == 1, view, "Did not hide lifeline");
        viewBot.viewMenu("Hide Patterns...").click();
        hideDialogBot = fBot.shell("Sequence Diagram Hide Patterns").bot();
        hideDialogBot.table().select(new String[]{"hide peer2 [Lifeline]"});
        hideDialogBot.button("Remove").click();
        hideDialogBot.button("OK").click();
        SWTBotUtils.waitUntil(v -> v.getFrame().lifeLinesCount() == 2, view, "Did not show lifeline");
        viewBot.viewMenu("Configure Min Max...").click();
        SWTBot configurationBot = fBot.shell("TimeCompression bar configuration").bot();
        configurationBot.textWithLabel("Max time").setText("200");
        configurationBot.button("OK").click();
        viewBot.viewMenu("Configure Min Max...").click();
        configurationBot = fBot.shell("TimeCompression bar configuration").bot();
        configurationBot.button("Default").click();
        configurationBot.button("OK").click();
        Assert.assertEquals((long)0L, (long)pagingProvider.currentPage());
        viewBot.toolbarButton("Go to next page").click();
        SWTBotUtils.waitUntil(pp -> pp.currentPage() == 1, pagingProvider, "Did not change page");
        viewBot.toolbarButton("Go to previous page").click();
        SWTBotUtils.waitUntil(pp -> pp.currentPage() == 0, pagingProvider, "Did not change page");
        viewBot.toolbarButton("Go to last page").click();
        SWTBotUtils.waitUntil(pp -> pp.currentPage() == 1, pagingProvider, "Did not change page");
        viewBot.toolbarButton("Go to first page").click();
        SWTBotUtils.waitUntil(pp -> pp.currentPage() == 0, pagingProvider, "Did not change page");
        Assert.assertEquals((long)0L, (long)pagingProvider.currentPage());
        viewBot.viewMenu("Next page").click();
        SWTBotUtils.waitUntil(pp -> pp.currentPage() == 1, pagingProvider, "Did not change page");
        viewBot.viewMenu("Previous page").click();
        SWTBotUtils.waitUntil(pp -> pp.currentPage() == 0, pagingProvider, "Did not change page");
        viewBot.viewMenu("Last page").click();
        SWTBotUtils.waitUntil(pp -> pp.currentPage() == 1, pagingProvider, "Did not change page");
        viewBot.viewMenu("First page").click();
        SWTBotUtils.waitUntil(pp -> pp.currentPage() == 0, pagingProvider, "Did not change page");
        viewBot.viewMenu("Pages...").click();
        SWTBot pagesBot = fBot.shell("Sequence Diagram Pages").bot();
        pagesBot.text().setText("2");
        pagesBot.button("OK").click();
        SWTBotUtils.waitUntil(pp -> pp.currentPage() == 1, pagingProvider, "Did not change page");
    }

    @Test
    public void testSDPrintUi() {
        SWTBotView viewBot = fBot.viewById(UML2DVIEW_ID);
        Assert.assertNotNull((Object)viewBot);
        viewBot.setFocus();
        WaitUtils.waitForJobs();
        SWTBotCanvas canvas = viewBot.bot().canvas(1);
        canvas.setFocus();
        canvas.pressShortcut(new KeyStroke[]{Keystrokes.CTRL, KeyStroke.getInstance((int)80)});
        SWTBotShell printShell = fBot.shell("Print");
        Assert.assertNotNull((Object)printShell);
        SWTBot printBot = printShell.bot();
        printBot.radio("Use current zoom").click();
        SWTBotRadio allPages = printBot.radio("All pages");
        SWTBotRadio currentView = printBot.radio("Current view");
        allPages.click();
        currentView.click();
        printBot.radio("Number of horizontal pages:").click();
        SWTBotText horizontalPagesText = printBot.text(0);
        SWTBotUtils.waitUntil(t -> t.getText().equals(String.valueOf(1)), horizontalPagesText, "Number of horizontal pages should be 1");
        horizontalPagesText.setText("2");
        SWTBotUtils.waitUntil(t -> t.getText().equals(String.valueOf(2)), horizontalPagesText, "Number of horizontal pages should be 2");
        Assert.assertFalse((boolean)currentView.isEnabled());
        SWTBotText totalPagesText = printBot.textWithLabel("Total number of pages:");
        printBot.radio("Number of vertical pages:").click();
        SWTBotText verticalPagesText = printBot.text(1);
        SWTBotUtils.waitUntil(t -> t.getText().equals(String.valueOf(1)), verticalPagesText, "Number of vertical pages should be 1");
        SWTBotUtils.waitUntil(t -> t.getText().equals(String.valueOf(1)), totalPagesText, "Total number of pages should be 1");
        verticalPagesText.setText("2");
        SWTBotUtils.waitUntil(t -> t.getText().equals(String.valueOf(2)), verticalPagesText, "Number of vertical pages should be 2");
        Assert.assertFalse((boolean)currentView.isEnabled());
        printBot.radio("Selected pages").click();
        Assert.assertFalse((boolean)currentView.isEnabled());
        printBot.radio("From page").click();
        SWTBotText fromText = printBot.text(3);
        SWTBotText toText = printBot.text(4);
        SWTBotUtils.waitUntil(t -> t.getText().isEmpty(), fromText, "From text is not empty");
        SWTBotUtils.waitUntil(t -> t.getText().isEmpty(), toText, "To text is not empty");
        fromText.setText("2");
        toText.setText("3");
        SWTBotUtils.waitUntil(t -> t.getText().equals(String.valueOf(2)), fromText, "From text is not 2");
        SWTBotUtils.waitUntil(t -> t.getText().equals(String.valueOf(3)), toText, "To text is not 3");
        Assert.assertFalse((boolean)currentView.isEnabled());
        printBot.button("Cancel").click();
        printBot.waitUntil(Conditions.shellCloses((SWTBotShell)printShell));
    }
}

