/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.gen.autojava.launcher.popupMenus;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.engine.service.AbstractAcceleoGenerator;
import org.eclipse.acceleo.engine.utils.AcceleoLaunchingUtil;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.umlgen.gen.autojava.launcher.Activator;
import org.eclipse.umlgen.gen.autojava.main.Uml2autojava;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGenAutoJavaHandler
extends AbstractHandler {
    protected List<IFile> files;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            this.files = ((IStructuredSelection)selection).toList();
        }
        if (this.files != null) {
            GenRunner operation = new GenRunner();
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)operation);
            }
            catch (InvocationTargetException e) {
                Status status = new Status(4, "org.eclipse.umlgen.gen.autojava.launcher", e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
            catch (InterruptedException e) {
                Status status = new Status(4, "org.eclipse.umlgen.gen.autojava.launcher", e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        return null;
    }

    protected List<? extends Object> getArguments() {
        return new ArrayList();
    }

    private void generate(IProgressMonitor monitor, AbstractAcceleoGenerator generator) {
        if (!generator.getTargetFolder().exists()) {
            generator.getTargetFolder().mkdirs();
        }
        monitor.subTask("Loading...");
        monitor.worked(1);
        String generationID = AcceleoLaunchingUtil.computeUIProjectID((String)"org.eclipse.umlgen.gen.autojava", (String)this.getModuleQualifiedName(), (String)generator.getModel().eResource().getURI().toString(), (String)generator.getTargetFolder().getAbsolutePath(), new ArrayList());
        generator.setGenerationID(generationID);
        try {
            generator.doGenerate(BasicMonitor.toMonitor((IProgressMonitor)monitor));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File getFileFromPath(IFile model, String workspaceRelativePath) {
        Path tempPath = new Path(workspaceRelativePath);
        String path = tempPath.isAbsolute() ? workspaceRelativePath : model.getWorkspace().getRoot().getLocation().append((IPath)new Path(workspaceRelativePath)).toString();
        return new File(path);
    }

    protected abstract Uml2autojava getGenerator(URI var1, String var2, File var3) throws IOException;

    protected abstract String getModuleQualifiedName();

    private class GenRunner
    implements IRunnableWithProgress {
        private GenRunner() {
        }

        public void run(IProgressMonitor monitor) {
            try {
                for (IFile model : AbstractGenAutoJavaHandler.this.files) {
                    URI modelURI = URI.createPlatformResourceURI((String)model.getFullPath().toString(), (boolean)true);
                    try {
                        try {
                            String sTarget = model.getPersistentProperty(new QualifiedName("", "OUTPUT_PATH_AUTOJAVA_COMP"));
                            String sDecorators = model.getPersistentProperty(new QualifiedName("", "COMMUNICATION_PARAMETERING"));
                            File target = AbstractGenAutoJavaHandler.this.getFileFromPath(model, sTarget);
                            Uml2autojava generator = AbstractGenAutoJavaHandler.this.getGenerator(modelURI, sDecorators, target);
                            AbstractGenAutoJavaHandler.this.generate(monitor, (AbstractAcceleoGenerator)generator);
                        }
                        catch (IOException e) {
                            Status status = new Status(4, "org.eclipse.umlgen.gen.autojava.launcher", e.getMessage(), (Throwable)e);
                            Activator.getDefault().getLog().log((IStatus)status);
                            model.getProject().refreshLocal(2, monitor);
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        model.getProject().refreshLocal(2, monitor);
                        throw throwable;
                    }
                    model.getProject().refreshLocal(2, monitor);
                }
            }
            catch (CoreException e) {
                Status status = new Status(4, "org.eclipse.umlgen.gen.autojava.launcher", e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
    }
}

