/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.rules;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra.examples.cps.deployment.BehaviorState;
import org.eclipse.viatra.examples.cps.deployment.DeploymentBehavior;
import org.eclipse.viatra.examples.cps.deployment.DeploymentElement;
import org.eclipse.viatra.examples.cps.traceability.CPS2DeploymentTrace;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.queries.DeletedStateMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.rules.AbstractRule;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.transformation.evm.api.ActivationLifeCycle;
import org.eclipse.viatra.transformation.evm.api.Job;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.specific.Jobs;
import org.eclipse.viatra.transformation.evm.specific.Lifecycles;
import org.eclipse.viatra.transformation.evm.specific.Rules;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class StateRemoval
extends AbstractRule<DeletedStateMatch> {
    public StateRemoval(ViatraQueryEngine engine) {
        super(engine);
    }

    @Override
    public RuleSpecification<DeletedStateMatch> getSpecification() {
        Job<DeletedStateMatch> _appearedJob = this.getAppearedJob();
        return Rules.newMatcherRuleSpecification((IQuerySpecification)this.cpsXformM2M.getDeletedState(), (ActivationLifeCycle)Lifecycles.getDefault((boolean)false, (boolean)false), Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Job[]{_appearedJob})));
    }

    private Job<DeletedStateMatch> getAppearedJob() {
        IMatchProcessor _function = match -> {
            boolean _not;
            DeploymentElement _depState = match.getDepState();
            BehaviorState depState = (BehaviorState)_depState;
            String stateId = depState.getDescription();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Removing state with ID: ");
            _builder.append(stateId);
            this.logger.debug((Object)_builder);
            Set<DeploymentBehavior> stateMachines = this.cpsXformM2M.getBehaviorState(this.engine).getAllValuesOfdepBehavior(depState);
            boolean _isEmpty = stateMachines.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                DeploymentBehavior sm = (DeploymentBehavior)IterableExtensions.head(stateMachines);
                EList _states = sm.getStates();
                _states.remove((Object)depState);
                BehaviorState _current = sm.getCurrent();
                boolean _equals = Objects.equal((Object)_current, (Object)depState);
                if (_equals) {
                    sm.setCurrent(null);
                }
            }
            CPS2DeploymentTrace smTrace = match.getTrace();
            EList _deploymentElements = smTrace.getDeploymentElements();
            _deploymentElements.remove((Object)depState);
            boolean _isEmpty_1 = smTrace.getDeploymentElements().isEmpty();
            if (_isEmpty_1) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Removing empty trace");
                this.logger.trace((Object)_builder_1);
                EList _traces = this.getRootMapping().getTraces();
                _traces.remove((Object)smTrace);
            }
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("Removed state with ID: ");
            _builder_2.append(stateId);
            this.logger.debug((Object)_builder_2);
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.CREATED, (IMatchProcessor)_function);
    }
}

