/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryregistry;

import com.google.inject.Inject;
import com.google.inject.Injector;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.handlers.CollapseAllHandler;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.viatra.query.runtime.registry.QuerySpecificationRegistry;
import org.eclipse.viatra.query.tooling.ui.browser.ViatraQueryToolingBrowserPlugin;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeContentProvider;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeInput;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeLabelProvider;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeSource;
import org.eclipse.viatra.query.tooling.ui.queryregistry.index.XtextIndexBasedRegistryUpdater;
import org.eclipse.viatra.query.tooling.ui.queryregistry.index.XtextIndexBasedRegistryUpdaterFactory;
import org.eclipse.viatra.query.tooling.ui.queryresult.handlers.LoadQueriesHandler;
import org.eclipse.viatra.query.tooling.ui.util.CommandInvokingDoubleClickListener;

public class QueryRegistryView
extends ViewPart
implements ITabbedPropertySheetPageContributor {
    @Inject
    private Injector injector;
    public static final String ID = "org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryView";
    private TreeViewer queryTreeViewer;
    private QueryRegistryTreeInput queryRegistryTreeInput;
    private XtextIndexBasedRegistryUpdater updater;
    private CollapseAllHandler collapseHandler;
    private Job initializerJob = new Job("Initializing Query Registry"){

        protected IStatus run(IProgressMonitor monitor) {
            QueryRegistryView.this.updater = XtextIndexBasedRegistryUpdaterFactory.INSTANCE.getUpdater(QuerySpecificationRegistry.getInstance());
            QueryRegistryView.this.queryRegistryTreeInput = new QueryRegistryTreeInput(QuerySpecificationRegistry.getInstance());
            QueryRegistryView.this.getViewSite().getShell().getDisplay().asyncExec(() -> QueryRegistryView.this.queryTreeViewer.setInput((Object)QueryRegistryView.this.queryRegistryTreeInput));
            return Status.OK_STATUS;
        }
    };

    public void dispose() {
        this.collapseHandler.dispose();
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout(256));
        Composite queryRegistryContainer = new Composite(parent, 0);
        queryRegistryContainer.setLayout((Layout)new GridLayout(1, false));
        this.initializeQueryTreeViewer(queryRegistryContainer);
        this.initializerJob.setUser(false);
        this.initializerJob.schedule();
    }

    private void initializeQueryTreeViewer(Composite queryRegistryContainer) {
        PatternFilter patternFilter = new PatternFilter();
        patternFilter.setIncludeLeadingWildcard(true);
        FilteredTree filteredTree = new FilteredTree(queryRegistryContainer, 268437506, patternFilter, true);
        this.queryTreeViewer = filteredTree.getViewer();
        filteredTree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.queryTreeViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof QueryRegistryTreeSource && e2 instanceof QueryRegistryTreeSource) {
                    QueryRegistryTreeSource source1 = (QueryRegistryTreeSource)e1;
                    QueryRegistryTreeSource source2 = (QueryRegistryTreeSource)e2;
                    return source1.getSourceIdentifier().compareTo(source2.getSourceIdentifier());
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.queryTreeViewer.setLabelProvider((IBaseLabelProvider)new QueryRegistryTreeLabelProvider());
        this.queryTreeViewer.setContentProvider((IContentProvider)new QueryRegistryTreeContentProvider());
        CommandInvokingDoubleClickListener loadQueriesListener = new CommandInvokingDoubleClickListener("org.eclipse.viatra.query.tooling.ui.result.loadqueries", "Exception when activating load queries!"){

            protected void handleException(CommandException e) {
                LoadQueriesHandler.queryLoadingFailed(QueryRegistryView.this.getSite().getShell());
            }
        };
        this.injector.injectMembers((Object)loadQueriesListener);
        this.queryTreeViewer.addDoubleClickListener((IDoubleClickListener)loadQueriesListener);
        int operations = 3;
        Transfer[] transferTypes = new Transfer[]{LocalTransfer.getInstance()};
        this.queryTreeViewer.addDragSupport(operations, transferTypes, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                ISelection selection = QueryRegistryView.this.queryTreeViewer.getSelection();
                if (LocalTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = selection;
                }
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.queryTreeViewer);
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.collapseHandler = new CollapseAllHandler((AbstractTreeViewer)this.queryTreeViewer);
        handlerService.activateHandler("org.eclipse.ui.navigate.collapseAll", (IHandler)this.collapseHandler);
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                mgr.add((IContributionItem)new GroupMarker("additions"));
            }
        });
        Control control = this.queryTreeViewer.getControl();
        control.setMenu(menuManager.createContextMenu(control));
        this.getSite().registerContextMenu(ID, menuManager, (ISelectionProvider)this.queryTreeViewer);
    }

    public void setFocus() {
        this.queryTreeViewer.getControl().setFocus();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return adapter.cast(new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this));
        }
        return super.getAdapter(adapter);
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    public void resetView() {
        BusyIndicator.showWhile((Display)this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    QueryRegistryView.this.initializerJob.join();
                    QueryRegistryView.this.updater.disconnectIndexFromRegistry();
                    QueryRegistryView.this.updater.connectIndexToRegistry(QuerySpecificationRegistry.getInstance());
                }
                catch (InterruptedException e) {
                    String logMessage = "Error while resetting Query Registry: " + e.getMessage();
                    ViatraQueryToolingBrowserPlugin.getDefault().getLog().log((IStatus)new Status(4, ViatraQueryToolingBrowserPlugin.getDefault().getBundle().getSymbolicName(), logMessage, (Throwable)e));
                    Thread.currentThread().interrupt();
                }
            }
        });
    }

    public void collapseAll() {
        this.queryTreeViewer.collapseAll();
    }
}

