/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.buffers;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.viatra2.buffers.IBufferStoreListener;
import org.eclipse.viatra2.core.IModelSpace;

public class BufferStore {
    private static BufferStore _instance = new BufferStore();
    private HashMap<IModelSpace, HashMap<String, StringWriter>> core_buffers = new HashMap();
    private HashMap<IModelSpace, HashMap<String, FileWriter>> file_buffers = new HashMap();
    private List<IBufferStoreListener> listeners = new ArrayList<IBufferStoreListener>();

    public static synchronized void removeBuffer(IModelSpace m, String pURI) {
        HashMap<String, FileWriter> _target;
        String key = pURI;
        HashMap<String, StringWriter> target = BufferStore._instance.core_buffers.get(m);
        if (target != null) {
            target.remove(key);
        }
        if ((_target = BufferStore._instance.file_buffers.get(m)) != null) {
            _target.remove(key);
        }
    }

    public static synchronized void removeFileBuffers(IModelSpace m) {
        BufferStore._instance.file_buffers.remove(m);
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            m.getFramework().getLogger().fatal(e.getMessage());
        }
    }

    public static synchronized void clearBuffer(IModelSpace m, String pURI) throws URISyntaxException {
        URI uri = new URI(pURI);
        String key = pURI;
        if ("core".equals(uri.getScheme())) {
            StringWriter ret;
            HashMap<String, StringWriter> target = BufferStore._instance.core_buffers.get(m);
            if (target == null) {
                target = new HashMap();
                BufferStore._instance.core_buffers.put(m, target);
            }
            if ((ret = target.get(key)) != null) {
                ret.getBuffer().delete(0, ret.getBuffer().length());
            }
        } else if ("file".equals(uri.getScheme())) {
            FileWriter ret;
            HashMap<String, FileWriter> target = BufferStore._instance.file_buffers.get(m);
            if (target == null) {
                target = new HashMap();
                BufferStore._instance.file_buffers.put(m, target);
            }
            if ((ret = target.get(key)) != null) {
                String path = String.valueOf(uri.getAuthority()) + uri.getPath();
                IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
                if (ifile.exists()) {
                    try {
                        ifile.setContents((InputStream)new StringBufferInputStream(""), true, false, null);
                    }
                    catch (Exception e) {
                        m.getFramework().getLogger().error("Error encountered while attempting to clear file buffer: " + e.getMessage());
                        m.getFramework().getLogger().printStackTrace(e);
                    }
                }
            }
        } else if ("os".equals(uri.getScheme())) {
            String path;
            File f;
            FileWriter ret;
            HashMap<String, FileWriter> target = BufferStore._instance.file_buffers.get(m);
            if (target == null) {
                target = new HashMap();
                BufferStore._instance.file_buffers.put(m, target);
            }
            if ((ret = target.get(key)) != null && (f = new File(path = String.valueOf(uri.getAuthority()) + uri.getPath())).exists()) {
                try {
                    FileWriter fw = new FileWriter(f, false);
                    fw.write("");
                    fw.flush();
                    fw.close();
                }
                catch (Exception e) {
                    m.getFramework().getLogger().error("Error encountered while attempting to clear os buffer: " + e.getMessage());
                    m.getFramework().getLogger().printStackTrace(e);
                }
            }
        }
    }

    public static synchronized Writer getBuffer(IModelSpace m, String pURI, boolean append) throws URISyntaxException, IOException {
        URI uri = new URI(pURI);
        String key = pURI;
        if ("core".equals(uri.getScheme())) {
            StringWriter ret;
            HashMap<String, StringWriter> target = BufferStore._instance.core_buffers.get(m);
            if (target == null) {
                target = new HashMap();
                BufferStore._instance.core_buffers.put(m, target);
            }
            if ((ret = target.get(key)) == null) {
                ret = new StringWriter();
                target.put(key, ret);
                BufferStore.notifyAdded(key);
            }
            return ret;
        }
        if ("file".equals(uri.getScheme())) {
            FileWriter ret;
            String path = String.valueOf(uri.getAuthority()) + uri.getPath();
            HashMap<String, FileWriter> target = BufferStore._instance.file_buffers.get(m);
            if (target == null) {
                target = new HashMap();
                BufferStore._instance.file_buffers.put(m, target);
            }
            if ((ret = target.get(key)) == null) {
                IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
                IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(uri.getAuthority());
                NullProgressMonitor mon = new NullProgressMonitor();
                try {
                    if (!p.exists()) {
                        p.create((IProgressMonitor)mon);
                    }
                    p.open((IProgressMonitor)mon);
                }
                catch (CoreException coreException) {
                    throw new IOException("Target project cannot be created/opened");
                }
                try {
                    String[] segments = uri.getPath().split("/");
                    if (segments.length > 2) {
                        IFolder curr = null;
                        int i = 1;
                        while (i < segments.length - 1) {
                            if (!(curr = curr == null ? p.getFolder(segments[i]) : curr.getFolder(segments[i])).exists()) {
                                curr.create(true, true, (IProgressMonitor)mon);
                            }
                            ++i;
                        }
                    }
                }
                catch (CoreException coreException) {
                    throw new IOException("Target folder structure cannot be created");
                }
                ret = new FileWriter(new File(ifile.getLocation().toOSString()), append);
                target.put(key, ret);
            }
            return ret;
        }
        if ("os".equals(uri.getScheme())) {
            FileWriter ret;
            String path = String.valueOf(uri.getAuthority()) + uri.getPath();
            HashMap<String, FileWriter> target = BufferStore._instance.file_buffers.get(m);
            if (target == null) {
                target = new HashMap();
                BufferStore._instance.file_buffers.put(m, target);
            }
            if ((ret = target.get(key)) == null) {
                File f = new File(path);
                if (!f.exists()) {
                    String par = f.getParent();
                    File parf = new File(par);
                    if (!parf.exists()) {
                        parf.mkdirs();
                    }
                    f.createNewFile();
                }
                ret = new FileWriter(f, append);
                target.put(key, ret);
            }
            return ret;
        }
        return null;
    }

    public static synchronized Writer getBuffer(IModelSpace m, String pURI) throws URISyntaxException, IOException {
        return BufferStore.getBuffer(m, pURI, true);
    }

    public static synchronized Set<Map.Entry<String, StringWriter>> getAllCoreBuffers(IModelSpace m) {
        if (BufferStore._instance.core_buffers.get(m) != null) {
            return BufferStore._instance.core_buffers.get(m).entrySet();
        }
        return null;
    }

    public static synchronized Set<Map.Entry<String, FileWriter>> getAllFileBuffers(IModelSpace m) {
        if (BufferStore._instance.file_buffers.get(m) != null) {
            return BufferStore._instance.file_buffers.get(m).entrySet();
        }
        return null;
    }

    public static synchronized void addListener(IBufferStoreListener l) {
        BufferStore._instance.listeners.add(l);
    }

    public static synchronized void removeListener(IBufferStoreListener l) {
        BufferStore._instance.listeners.remove(l);
    }

    private static void notifyAdded(String key) {
        for (IBufferStoreListener l : BufferStore._instance.listeners) {
            l.bufferAdded(key);
        }
    }

    private static void notifyRemoved(String key) {
        for (IBufferStoreListener l : BufferStore._instance.listeners) {
            l.bufferRemoved(key);
        }
    }
}

