/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.core.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.viatra2.core.ICoreNotificationListener;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.core.INotificationManager;
import org.eclipse.viatra2.core.notification.ICoreNotificationObject;
import org.eclipse.viatra2.core.simple.SimpleModelElement;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.logger.Logger;

public class SimpleNotificationManager
implements INotificationManager {
    public static final int UNDO_SUPPORT = 0;
    public static final int TRANSACTION_SUPPORT = 1;
    public static final int CORE_SUPPORT = 2;
    public static final int INTERPRETER_SUPPORT = 3;
    public static final int GUI_SUPPORT = 4;
    boolean notificationEnabled = true;
    List<ICoreNotificationListener> allListeners = new ArrayList<ICoreNotificationListener>();
    int notificationLevel = 0;
    Logger logger;
    IModelSpace modelSpace;
    protected int no_atom_depth = 0;
    boolean skip_note_block = false;

    public void init(Logger l, IModelSpace m) throws VPMRuntimeException {
        this.modelSpace = m;
    }

    @Override
    public void enableNotifications() {
        this.notificationEnabled = true;
    }

    @Override
    public void disableNotifications() {
        this.notificationEnabled = false;
    }

    @Override
    public boolean isNotificationEnabled() {
        return this.notificationEnabled;
    }

    @Override
    public void setNotificationLevel(int l) {
        this.notificationLevel = l;
    }

    @Override
    public int getNotificationLevel() {
        return this.notificationLevel;
    }

    @Override
    public void addAllListener(ICoreNotificationListener l) {
        this.allListeners.add(l);
    }

    @Override
    public void removeAllListener(ICoreNotificationListener l) {
        this.allListeners.remove(l);
    }

    @Override
    public Collection<ICoreNotificationListener> getListenAllListeners() {
        return this.allListeners;
    }

    protected void sendNotification(ICoreNotificationObject notification) {
        switch (notification.getActionTypeEnum()) {
            case ACTION_SKIP_NOTIFICATIONS_START: {
                this.skip_note_block = true;
                return;
            }
            case ACTION_SKIP_NOTIFICATIONS_END: {
                this.skip_note_block = false;
                return;
            }
        }
        if (this.skip_note_block) {
            return;
        }
        switch (notification.getActionTypeEnum()) {
            case ACTION_ATOMIC_STEP_READY: {
                if (this.no_atom_depth <= 0) break;
                return;
            }
            case ACTION_MORE_ATOMICS_TO_ONE_ATOM_START: {
                ++this.no_atom_depth;
                return;
            }
            case ACTION_MORE_ATOMICS_TO_ONE_ATOM_END: {
                --this.no_atom_depth;
                if (this.no_atom_depth < 0) {
                    throw new RuntimeException("error internal");
                }
                return;
            }
        }
        if (this.notificationEnabled) {
            this.notifyListeners(notification);
        }
    }

    protected void notifyListeners(ICoreNotificationObject notification) {
        int level = this.getNotificationLevel();
        for (ICoreNotificationListener listener : notification.getListeners()) {
            if (level < listener.getListenerCategory()) continue;
            listener.actionPerformed(notification);
        }
        for (ICoreNotificationListener l : new ArrayList<ICoreNotificationListener>(this.getListenAllListeners())) {
            if (level < l.getListenerCategory()) continue;
            l.actionPerformed(notification);
        }
    }

    @Override
    public void addNotificationListener(IModelElement me, ICoreNotificationListener l) {
        ((SimpleModelElement)me).addNotificationListener(l);
    }

    @Override
    public void removeNotificationListener(IModelElement me, ICoreNotificationListener l) {
        ((SimpleModelElement)me).removeNotificationListener(l);
    }

    @Override
    public Collection<ICoreNotificationListener> getNotificationListeners(IModelElement me) {
        return ((SimpleModelElement)me).getNotificationListeners();
    }
}

