/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.core.tracebased;

import org.eclipse.viatra2.core.EDeleteSemantics;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.core.notification.ICoreNotificationObject;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectCreateEntity;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectCreateInstanceOf;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectCreateRelation;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectCreateSupertypeOf;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteContainment;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteEntity;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteInstanceOf;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteRelation;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteSupertypeOf;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectMoveTo;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetName;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetRelationFrom;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetRelationTo;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetValue;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetViewInfo;
import org.eclipse.viatra2.core.notification.NotificationType;
import org.eclipse.viatra2.core.simple.SimpleEntity;
import org.eclipse.viatra2.core.simple.SimpleModelElement;
import org.eclipse.viatra2.core.simple.SimpleRelation;
import org.eclipse.viatra2.core.tracebased.TraceException;
import org.eclipse.viatra2.core.tracebased.TraceModelManager;
import org.eclipse.viatra2.core.tracebased.TraceTreeManager;
import org.eclipse.viatra2.errors.VPMCoreException;
import org.eclipse.viatra2.errors.VPMCoreNullParameterException;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.logger.Logger;

public class TraceNotificationProcessor {
    private TraceModelManager mManager;
    private Logger logger;

    public TraceNotificationProcessor(TraceTreeManager manager, IFramework fw, IModelManager mManager) {
        this.mManager = (TraceModelManager)mManager;
        this.logger = fw.getLogger();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean doExecuteEvent(ICoreNotificationObject note) throws TraceException {
        try {
            NotificationType action = note.getActionTypeEnum();
            switch (action) {
                case ACTION_ATOMIC_STEP_READY: {
                    return false;
                }
                case ACTION_CREATE_ENTITY: {
                    ICoreNotificationObjectCreateEntity _note = (ICoreNotificationObjectCreateEntity)note;
                    IEntity ent = _note.getCreated();
                    this.mManager.undoCreateEntity((SimpleEntity)ent, (SimpleEntity)_note.getContainer());
                    this.mManager.undoCreateContainment((SimpleEntity)_note.getContainer(), (SimpleEntity)ent);
                    return true;
                }
                case ACTION_DELETE_ENTITY: {
                    ICoreNotificationObjectDeleteEntity _note1 = (ICoreNotificationObjectDeleteEntity)note;
                    IEntity ent1 = _note1.getDeleted();
                    this.mManager.deleteEntity(ent1, EDeleteSemantics.DELETE_SEMANTICS_FORCE);
                    return true;
                }
                case ACTION_CREATE_RELATION: {
                    ICoreNotificationObjectCreateRelation _note2 = (ICoreNotificationObjectCreateRelation)note;
                    IRelation rel = _note2.getNewRelation();
                    this.mManager.undoCreateRelation((SimpleRelation)rel, (SimpleModelElement)_note2.getFrom(), (SimpleModelElement)_note2.getTo());
                    return true;
                }
                case ACTION_DELETE_RELATION: {
                    ICoreNotificationObjectDeleteRelation _note3 = (ICoreNotificationObjectDeleteRelation)note;
                    this.mManager.deleteRelation(_note3.getDeleted(), EDeleteSemantics.DELETE_SEMANTICS_FORCE);
                    return true;
                }
                case ACTION_CREATE_INSTANCEOF: {
                    ICoreNotificationObjectCreateInstanceOf _note4 = (ICoreNotificationObjectCreateInstanceOf)note;
                    SimpleModelElement sup = (SimpleModelElement)_note4.getType();
                    SimpleModelElement sub = (SimpleModelElement)_note4.getInstance();
                    this.mManager.newInstanceOfEditor(sup, sub);
                    return true;
                }
                case ACTION_DELETE_INSTANCEOF: {
                    ICoreNotificationObjectDeleteInstanceOf _note5 = (ICoreNotificationObjectDeleteInstanceOf)note;
                    SimpleModelElement sup = (SimpleModelElement)_note5.getType();
                    SimpleModelElement sub = (SimpleModelElement)_note5.getInstance();
                    this.mManager.deleteInstanceOfEditor(sup, sub);
                    return true;
                }
                case ACTION_CREATE_SUPERTYPEOF: {
                    ICoreNotificationObjectCreateSupertypeOf _note6 = (ICoreNotificationObjectCreateSupertypeOf)note;
                    SimpleModelElement sup = (SimpleModelElement)_note6.getSuper();
                    SimpleModelElement sub = (SimpleModelElement)_note6.getSub();
                    this.mManager.newSupertypeOfEditor(sup, sub);
                    return true;
                }
                case ACTION_DELETE_SUPERTYPEOF: {
                    ICoreNotificationObjectDeleteSupertypeOf _note7 = (ICoreNotificationObjectDeleteSupertypeOf)note;
                    SimpleModelElement sup = (SimpleModelElement)_note7.getSuper();
                    SimpleModelElement sub = (SimpleModelElement)_note7.getSub();
                    this.mManager.deleteSupertypeOfEditor(sup, sub);
                    return true;
                }
                case ACTION_DELETE_CONTAINMENT: {
                    return false;
                }
                case ACTION_MOVE_ELEMENT_TO: {
                    ICoreNotificationObjectMoveTo _note11 = (ICoreNotificationObjectMoveTo)note;
                    SimpleEntity ent = (SimpleEntity)_note11.getElement();
                    SimpleEntity to = (SimpleEntity)_note11.getNewContainer();
                    this.mManager.moveEntityTo(ent, to);
                    return true;
                }
                case ACTION_SET_VALUE: {
                    ICoreNotificationObjectSetValue _note9 = (ICoreNotificationObjectSetValue)note;
                    SimpleEntity ent = (SimpleEntity)_note9.getEntity();
                    String newValue = _note9.getNewValue();
                    this.mManager.setValue(ent, newValue);
                    return true;
                }
                case ACTION_SET_NAME: {
                    ICoreNotificationObjectSetName _note10 = (ICoreNotificationObjectSetName)note;
                    SimpleModelElement elem = (SimpleModelElement)_note10.getElement();
                    String newName = _note10.getNewName();
                    this.mManager.setName(elem, newName);
                    return true;
                }
                case ACTION_SET_RELATION_FROM: {
                    ICoreNotificationObjectSetRelationFrom _note12 = (ICoreNotificationObjectSetRelationFrom)note;
                    SimpleRelation rel = (SimpleRelation)_note12.getRelation();
                    SimpleModelElement newFrom = (SimpleModelElement)_note12.getNewFrom();
                    this.mManager.setRelationFrom(rel, newFrom);
                    return true;
                }
                case ACTION_SET_RELATION_TO: {
                    ICoreNotificationObjectSetRelationTo _note13 = (ICoreNotificationObjectSetRelationTo)note;
                    SimpleRelation rel = (SimpleRelation)_note13.getRelation();
                    SimpleModelElement newTo = (SimpleModelElement)_note13.getNewTo();
                    this.mManager.setRelationTo(rel, newTo);
                    return true;
                }
                case ACTION_SET_VIEW_INFO: {
                    ICoreNotificationObjectSetViewInfo _note14 = (ICoreNotificationObjectSetViewInfo)note;
                    this.mManager.setViewInfo(_note14.getElement(), _note14.getNewViewInfo());
                    return true;
                }
                case USER_MARK: {
                    return false;
                }
            }
            return false;
        }
        catch (VPMCoreNullParameterException e) {
            this.logger.fatal("Error performing doExecute; [VPMNullParameterException] message: " + e.getMessage());
            return false;
        }
        catch (VPMCoreException e) {
            throw (TraceException)new TraceException("Error performing doExecute; [VPMCoreException] message: " + e.getMessage()).fillInStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean undoEvent(ICoreNotificationObject note) throws TraceException {
        try {
            NotificationType action = note.getActionTypeEnum();
            switch (action) {
                case ACTION_ATOMIC_STEP_READY: {
                    return false;
                }
                case ACTION_CREATE_ENTITY: {
                    ICoreNotificationObjectCreateEntity _note = (ICoreNotificationObjectCreateEntity)note;
                    IEntity ent = _note.getCreated();
                    this.mManager.deleteEntity(ent, EDeleteSemantics.DELETE_SEMANTICS_FORCE);
                    return true;
                }
                case ACTION_DELETE_ENTITY: {
                    ICoreNotificationObjectDeleteEntity _note1 = (ICoreNotificationObjectDeleteEntity)note;
                    IEntity ent1 = _note1.getDeleted();
                    IEntity parent = _note1.getParent();
                    this.mManager.undoCreateEntity((SimpleEntity)ent1, (SimpleEntity)parent);
                    return true;
                }
                case ACTION_CREATE_RELATION: {
                    ICoreNotificationObjectCreateRelation _note2 = (ICoreNotificationObjectCreateRelation)note;
                    IRelation rel = _note2.getNewRelation();
                    this.mManager.deleteRelation(rel, EDeleteSemantics.DELETE_SEMANTICS_FORCE);
                    return true;
                }
                case ACTION_DELETE_RELATION: {
                    ICoreNotificationObjectDeleteRelation _note3 = (ICoreNotificationObjectDeleteRelation)note;
                    this.mManager.undoCreateRelation((SimpleRelation)_note3.getDeleted(), (SimpleModelElement)_note3.getFrom(), (SimpleModelElement)_note3.getTo());
                    return true;
                }
                case ACTION_CREATE_INSTANCEOF: {
                    ICoreNotificationObjectCreateInstanceOf _note4 = (ICoreNotificationObjectCreateInstanceOf)note;
                    SimpleModelElement sup = (SimpleModelElement)_note4.getType();
                    SimpleModelElement sub = (SimpleModelElement)_note4.getInstance();
                    this.mManager.deleteInstanceOfEditor(sup, sub);
                    return true;
                }
                case ACTION_DELETE_INSTANCEOF: {
                    ICoreNotificationObjectDeleteInstanceOf _note5 = (ICoreNotificationObjectDeleteInstanceOf)note;
                    SimpleModelElement sup = (SimpleModelElement)_note5.getType();
                    SimpleModelElement sub = (SimpleModelElement)_note5.getInstance();
                    this.mManager.newInstanceOfEditor(sup, sub);
                    return true;
                }
                case ACTION_CREATE_SUPERTYPEOF: {
                    ICoreNotificationObjectCreateSupertypeOf _note6 = (ICoreNotificationObjectCreateSupertypeOf)note;
                    SimpleModelElement sup = (SimpleModelElement)_note6.getSuper();
                    SimpleModelElement sub = (SimpleModelElement)_note6.getSub();
                    this.mManager.deleteSupertypeOfEditor(sup, sub);
                    return true;
                }
                case ACTION_DELETE_SUPERTYPEOF: {
                    ICoreNotificationObjectDeleteSupertypeOf _note7 = (ICoreNotificationObjectDeleteSupertypeOf)note;
                    SimpleModelElement sup = (SimpleModelElement)_note7.getSuper();
                    SimpleModelElement sub = (SimpleModelElement)_note7.getSub();
                    this.mManager.newSupertypeOfEditor(sup, sub);
                    return true;
                }
                case ACTION_DELETE_CONTAINMENT: {
                    ICoreNotificationObjectDeleteContainment _note8 = (ICoreNotificationObjectDeleteContainment)note;
                    SimpleEntity container = (SimpleEntity)_note8.getParent();
                    SimpleEntity child = (SimpleEntity)_note8.getChild();
                    this.mManager.undoCreateContainment(container, child);
                    return true;
                }
                case ACTION_SET_VALUE: {
                    ICoreNotificationObjectSetValue _note9 = (ICoreNotificationObjectSetValue)note;
                    SimpleEntity ent = (SimpleEntity)_note9.getEntity();
                    String oldValue = _note9.getOldValue();
                    this.mManager.setValue(ent, oldValue);
                    return true;
                }
                case ACTION_SET_NAME: {
                    ICoreNotificationObjectSetName _note10 = (ICoreNotificationObjectSetName)note;
                    SimpleModelElement elem = (SimpleModelElement)_note10.getElement();
                    String oldName = _note10.getOldName();
                    this.mManager.setName(elem, oldName);
                    return true;
                }
                case ACTION_MOVE_ELEMENT_TO: {
                    ICoreNotificationObjectMoveTo _note11 = (ICoreNotificationObjectMoveTo)note;
                    SimpleEntity ent = (SimpleEntity)_note11.getElement();
                    SimpleEntity from = (SimpleEntity)_note11.getOldContainer();
                    this.mManager.moveEntityTo(ent, from);
                    return true;
                }
                case ACTION_SET_RELATION_FROM: {
                    ICoreNotificationObjectSetRelationFrom _note12 = (ICoreNotificationObjectSetRelationFrom)note;
                    SimpleRelation rel = (SimpleRelation)_note12.getRelation();
                    SimpleModelElement oldFrom = (SimpleModelElement)_note12.getOldFrom();
                    this.mManager.setRelationFrom(rel, oldFrom);
                    return true;
                }
                case ACTION_SET_RELATION_TO: {
                    ICoreNotificationObjectSetRelationTo _note13 = (ICoreNotificationObjectSetRelationTo)note;
                    SimpleRelation rel = (SimpleRelation)_note13.getRelation();
                    SimpleModelElement oldTo = (SimpleModelElement)_note13.getOldTo();
                    this.mManager.setRelationTo(rel, oldTo);
                    return true;
                }
                case ACTION_SET_VIEW_INFO: {
                    this.undoSetViewInfo((ICoreNotificationObjectSetViewInfo)note);
                    return true;
                }
                case USER_MARK: {
                    return false;
                }
            }
            return false;
        }
        catch (VPMCoreNullParameterException e) {
            this.logger.fatal("Error performing undo; [VPMNullParameterException] message: " + e.getMessage());
            return false;
        }
        catch (VPMCoreException e) {
            throw (TraceException)new TraceException("Error performing undo; [VPMCoreException] message: " + e.getMessage()).fillInStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    void undoSetViewInfo(ICoreNotificationObjectSetViewInfo note) {
        IModelElement me = note.getElement();
        String oldViewInfo = note.getOldViewInfo();
        try {
            this.mManager.setViewInfo(me, oldViewInfo);
        }
        catch (VPMCoreException e) {
            this.logger.fatal("Error performing undo; message: " + e.getMessage());
        }
    }
}

