/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.core.tracebased;

import org.eclipse.viatra2.core.notification.ICoreNotificationObject;
import org.eclipse.viatra2.core.notification.NotificationType;
import org.eclipse.viatra2.core.tracebased.TraceException;
import org.eclipse.viatra2.core.tracebased.TraceTreeManager;
import org.eclipse.viatra2.core.tracebased.tracetree.AbstractTraceTreeNode;
import org.eclipse.viatra2.core.tracebased.tracetree.AtomicTraceTreeNode;
import org.eclipse.viatra2.core.tracebased.tracetree.CompositeTraceTreeNode;
import org.eclipse.viatra2.core.tracebased.tracetree.EmptyTraceTreeNode;
import org.eclipse.viatra2.core.tracebased.tracetree.ITraceTreeNode;
import org.eclipse.viatra2.core.tracebased.tracetree.TransactionTraceTreeNode;

public class TraceNotificationRegister {
    private boolean enabled = false;
    private long id = 0L;
    private TraceTreeManager manager;

    public TraceNotificationRegister(TraceTreeManager manager) {
        this.manager = manager;
    }

    public void registerNotification(ICoreNotificationObject notification) {
        if (!(this.enabled || notification.getActionTypeEnum().equals((Object)NotificationType.ACTION_SKIP_NOTIFICATIONS_END) || notification.getActionTypeEnum().equals((Object)NotificationType.TA_UNDO_END))) {
            return;
        }
        ITraceTreeNode current = this.manager.getCurrent();
        if (current == null && this.manager.getRoot() == null) {
            current = new EmptyTraceTreeNode(null, this.createID("EmptyTTN"));
            this.manager.setRoot(current);
            this.manager.setCurrent(current);
        }
        try {
            this.handleEvent(notification, current);
        }
        catch (TraceException e) {
            e.printStackTrace();
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private ITraceTreeNode handleEvent(ICoreNotificationObject event, ITraceTreeNode current) throws TraceException {
        boolean subtransaction = false;
        boolean undoable = false;
        ITraceTreeNode newNode = null;
        switch (event.getActionTypeEnum()) {
            case TA_SUBTRANSACTION_BEGIN: {
                throw new TraceException("This notification should not be used by the transaction manager");
            }
            case TA_UNDOABLE_TRANSACTION_BEGIN: {
                undoable = true;
            }
            case TA_TRANSACTION_BEGIN: {
                newNode = this.startTransaction(event, current, undoable);
                break;
            }
            case USER_MARK: {
                this.storeUserMark(event, current);
                break;
            }
            case ACTION_ATOMIC_STEP_READY: {
                this.endAtomicStep(event, current);
                break;
            }
            case TA_SUBTRANSACTION_END: {
                throw new TraceException("This notification should not be used by the transaction manager");
            }
            case TA_TRANSACTION_END: {
                newNode = this.endTransaction(event, current);
                break;
            }
            case ACTION_CREATE_ENTITY: 
            case ACTION_DELETE_ENTITY: 
            case ACTION_CREATE_RELATION: 
            case ACTION_DELETE_RELATION: 
            case ACTION_SET_RELATION_FROM: 
            case ACTION_SET_RELATION_TO: 
            case ACTION_CREATE_INSTANCEOF: 
            case ACTION_DELETE_INSTANCEOF: 
            case ACTION_CREATE_SUPERTYPEOF: 
            case ACTION_DELETE_SUPERTYPEOF: 
            case ACTION_DELETE_CONTAINMENT: 
            case ACTION_SET_VALUE: 
            case ACTION_SET_VIEW_INFO: 
            case ACTION_SET_NAME: 
            case ACTION_SET_ISFINALTYPE: 
            case ACTION_SET_ISANY: 
            case ACTION_MOVE_ELEMENT_TO: 
            case ACTION_SET_RELATION_INVERSE: 
            case ACTION_SET_RELATION_ISAGGREGATION: 
            case ACTION_SET_RELATION_MULTIPLICITY: {
                newNode = this.handleAction(event, current);
                break;
            }
            case ACTION_MORE_ATOMICS_TO_ONE_ATOM_START: {
                throw new TraceException("This notification must be supressed by the notification manager");
            }
            case ACTION_MORE_ATOMICS_TO_ONE_ATOM_END: {
                throw new TraceException("This notification must be supressed by the notification manager");
            }
            case TA_UNDO_BEGIN: {
                this.enabled = false;
                this.undoBegin(current);
                break;
            }
            case TA_UNDO_END: {
                this.enabled = true;
                break;
            }
            case TA_SUBTRANSACTION_ABORT: {
                throw new TraceException("This notification should not be used by the transaction manager");
            }
            case TA_TRANSACTION_ABORT: {
                if (current instanceof TransactionTraceTreeNode) {
                    TransactionTraceTreeNode tttn = (TransactionTraceTreeNode)current;
                    if (!tttn.isTerminated()) {
                        tttn.getEvents().add(event);
                        tttn.setAborted(true);
                        tttn.setTerminated(true);
                        if (!subtransaction) break;
                        if (tttn.isSubTransaction()) {
                            newNode = new TransactionTraceTreeNode(tttn, this.createID("TTTN"), event, false);
                            break;
                        }
                        throw new TraceException("Subtransaction abort called for non-sub transaction");
                    }
                    throw new TraceException("Abort called for terminated transaction");
                }
                throw new TraceException("Abort called outside of transaction");
            }
            case ACTION_SKIP_NOTIFICATIONS_START: {
                newNode = this.skipNotificationStart(event, current);
                break;
            }
            case ACTION_SKIP_NOTIFICATIONS_END: {
                this.skipNotificationEnd(event, current);
            }
        }
        if (newNode != null) {
            this.manager.setCurrent(newNode);
        }
        return null;
    }

    private ITraceTreeNode handleAction(ICoreNotificationObject event, ITraceTreeNode current) {
        if (current instanceof CompositeTraceTreeNode) {
            CompositeTraceTreeNode cttn = (CompositeTraceTreeNode)current;
            if (!cttn.isTerminated()) {
                cttn.getEvents().add(event);
                return null;
            }
            return new AtomicTraceTreeNode(cttn, this.createID("ATTN"), event);
        }
        return new AtomicTraceTreeNode(current, this.createID("ATTN"), event);
    }

    private void undoBegin(ITraceTreeNode current) {
        CompositeTraceTreeNode cttn;
        if (current instanceof CompositeTraceTreeNode && !(cttn = (CompositeTraceTreeNode)current).isTerminated()) {
            cttn.setTerminated(true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void skipNotificationEnd(ICoreNotificationObject event, ITraceTreeNode current) throws TraceException {
        if (this.enabled) {
            throw new TraceException("Skip notification end received while notifications enabled");
        }
        if (!(current instanceof CompositeTraceTreeNode)) throw new TraceException("Skip notification end received outside composite");
        CompositeTraceTreeNode cttn = (CompositeTraceTreeNode)current;
        if (cttn.isTerminated()) throw new TraceException("Skip notification end received in terminated composite");
        cttn.getEvents().add(event);
        if (cttn.getEvents().get(0).getActionTypeEnum().equals((Object)NotificationType.ACTION_SKIP_NOTIFICATIONS_START)) {
            cttn.setTerminated(true);
        }
        this.enabled = true;
    }

    private ITraceTreeNode skipNotificationStart(ICoreNotificationObject event, ITraceTreeNode current) {
        this.enabled = false;
        if (current instanceof CompositeTraceTreeNode) {
            CompositeTraceTreeNode cttn = (CompositeTraceTreeNode)current;
            if (!cttn.isTerminated()) {
                cttn.getEvents().add(event);
                return null;
            }
            return new CompositeTraceTreeNode(cttn, this.createID("CTTN"), event);
        }
        return new CompositeTraceTreeNode(current, this.createID("CTTN"), event);
    }

    private ITraceTreeNode endTransaction(ICoreNotificationObject event, ITraceTreeNode current) throws TraceException {
        if (current instanceof TransactionTraceTreeNode) {
            TransactionTraceTreeNode tttn = (TransactionTraceTreeNode)current;
            if (!tttn.isTerminated()) {
                tttn.getEvents().add(event);
                tttn.setTerminated(true);
                if (tttn.getLevel() > 0) {
                    return new TransactionTraceTreeNode(tttn, this.createID("TTTN"), event, false);
                }
                tttn.setCommitted(true);
                return null;
            }
            throw new TraceException("Transaction end received for terminated transaction");
        }
        throw new TraceException("Transaction end received outside transaction");
    }

    private void endAtomicStep(ICoreNotificationObject event, ITraceTreeNode current) throws TraceException {
        if (current instanceof CompositeTraceTreeNode) {
            CompositeTraceTreeNode cttn = (CompositeTraceTreeNode)current;
            if (!cttn.isTerminated()) {
                cttn.getEvents().add(event);
                if (current instanceof AtomicTraceTreeNode) {
                    AtomicTraceTreeNode attn = (AtomicTraceTreeNode)current;
                    attn.setTerminated(true);
                }
            }
        } else {
            throw new TraceException("Atomic step ready received outside composite");
        }
    }

    private void storeUserMark(ICoreNotificationObject event, ITraceTreeNode current) throws TraceException {
        TransactionTraceTreeNode cttn;
        if (current instanceof TransactionTraceTreeNode) {
            cttn = (TransactionTraceTreeNode)current;
            if (cttn.isTerminated()) {
                throw new TraceException("User mark received in terminated transaction");
            }
        } else {
            throw new TraceException("User mark received outside of transaction");
        }
        cttn.getEvents().add(event);
    }

    private ITraceTreeNode startTransaction(ICoreNotificationObject event, ITraceTreeNode current, boolean undoable) {
        boolean subtransaction = false;
        AbstractTraceTreeNode attn = (AbstractTraceTreeNode)current;
        if (!attn.isTerminated()) {
            attn.setTerminated(true);
        }
        if (current instanceof TransactionTraceTreeNode && !((TransactionTraceTreeNode)current).isCommitted()) {
            subtransaction = true;
        }
        return new TransactionTraceTreeNode(attn, this.createID("TTTN"), event, subtransaction, undoable);
    }

    private String createID(String type) {
        String idS = String.format("%s_%d", type, this.id);
        ++this.id;
        return idS;
    }
}

