/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.core.tracebased;

import org.eclipse.viatra2.core.IPause;
import org.eclipse.viatra2.core.ITransactionManager;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectTransactionBegin;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectTransactionEnd;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectUndoBegin;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectUndoEnd;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectUndoableTransactionBegin;
import org.eclipse.viatra2.core.tracebased.TraceModelSpace;
import org.eclipse.viatra2.core.tracebased.TraceNotificationManager;
import org.eclipse.viatra2.core.tracebased.TraceUndoManager;
import org.eclipse.viatra2.core.tracebased.tracetree.ITraceTreeNode;
import org.eclipse.viatra2.core.tracebased.tracetree.TransactionTraceTreeNode;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.logger.Logger;

public class TraceTransactionManager
implements ITransactionManager {
    private TraceUndoManager uManager;
    private TraceModelSpace m;

    @Override
    public String beginUndoableTransaction() {
        return this.beginUndoableTransaction(null);
    }

    @Override
    public String beginUndoableTransaction(Object info) {
        TraceNotificationManager notificationManager = (TraceNotificationManager)this.m.getNotificationManager();
        notificationManager.setEnabled(true);
        notificationManager.sendNotification(new NotificationObjectUndoableTransactionBegin(info));
        String id = this.m.getTraceManager().getCurrent().getID();
        this.uManager.nextUndoBlock(id);
        return id;
    }

    @Override
    public String beginTransaction() {
        return this.beginTransaction(null);
    }

    @Override
    public String beginTransaction(Object info) {
        ((TraceNotificationManager)this.m.getNotificationManager()).sendNotification(new NotificationObjectTransactionBegin(info));
        ITraceTreeNode current = this.m.getTraceManager().getCurrent();
        if (current != null) {
            return current.getID();
        }
        return "SimpleTransaction";
    }

    @Override
    public boolean tryBeginTransaction() {
        ITraceTreeNode current = this.m.getTraceManager().getCurrent();
        if (current instanceof TransactionTraceTreeNode) {
            return ((TransactionTraceTreeNode)current).isTerminated();
        }
        return true;
    }

    @Override
    public void commitTransaction() {
        ITraceTreeNode current = this.m.getTraceManager().getCurrent();
        if (current instanceof TransactionTraceTreeNode) {
            if (!((TransactionTraceTreeNode)current).isTerminated()) {
                ((TraceNotificationManager)this.m.getNotificationManager()).sendNotification(new NotificationObjectTransactionEnd());
            }
        } else if (current == null) {
            ((TraceNotificationManager)this.m.getNotificationManager()).sendNotification(new NotificationObjectTransactionEnd());
        }
    }

    @Override
    public void commitCompositeTransaction() {
        ITraceTreeNode current = this.m.getTraceManager().getCurrent();
        if (current == null) {
            ((TraceNotificationManager)this.m.getNotificationManager()).sendNotification(new NotificationObjectTransactionEnd());
        }
        while (current != null) {
            TransactionTraceTreeNode tttn;
            if (!(current instanceof TransactionTraceTreeNode) || (tttn = (TransactionTraceTreeNode)current).isTerminated()) break;
            ((TraceNotificationManager)this.m.getNotificationManager()).sendNotification(new NotificationObjectTransactionEnd());
            current = this.m.getTraceManager().getCurrent();
        }
    }

    @Override
    public void abortTransaction() {
        this.m.getFramework().getLogger().error("Semantics for transaction abort not defined!");
    }

    @Override
    public void undoTransaction(String aTransactionID) {
        ((TraceNotificationManager)this.m.getNotificationManager()).sendNotification(new NotificationObjectUndoBegin());
        this.uManager.undo(aTransactionID);
        ((TraceNotificationManager)this.m.getNotificationManager()).sendNotification(new NotificationObjectUndoEnd());
    }

    @Override
    public IPause pauseTransaction() throws IllegalMonitorStateException {
        this.m.getFramework().getLogger().error("Transactions cannot be paused!");
        return null;
    }

    @Override
    public void unPauseTransaction(IPause n) {
        this.m.getFramework().getLogger().error("Transactions cannot be paused!");
    }

    public void init(Logger logger, TraceModelSpace traceModelSpace) throws VPMRuntimeException {
        this.uManager = new TraceUndoManager();
        this.m = traceModelSpace;
        this.uManager.init(logger, this.m);
    }
}

