/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.core.tracebased;

import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.core.tracebased.TraceNotificationProcessor;
import org.eclipse.viatra2.core.tracebased.TraceNotificationRegister;
import org.eclipse.viatra2.core.tracebased.tracetree.ITraceTreeNode;
import org.eclipse.viatra2.framework.IFramework;

public class TraceTreeManager {
    protected ITraceTreeNode root;
    protected ITraceTreeNode current;
    protected TraceNotificationRegister register;
    protected TraceNotificationProcessor traceProcessor;

    public TraceTreeManager(IFramework framework, IModelManager mManager) {
        this.traceProcessor = new TraceNotificationProcessor(this, framework, mManager);
        this.register = new TraceNotificationRegister(this);
        this.register.setEnabled(true);
    }

    public ITraceTreeNode getCurrent() {
        return this.current;
    }

    public void setCurrent(ITraceTreeNode current) {
        this.current = current;
    }

    public ITraceTreeNode getRoot() {
        return this.root;
    }

    public void setRoot(ITraceTreeNode root) {
        this.root = root;
    }

    public void exportCompleteTrace(StringBuilder exportString) {
        if (this.root != null) {
            this.exportTrace(this.root, exportString, 0);
        }
    }

    public void exportTrace(ITraceTreeNode node, StringBuilder exportString, int depth) {
        exportString.append(node.toString());
        if (node.getChildren().size() > 0) {
            ++depth;
            for (ITraceTreeNode child : node.getOrderedChildrenList()) {
                exportString.append("\n");
                int i = 0;
                while (i < depth) {
                    exportString.append(" ");
                    ++i;
                }
                exportString.append("\\(").append(depth).append(")->");
                this.exportTrace(child, exportString, depth);
            }
        }
    }

    public TraceNotificationProcessor getTraceProcessor() {
        return this.traceProcessor;
    }
}

