/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.core.tracebased;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.core.IUndoManager;
import org.eclipse.viatra2.core.notification.ICoreNotificationObject;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectTransactionEnd;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectUserMark;
import org.eclipse.viatra2.core.tracebased.TraceException;
import org.eclipse.viatra2.core.tracebased.TraceModelManager;
import org.eclipse.viatra2.core.tracebased.TraceModelSpace;
import org.eclipse.viatra2.core.tracebased.TraceNotificationManager;
import org.eclipse.viatra2.core.tracebased.tracetree.ITraceTreeNode;
import org.eclipse.viatra2.core.tracebased.tracetree.TransactionTraceTreeNode;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.logger.Logger;

public class TraceUndoManager
implements IUndoManager {
    TraceModelSpace modelSpace;
    TraceModelManager mManager;
    Logger logger;

    @Override
    public void init(Logger l, IModelSpace m) throws VPMRuntimeException {
        this.logger = l;
        this.modelSpace = (TraceModelSpace)m;
        this.mManager = (TraceModelManager)this.modelSpace.getModelManager();
    }

    @Override
    public void nextUndoBlock(String name) {
        ((TraceNotificationManager)this.modelSpace.getNotificationManager()).sendNotification(new NotificationObjectUserMark(name));
    }

    @Override
    public boolean canUndo() {
        return !this.getUndoInfoFromTraceTree(true, 1).isEmpty();
    }

    @Override
    public List<String> getUndoList(int n) {
        return this.getUndoInfoFromTraceTree(true, n);
    }

    @Override
    public void flushUndoBuffer() {
        this.logger.info("Trace based undo manager has no buffer");
    }

    @Override
    public void undo() {
        this.undoLastTransaction();
    }

    @Override
    public void undo(int n) {
        int i = 0;
        while (i < n) {
            this.undo();
            ++i;
        }
    }

    @Override
    public void undo(String markName) {
        String last = null;
        while ((last = this.undoLastTransaction()) != null) {
            if (last.equals(markName)) break;
        }
    }

    @Override
    public void undo(String markName, int n) {
        int i = 0;
        while (i < n) {
            this.undo(markName);
            ++i;
        }
    }

    @Override
    public List<String> getUndoableList() {
        return this.getUndoInfoFromTraceTree(false, -1);
    }

    private String undoLastTransaction() {
        ITraceTreeNode current;
        while ((current = this.modelSpace.getTraceManager().getCurrent()) != this.modelSpace.getTraceManager().getRoot()) {
            try {
                current.undo(this.modelSpace.getFramework());
            }
            catch (TraceException e) {
                this.logger.fatal("Error performing undo; message:" + e.getMessage());
                return null;
            }
            if (!(current instanceof TransactionTraceTreeNode) || !((TransactionTraceTreeNode)current).isUndoable()) continue;
            return current.getID();
        }
        this.logger.fatal("Error performing undo, trace tree root reached");
        return null;
    }

    private List<String> getUndoInfoFromTraceTree(boolean onlyUserMarks, int numberOfUndos) {
        ArrayList<String> userMarks = new ArrayList<String>();
        ArrayList operations = new ArrayList();
        ArrayList potentials = new ArrayList();
        ITraceTreeNode current = this.modelSpace.getTraceManager().getCurrent();
        boolean userMark = false;
        boolean partialTrans = false;
        while (current != null) {
            if (!(current instanceof TransactionTraceTreeNode)) break;
            TransactionTraceTreeNode tttn = (TransactionTraceTreeNode)current;
            ArrayList<String> events = new ArrayList<String>();
            if (tttn.getEvents().size() > 0 && tttn.getEvents().get(0) instanceof ICoreNotificationObjectTransactionEnd) {
                partialTrans = true;
            }
            if (tttn.isUndoable()) {
                userMark = true;
                if (onlyUserMarks) {
                    userMarks.add(tttn.getID());
                    if (numberOfUndos > 0 && userMarks.size() == numberOfUndos) break;
                }
            }
            if (!onlyUserMarks) {
                for (ICoreNotificationObject event : tttn.getEvents()) {
                    events.add(event.toString());
                }
                if (userMark) {
                    operations.addAll(potentials);
                    potentials.clear();
                    operations.add(events);
                } else {
                    if (!partialTrans && !tttn.isSubTransaction()) break;
                    potentials.add(events);
                }
            }
            current = current.getParent();
        }
        if (onlyUserMarks) {
            return userMarks;
        }
        ArrayList<String> resList = new ArrayList<String>();
        Collections.reverse(operations);
        for (List list : operations) {
            resList.addAll(list);
        }
        return resList;
    }
}

